/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.data.general.Series;

public class MatrixSeries
extends Series
implements Serializable {
    private static final long serialVersionUID = 7934188527308315704L;
    protected double[][] data;

    public MatrixSeries(String name, int rows, int columns) {
        super((Comparable)((Object)name));
        this.data = new double[rows][columns];
        this.zeroAll();
    }

    public int getColumnsCount() {
        return this.data[0].length;
    }

    public Number getItem(int itemIndex) {
        int i2 = this.getItemRow(itemIndex);
        int j2 = this.getItemColumn(itemIndex);
        Double n2 = new Double(this.get(i2, j2));
        return n2;
    }

    public int getItemColumn(int itemIndex) {
        return itemIndex % this.getColumnsCount();
    }

    public int getItemCount() {
        return this.getRowCount() * this.getColumnsCount();
    }

    public int getItemRow(int itemIndex) {
        return itemIndex / this.getColumnsCount();
    }

    public int getRowCount() {
        return this.data.length;
    }

    public double get(int i2, int j2) {
        return this.data[i2][j2];
    }

    public void update(int i2, int j2, double mij) {
        this.data[i2][j2] = mij;
        this.fireSeriesChanged();
    }

    public void zeroAll() {
        int rows = this.getRowCount();
        int columns = this.getColumnsCount();
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.data[row][column] = 0.0;
            }
        }
        this.fireSeriesChanged();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MatrixSeries)) {
            return false;
        }
        MatrixSeries that = (MatrixSeries)obj;
        if (this.getRowCount() != that.getRowCount()) {
            return false;
        }
        if (this.getColumnsCount() != that.getColumnsCount()) {
            return false;
        }
        for (int r2 = 0; r2 < this.getRowCount(); ++r2) {
            for (int c2 = 0; c2 < this.getColumnsCount(); ++c2) {
                if (this.get(r2, c2) == that.get(r2, c2)) continue;
                return false;
            }
        }
        return super.equals(obj);
    }
}

