/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import htsjdk.tribble.readers.LineIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.AsciiDecoder;
import org.broad.igv.cli_plugin.LineFeatureDecoder;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.tribble.IGVBEDCodec;

public final class BEDToolsDecoder
extends AsciiDecoder<BasicFeature>
implements LineFeatureDecoder<BasicFeature> {
    private IGVBEDCodec BEDCodec = new IGVBEDCodec();
    private boolean hasSplit = false;
    private int numTracks = 0;
    private int[] numCols = null;
    private boolean multiinter;
    private boolean closestOrSim;

    public BEDToolsDecoder() {
        this.lineFeatureDecoder = this;
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap) {
        super.setInputs(commands, argumentMap);
        for (String string : commands) {
            this.hasSplit |= string.contains("-split");
        }
        this.multiinter = commands.contains("multiinter");
        this.closestOrSim = commands.contains("window") || commands.contains("closest");
        for (Map.Entry entry : argumentMap.entrySet()) {
            Argument curArg = (Argument)entry.getKey();
            this.hasSplit |= curArg.getCmdArg().contains("-split");
            switch (curArg.getType()) {
                case TEXT: {
                    String sVal = (String)entry.getValue();
                    if (sVal == null) break;
                    this.hasSplit |= sVal.contains("-split");
                    break;
                }
                case FEATURE_TRACK: {
                    ++this.numTracks;
                    break;
                }
                case MULTI_FEATURE_TRACK: {
                    this.numTracks += ((List)entry.getValue()).size();
                }
            }
        }
    }

    @Override
    public BasicFeature decode(String line) {
        return this.decode(Globals.singleTabMultiSpacePattern.split(line));
    }

    @Override
    public Object readActualHeader(LineIterator reader) throws IOException {
        return null;
    }

    public BasicFeature decode(String[] tokens) {
        BasicFeature feat;
        if (this.hasSplit) {
            tokens = Arrays.copyOfRange(tokens, 0, Math.min(6, tokens.length));
        }
        if (this.closestOrSim) {
            String[] closest = Arrays.copyOfRange(tokens, this.numCols[0], this.numCols[0] + this.numCols[1]);
            if (closest[1].trim().equalsIgnoreCase("-1")) {
                return null;
            }
            feat = this.BEDCodec.decode(closest);
        } else if (this.multiinter) {
            int numRegions = Integer.parseInt(tokens[3]);
            if (numRegions < this.numTracks) {
                return null;
            }
            String[] intersection = Arrays.copyOf(tokens, 3);
            feat = this.BEDCodec.decode(intersection);
        } else {
            feat = this.BEDCodec.decode(tokens);
        }
        return feat;
    }

    @Override
    public void setAttributes(List<Map<String, Object>> attributes) {
        super.setAttributes(attributes);
        this.numCols = new int[attributes.size()];
        int ind = 0;
        for (Map<String, Object> attributeMap : attributes) {
            int curOutCols = (Integer)attributeMap.get("numCols");
            this.numCols[ind++] = curOutCols;
        }
    }
}

