/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.exception.ExtCertPathValidatorException;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jce.provider.CertStatus;
import org.bouncycastle.jce.provider.PKIXCRLUtil;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidatorException;
import org.bouncycastle.jce.provider.PKIXPolicyNode;
import org.bouncycastle.jce.provider.ReasonsMask;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.x509.ExtendedPKIXBuilderParameters;
import org.bouncycastle.x509.ExtendedPKIXParameters;
import org.bouncycastle.x509.X509CRLStoreSelector;
import org.bouncycastle.x509.X509CertStoreSelector;

public class RFC3280CertPathUtilities {
    private static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    protected static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    protected static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    protected static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    protected static final String FRESHEST_CRL = X509Extensions.FreshestCRL.getId();
    protected static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    protected static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    protected static final String CRL_DISTRIBUTION_POINTS = X509Extensions.CRLDistributionPoints.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    protected static final String AUTHORITY_KEY_IDENTIFIER = X509Extensions.AuthorityKeyIdentifier.getId();
    protected static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    protected static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    protected static void processCRLB2(DistributionPoint dp, Object cert, X509CRL crl) throws AnnotatedException {
        IssuingDistributionPoint idp = null;
        try {
            idp = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(crl, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception e2) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", e2);
        }
        if (idp != null) {
            if (idp.getDistributionPoint() != null) {
                DistributionPointName dpName = IssuingDistributionPoint.getInstance(idp).getDistributionPoint();
                ArrayList<GeneralName> names = new ArrayList<GeneralName>();
                if (dpName.getType() == 0) {
                    GeneralName[] genNames = GeneralNames.getInstance(dpName.getName()).getNames();
                    for (int j2 = 0; j2 < genNames.length; ++j2) {
                        names.add(genNames[j2]);
                    }
                }
                if (dpName.getType() == 1) {
                    ASN1EncodableVector vec = new ASN1EncodableVector();
                    try {
                        Enumeration e3 = ASN1Sequence.getInstance(ASN1Sequence.fromByteArray(CertPathValidatorUtilities.getIssuerPrincipal(crl).getEncoded())).getObjects();
                        while (e3.hasMoreElements()) {
                            vec.add((ASN1Encodable)e3.nextElement());
                        }
                    }
                    catch (IOException e4) {
                        throw new AnnotatedException("Could not read CRL issuer.", e4);
                    }
                    vec.add(dpName.getName());
                    names.add(new GeneralName(X509Name.getInstance(new DERSequence(vec))));
                }
                boolean matches = false;
                if (dp.getDistributionPoint() != null) {
                    int j3;
                    dpName = dp.getDistributionPoint();
                    GeneralName[] genNames = null;
                    if (dpName.getType() == 0) {
                        genNames = GeneralNames.getInstance(dpName.getName()).getNames();
                    }
                    if (dpName.getType() == 1) {
                        if (dp.getCRLIssuer() != null) {
                            genNames = dp.getCRLIssuer().getNames();
                        } else {
                            genNames = new GeneralName[1];
                            try {
                                genNames[0] = new GeneralName(new X509Name((ASN1Sequence)ASN1Sequence.fromByteArray(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).getEncoded())));
                            }
                            catch (IOException e5) {
                                throw new AnnotatedException("Could not read certificate issuer.", e5);
                            }
                        }
                        for (j3 = 0; j3 < genNames.length; ++j3) {
                            Enumeration e6 = ASN1Sequence.getInstance(genNames[j3].getName().toASN1Primitive()).getObjects();
                            ASN1EncodableVector vec = new ASN1EncodableVector();
                            while (e6.hasMoreElements()) {
                                vec.add((ASN1Encodable)e6.nextElement());
                            }
                            vec.add(dpName.getName());
                            genNames[j3] = new GeneralName(new X509Name(new DERSequence(vec)));
                        }
                    }
                    if (genNames != null) {
                        for (j3 = 0; j3 < genNames.length; ++j3) {
                            if (!names.contains(genNames[j3])) continue;
                            matches = true;
                            break;
                        }
                    }
                    if (!matches) {
                        throw new AnnotatedException("No match for certificate CRL issuing distribution point name to cRLIssuer CRL distribution point.");
                    }
                } else {
                    if (dp.getCRLIssuer() == null) {
                        throw new AnnotatedException("Either the cRLIssuer or the distributionPoint field must be contained in DistributionPoint.");
                    }
                    GeneralName[] genNames = dp.getCRLIssuer().getNames();
                    for (int j4 = 0; j4 < genNames.length; ++j4) {
                        if (!names.contains(genNames[j4])) continue;
                        matches = true;
                        break;
                    }
                    if (!matches) {
                        throw new AnnotatedException("No match for certificate CRL issuing distribution point name to cRLIssuer CRL distribution point.");
                    }
                }
            }
            BasicConstraints bc = null;
            try {
                bc = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue((X509Extension)cert, BASIC_CONSTRAINTS));
            }
            catch (Exception e7) {
                throw new AnnotatedException("Basic constraints extension could not be decoded.", e7);
            }
            if (cert instanceof X509Certificate) {
                if (idp.onlyContainsUserCerts() && bc != null && bc.isCA()) {
                    throw new AnnotatedException("CA Cert CRL only contains user certificates.");
                }
                if (idp.onlyContainsCACerts() && (bc == null || !bc.isCA())) {
                    throw new AnnotatedException("End CRL only contains CA certificates.");
                }
            }
            if (idp.onlyContainsAttributeCerts()) {
                throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted.");
            }
        }
    }

    protected static void processCRLB1(DistributionPoint dp, Object cert, X509CRL crl) throws AnnotatedException {
        ASN1Primitive idp = CertPathValidatorUtilities.getExtensionValue(crl, ISSUING_DISTRIBUTION_POINT);
        boolean isIndirect = false;
        if (idp != null && IssuingDistributionPoint.getInstance(idp).isIndirectCRL()) {
            isIndirect = true;
        }
        byte[] issuerBytes = CertPathValidatorUtilities.getIssuerPrincipal(crl).getEncoded();
        boolean matchIssuer = false;
        if (dp.getCRLIssuer() != null) {
            GeneralName[] genNames = dp.getCRLIssuer().getNames();
            for (int j2 = 0; j2 < genNames.length; ++j2) {
                if (genNames[j2].getTagNo() != 4) continue;
                try {
                    if (!Arrays.areEqual(genNames[j2].getName().toASN1Primitive().getEncoded(), issuerBytes)) continue;
                    matchIssuer = true;
                    continue;
                }
                catch (IOException e2) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", e2);
                }
            }
            if (matchIssuer && !isIndirect) {
                throw new AnnotatedException("Distribution point contains cRLIssuer field but CRL is not indirect.");
            }
            if (!matchIssuer) {
                throw new AnnotatedException("CRL issuer of CRL does not match CRL issuer of distribution point.");
            }
        } else if (CertPathValidatorUtilities.getIssuerPrincipal(crl).equals(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert))) {
            matchIssuer = true;
        }
        if (!matchIssuer) {
            throw new AnnotatedException("Cannot find matching CRL issuer for certificate.");
        }
    }

    protected static ReasonsMask processCRLD(X509CRL crl, DistributionPoint dp) throws AnnotatedException {
        IssuingDistributionPoint idp = null;
        try {
            idp = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(crl, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception e2) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", e2);
        }
        if (idp != null && idp.getOnlySomeReasons() != null && dp.getReasons() != null) {
            return new ReasonsMask(dp.getReasons()).intersect(new ReasonsMask(idp.getOnlySomeReasons()));
        }
        if ((idp == null || idp.getOnlySomeReasons() == null) && dp.getReasons() == null) {
            return ReasonsMask.allReasons;
        }
        return (dp.getReasons() == null ? ReasonsMask.allReasons : new ReasonsMask(dp.getReasons())).intersect(idp == null ? ReasonsMask.allReasons : new ReasonsMask(idp.getOnlySomeReasons()));
    }

    protected static Set processCRLF(X509CRL crl, Object cert, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, ExtendedPKIXParameters paramsPKIX, List certPathCerts) throws AnnotatedException {
        Collection coll;
        X509CertStoreSelector selector = new X509CertStoreSelector();
        try {
            byte[] issuerPrincipal = CertPathValidatorUtilities.getIssuerPrincipal(crl).getEncoded();
            selector.setSubject(issuerPrincipal);
        }
        catch (IOException e2) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate for CRL could not be set.", e2);
        }
        try {
            coll = CertPathValidatorUtilities.findCertificates(selector, paramsPKIX.getStores());
            coll.addAll(CertPathValidatorUtilities.findCertificates(selector, paramsPKIX.getAdditionalStores()));
            coll.addAll(CertPathValidatorUtilities.findCertificates(selector, paramsPKIX.getCertStores()));
        }
        catch (AnnotatedException e3) {
            throw new AnnotatedException("Issuer certificate for CRL cannot be searched.", e3);
        }
        coll.add(defaultCRLSignCert);
        Iterator cert_it = coll.iterator();
        ArrayList<X509Certificate> validCerts = new ArrayList<X509Certificate>();
        ArrayList<PublicKey> validKeys = new ArrayList<PublicKey>();
        while (cert_it.hasNext()) {
            X509Certificate signingCert = (X509Certificate)cert_it.next();
            if (signingCert.equals(defaultCRLSignCert)) {
                validCerts.add(signingCert);
                validKeys.add(defaultCRLSignKey);
                continue;
            }
            try {
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", BouncyCastleProvider.PROVIDER_NAME);
                selector = new X509CertStoreSelector();
                selector.setCertificate(signingCert);
                ExtendedPKIXParameters temp = (ExtendedPKIXParameters)paramsPKIX.clone();
                temp.setTargetCertConstraints(selector);
                ExtendedPKIXBuilderParameters params = (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance(temp);
                if (certPathCerts.contains(signingCert)) {
                    params.setRevocationEnabled(false);
                } else {
                    params.setRevocationEnabled(true);
                }
                List<? extends Certificate> certs = builder.build(params).getCertPath().getCertificates();
                validCerts.add(signingCert);
                validKeys.add(CertPathValidatorUtilities.getNextWorkingKey(certs, 0));
            }
            catch (CertPathBuilderException e4) {
                throw new AnnotatedException("Internal error.", e4);
            }
            catch (CertPathValidatorException e5) {
                throw new AnnotatedException("Public key of issuer certificate of CRL could not be retrieved.", e5);
            }
            catch (Exception e6) {
                throw new RuntimeException(e6.getMessage());
            }
        }
        HashSet checkKeys = new HashSet();
        AnnotatedException lastException = null;
        for (int i2 = 0; i2 < validCerts.size(); ++i2) {
            X509Certificate signCert = (X509Certificate)validCerts.get(i2);
            boolean[] keyusage = signCert.getKeyUsage();
            if (!(keyusage == null || keyusage.length >= 7 && keyusage[6])) {
                lastException = new AnnotatedException("Issuer certificate key usage extension does not permit CRL signing.");
                continue;
            }
            checkKeys.add(validKeys.get(i2));
        }
        if (checkKeys.isEmpty() && lastException == null) {
            throw new AnnotatedException("Cannot find a valid issuer certificate.");
        }
        if (checkKeys.isEmpty() && lastException != null) {
            throw lastException;
        }
        return checkKeys;
    }

    protected static PublicKey processCRLG(X509CRL crl, Set keys) throws AnnotatedException {
        Exception lastException = null;
        for (PublicKey key : keys) {
            try {
                crl.verify(key);
                return key;
            }
            catch (Exception e2) {
                lastException = e2;
            }
        }
        throw new AnnotatedException("Cannot verify CRL.", lastException);
    }

    protected static X509CRL processCRLH(Set deltacrls, PublicKey key) throws AnnotatedException {
        Exception lastException = null;
        for (X509CRL crl : deltacrls) {
            try {
                crl.verify(key);
                return crl;
            }
            catch (Exception e2) {
                lastException = e2;
            }
        }
        if (lastException != null) {
            throw new AnnotatedException("Cannot verify delta CRL.", lastException);
        }
        return null;
    }

    protected static Set processCRLA1i(Date currentDate, ExtendedPKIXParameters paramsPKIX, X509Certificate cert, X509CRL crl) throws AnnotatedException {
        HashSet set = new HashSet();
        if (paramsPKIX.isUseDeltasEnabled()) {
            CRLDistPoint freshestCRL = null;
            try {
                freshestCRL = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, FRESHEST_CRL));
            }
            catch (AnnotatedException e2) {
                throw new AnnotatedException("Freshest CRL extension could not be decoded from certificate.", e2);
            }
            if (freshestCRL == null) {
                try {
                    freshestCRL = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(crl, FRESHEST_CRL));
                }
                catch (AnnotatedException e3) {
                    throw new AnnotatedException("Freshest CRL extension could not be decoded from CRL.", e3);
                }
            }
            if (freshestCRL != null) {
                try {
                    CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(freshestCRL, paramsPKIX);
                }
                catch (AnnotatedException e4) {
                    throw new AnnotatedException("No new delta CRL locations could be added from Freshest CRL extension.", e4);
                }
                try {
                    set.addAll(CertPathValidatorUtilities.getDeltaCRLs(currentDate, paramsPKIX, crl));
                }
                catch (AnnotatedException e5) {
                    throw new AnnotatedException("Exception obtaining delta CRLs.", e5);
                }
            }
        }
        return set;
    }

    protected static Set[] processCRLA1ii(Date currentDate, ExtendedPKIXParameters paramsPKIX, X509Certificate cert, X509CRL crl) throws AnnotatedException {
        HashSet deltaSet = new HashSet();
        X509CRLStoreSelector crlselect = new X509CRLStoreSelector();
        crlselect.setCertificateChecking(cert);
        try {
            crlselect.addIssuerName(crl.getIssuerX500Principal().getEncoded());
        }
        catch (IOException e2) {
            throw new AnnotatedException("Cannot extract issuer from CRL." + e2, e2);
        }
        crlselect.setCompleteCRLEnabled(true);
        Set completeSet = CRL_UTIL.findCRLs(crlselect, paramsPKIX, currentDate);
        if (paramsPKIX.isUseDeltasEnabled()) {
            try {
                deltaSet.addAll(CertPathValidatorUtilities.getDeltaCRLs(currentDate, paramsPKIX, crl));
            }
            catch (AnnotatedException e3) {
                throw new AnnotatedException("Exception obtaining delta CRLs.", e3);
            }
        }
        return new Set[]{completeSet, deltaSet};
    }

    protected static void processCRLC(X509CRL deltaCRL, X509CRL completeCRL, ExtendedPKIXParameters pkixParams) throws AnnotatedException {
        if (deltaCRL == null) {
            return;
        }
        IssuingDistributionPoint completeidp = null;
        try {
            completeidp = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(completeCRL, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception e2) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", e2);
        }
        if (pkixParams.isUseDeltasEnabled()) {
            if (!deltaCRL.getIssuerX500Principal().equals(completeCRL.getIssuerX500Principal())) {
                throw new AnnotatedException("Complete CRL issuer does not match delta CRL issuer.");
            }
            IssuingDistributionPoint deltaidp = null;
            try {
                deltaidp = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(deltaCRL, ISSUING_DISTRIBUTION_POINT));
            }
            catch (Exception e3) {
                throw new AnnotatedException("Issuing distribution point extension from delta CRL could not be decoded.", e3);
            }
            boolean match = false;
            if (completeidp == null) {
                if (deltaidp == null) {
                    match = true;
                }
            } else if (completeidp.equals(deltaidp)) {
                match = true;
            }
            if (!match) {
                throw new AnnotatedException("Issuing distribution point extension from delta CRL and complete CRL does not match.");
            }
            ASN1Primitive completeKeyIdentifier = null;
            try {
                completeKeyIdentifier = CertPathValidatorUtilities.getExtensionValue(completeCRL, AUTHORITY_KEY_IDENTIFIER);
            }
            catch (AnnotatedException e4) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from complete CRL.", e4);
            }
            ASN1Primitive deltaKeyIdentifier = null;
            try {
                deltaKeyIdentifier = CertPathValidatorUtilities.getExtensionValue(deltaCRL, AUTHORITY_KEY_IDENTIFIER);
            }
            catch (AnnotatedException e5) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from delta CRL.", e5);
            }
            if (completeKeyIdentifier == null) {
                throw new AnnotatedException("CRL authority key identifier is null.");
            }
            if (deltaKeyIdentifier == null) {
                throw new AnnotatedException("Delta CRL authority key identifier is null.");
            }
            if (!completeKeyIdentifier.equals(deltaKeyIdentifier)) {
                throw new AnnotatedException("Delta CRL authority key identifier does not match complete CRL authority key identifier.");
            }
        }
    }

    protected static void processCRLI(Date validDate, X509CRL deltacrl, Object cert, CertStatus certStatus, ExtendedPKIXParameters pkixParams) throws AnnotatedException {
        if (pkixParams.isUseDeltasEnabled() && deltacrl != null) {
            CertPathValidatorUtilities.getCertStatus(validDate, deltacrl, cert, certStatus);
        }
    }

    protected static void processCRLJ(Date validDate, X509CRL completecrl, Object cert, CertStatus certStatus) throws AnnotatedException {
        if (certStatus.getCertStatus() == 11) {
            CertPathValidatorUtilities.getCertStatus(validDate, completecrl, cert, certStatus);
        }
    }

    protected static PKIXPolicyNode prepareCertB(CertPath certPath, int index, List[] policyNodes, PKIXPolicyNode validPolicyTree, int policyMapping) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        int n2 = certs.size();
        int i2 = n2 - index;
        ASN1Sequence pm = null;
        try {
            pm = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, POLICY_MAPPINGS));
        }
        catch (AnnotatedException ex) {
            throw new ExtCertPathValidatorException("Policy mappings extension could not be decoded.", (Throwable)ex, certPath, index);
        }
        PKIXPolicyNode _validPolicyTree = validPolicyTree;
        if (pm != null) {
            ASN1Sequence mappings = pm;
            HashMap m_idp = new HashMap();
            HashSet<String> s_idp = new HashSet<String>();
            for (int j2 = 0; j2 < mappings.size(); ++j2) {
                Set<String> tmp;
                ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j2);
                String id_p = ((DERObjectIdentifier)mapping.getObjectAt(0)).getId();
                String sd_p = ((DERObjectIdentifier)mapping.getObjectAt(1)).getId();
                if (!m_idp.containsKey(id_p)) {
                    tmp = new HashSet<String>();
                    tmp.add(sd_p);
                    m_idp.put(id_p, tmp);
                    s_idp.add(id_p);
                    continue;
                }
                tmp = (Set)m_idp.get(id_p);
                tmp.add(sd_p);
            }
            block9: for (String id_p : s_idp) {
                if (policyMapping > 0) {
                    boolean idp_found = false;
                    for (PKIXPolicyNode node : policyNodes[i2]) {
                        if (!node.getValidPolicy().equals(id_p)) continue;
                        idp_found = true;
                        node.expectedPolicies = (Set)m_idp.get(id_p);
                        break;
                    }
                    if (idp_found) continue;
                    for (PKIXPolicyNode node : policyNodes[i2]) {
                        PKIXPolicyNode p_node;
                        if (!ANY_POLICY.equals(node.getValidPolicy())) continue;
                        Set pq = null;
                        ASN1Sequence policies = null;
                        try {
                            policies = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(cert, CERTIFICATE_POLICIES);
                        }
                        catch (AnnotatedException e2) {
                            throw new ExtCertPathValidatorException("Certificate policies extension could not be decoded.", (Throwable)e2, certPath, index);
                        }
                        Enumeration e3 = policies.getObjects();
                        while (e3.hasMoreElements()) {
                            PolicyInformation pinfo = null;
                            try {
                                pinfo = PolicyInformation.getInstance(e3.nextElement());
                            }
                            catch (Exception ex) {
                                throw new CertPathValidatorException("Policy information could not be decoded.", (Throwable)ex, certPath, index);
                            }
                            if (!ANY_POLICY.equals(pinfo.getPolicyIdentifier().getId())) continue;
                            try {
                                pq = CertPathValidatorUtilities.getQualifierSet(pinfo.getPolicyQualifiers());
                                break;
                            }
                            catch (CertPathValidatorException ex) {
                                throw new ExtCertPathValidatorException("Policy qualifier info set could not be decoded.", (Throwable)ex, certPath, index);
                            }
                        }
                        boolean ci = false;
                        if (cert.getCriticalExtensionOIDs() != null) {
                            ci = cert.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                        }
                        if (!ANY_POLICY.equals((p_node = (PKIXPolicyNode)node.getParent()).getValidPolicy())) continue block9;
                        PKIXPolicyNode c_node = new PKIXPolicyNode(new ArrayList(), i2, (Set)m_idp.get(id_p), p_node, pq, id_p, ci);
                        p_node.addChild(c_node);
                        policyNodes[i2].add(c_node);
                        continue block9;
                    }
                    continue;
                }
                if (policyMapping > 0) continue;
                Iterator nodes_i = policyNodes[i2].iterator();
                while (nodes_i.hasNext()) {
                    PKIXPolicyNode node = (PKIXPolicyNode)nodes_i.next();
                    if (!node.getValidPolicy().equals(id_p)) continue;
                    PKIXPolicyNode p_node = (PKIXPolicyNode)node.getParent();
                    p_node.removeChild(node);
                    nodes_i.remove();
                    for (int k2 = i2 - 1; k2 >= 0; --k2) {
                        PKIXPolicyNode node2;
                        List nodes = policyNodes[k2];
                        for (int l2 = 0; l2 < nodes.size() && ((node2 = (PKIXPolicyNode)nodes.get(l2)).hasChildren() || (_validPolicyTree = CertPathValidatorUtilities.removePolicyNode(_validPolicyTree, policyNodes, node2)) != null); ++l2) {
                        }
                    }
                }
            }
        }
        return _validPolicyTree;
    }

    protected static void prepareNextCertA(CertPath certPath, int index) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        ASN1Sequence pm = null;
        try {
            pm = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, POLICY_MAPPINGS));
        }
        catch (AnnotatedException ex) {
            throw new ExtCertPathValidatorException("Policy mappings extension could not be decoded.", (Throwable)ex, certPath, index);
        }
        if (pm != null) {
            ASN1Sequence mappings = pm;
            for (int j2 = 0; j2 < mappings.size(); ++j2) {
                ASN1ObjectIdentifier issuerDomainPolicy = null;
                ASN1ObjectIdentifier subjectDomainPolicy = null;
                try {
                    ASN1Sequence mapping = DERSequence.getInstance(mappings.getObjectAt(j2));
                    issuerDomainPolicy = DERObjectIdentifier.getInstance(mapping.getObjectAt(0));
                    subjectDomainPolicy = DERObjectIdentifier.getInstance(mapping.getObjectAt(1));
                }
                catch (Exception e2) {
                    throw new ExtCertPathValidatorException("Policy mappings extension contents could not be decoded.", (Throwable)e2, certPath, index);
                }
                if (ANY_POLICY.equals(issuerDomainPolicy.getId())) {
                    throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy", null, certPath, index);
                }
                if (!ANY_POLICY.equals(subjectDomainPolicy.getId())) continue;
                throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy,", null, certPath, index);
            }
        }
    }

    protected static void processCertF(CertPath certPath, int index, PKIXPolicyNode validPolicyTree, int explicitPolicy) throws CertPathValidatorException {
        if (explicitPolicy <= 0 && validPolicyTree == null) {
            throw new ExtCertPathValidatorException("No valid policy tree found when one expected.", null, certPath, index);
        }
    }

    protected static PKIXPolicyNode processCertE(CertPath certPath, int index, PKIXPolicyNode validPolicyTree) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        ASN1Sequence certPolicies = null;
        try {
            certPolicies = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, CERTIFICATE_POLICIES));
        }
        catch (AnnotatedException e2) {
            throw new ExtCertPathValidatorException("Could not read certificate policies extension from certificate.", (Throwable)e2, certPath, index);
        }
        if (certPolicies == null) {
            validPolicyTree = null;
        }
        return validPolicyTree;
    }

    protected static void processCertBC(CertPath certPath, int index, PKIXNameConstraintValidator nameConstraintValidator) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        int n2 = certs.size();
        int i2 = n2 - index;
        if (!CertPathValidatorUtilities.isSelfIssued(cert) || i2 >= n2) {
            ASN1Sequence dns;
            X500Principal principal = CertPathValidatorUtilities.getSubjectPrincipal(cert);
            ASN1InputStream aIn = new ASN1InputStream(principal.getEncoded());
            try {
                dns = DERSequence.getInstance(aIn.readObject());
            }
            catch (Exception e2) {
                throw new CertPathValidatorException("Exception extracting subject name when checking subtrees.", (Throwable)e2, certPath, index);
            }
            try {
                nameConstraintValidator.checkPermittedDN(dns);
                nameConstraintValidator.checkExcludedDN(dns);
            }
            catch (PKIXNameConstraintValidatorException e3) {
                throw new CertPathValidatorException("Subtree check for certificate subject failed.", (Throwable)e3, certPath, index);
            }
            GeneralNames altName = null;
            try {
                altName = GeneralNames.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, SUBJECT_ALTERNATIVE_NAME));
            }
            catch (Exception e4) {
                throw new CertPathValidatorException("Subject alternative name extension could not be decoded.", (Throwable)e4, certPath, index);
            }
            Vector emails = new X509Name(dns).getValues(X509Name.EmailAddress);
            Enumeration e5 = emails.elements();
            while (e5.hasMoreElements()) {
                String email = (String)e5.nextElement();
                GeneralName emailAsGeneralName = new GeneralName(1, email);
                try {
                    nameConstraintValidator.checkPermitted(emailAsGeneralName);
                    nameConstraintValidator.checkExcluded(emailAsGeneralName);
                }
                catch (PKIXNameConstraintValidatorException ex) {
                    throw new CertPathValidatorException("Subtree check for certificate subject alternative email failed.", (Throwable)ex, certPath, index);
                }
            }
            if (altName != null) {
                GeneralName[] genNames = null;
                try {
                    genNames = altName.getNames();
                }
                catch (Exception e6) {
                    throw new CertPathValidatorException("Subject alternative name contents could not be decoded.", (Throwable)e6, certPath, index);
                }
                for (int j2 = 0; j2 < genNames.length; ++j2) {
                    try {
                        nameConstraintValidator.checkPermitted(genNames[j2]);
                        nameConstraintValidator.checkExcluded(genNames[j2]);
                        continue;
                    }
                    catch (PKIXNameConstraintValidatorException e7) {
                        throw new CertPathValidatorException("Subtree check for certificate subject alternative name failed.", (Throwable)e7, certPath, index);
                    }
                }
            }
        }
    }

    protected static PKIXPolicyNode processCertD(CertPath certPath, int index, Set acceptablePolicies, PKIXPolicyNode validPolicyTree, List[] policyNodes, int inhibitAnyPolicy) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        int n2 = certs.size();
        int i2 = n2 - index;
        ASN1Sequence certPolicies = null;
        try {
            certPolicies = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, CERTIFICATE_POLICIES));
        }
        catch (AnnotatedException e2) {
            throw new ExtCertPathValidatorException("Could not read certificate policies extension from certificate.", (Throwable)e2, certPath, index);
        }
        if (certPolicies != null && validPolicyTree != null) {
            int k2;
            PolicyInformation pInfo;
            Enumeration e3 = certPolicies.getObjects();
            HashSet<String> pols = new HashSet<String>();
            while (e3.hasMoreElements()) {
                pInfo = PolicyInformation.getInstance(e3.nextElement());
                ASN1ObjectIdentifier pOid = pInfo.getPolicyIdentifier();
                pols.add(pOid.getId());
                if (ANY_POLICY.equals(pOid.getId())) continue;
                Set pq = null;
                try {
                    pq = CertPathValidatorUtilities.getQualifierSet(pInfo.getPolicyQualifiers());
                }
                catch (CertPathValidatorException ex) {
                    throw new ExtCertPathValidatorException("Policy qualifier info set could not be build.", (Throwable)ex, certPath, index);
                }
                boolean match = CertPathValidatorUtilities.processCertD1i(i2, policyNodes, pOid, pq);
                if (match) continue;
                CertPathValidatorUtilities.processCertD1ii(i2, policyNodes, pOid, pq);
            }
            if (acceptablePolicies.isEmpty() || acceptablePolicies.contains(ANY_POLICY)) {
                acceptablePolicies.clear();
                acceptablePolicies.addAll(pols);
            } else {
                Iterator it = acceptablePolicies.iterator();
                HashSet t1 = new HashSet();
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (!pols.contains(o2)) continue;
                    t1.add(o2);
                }
                acceptablePolicies.clear();
                acceptablePolicies.addAll(t1);
            }
            if (inhibitAnyPolicy > 0 || i2 < n2 && CertPathValidatorUtilities.isSelfIssued(cert)) {
                e3 = certPolicies.getObjects();
                while (e3.hasMoreElements()) {
                    pInfo = PolicyInformation.getInstance(e3.nextElement());
                    if (!ANY_POLICY.equals(pInfo.getPolicyIdentifier().getId())) continue;
                    Set _apq = CertPathValidatorUtilities.getQualifierSet(pInfo.getPolicyQualifiers());
                    List _nodes = policyNodes[i2 - 1];
                    for (k2 = 0; k2 < _nodes.size(); ++k2) {
                        PKIXPolicyNode _node = (PKIXPolicyNode)_nodes.get(k2);
                        for (Object _tmp : _node.getExpectedPolicies()) {
                            String _policy;
                            if (_tmp instanceof String) {
                                _policy = (String)_tmp;
                            } else {
                                if (!(_tmp instanceof DERObjectIdentifier)) continue;
                                _policy = ((DERObjectIdentifier)_tmp).getId();
                            }
                            boolean _found = false;
                            Iterator _childrenIter = _node.getChildren();
                            while (_childrenIter.hasNext()) {
                                PKIXPolicyNode _child = (PKIXPolicyNode)_childrenIter.next();
                                if (!_policy.equals(_child.getValidPolicy())) continue;
                                _found = true;
                            }
                            if (_found) continue;
                            HashSet<String> _newChildExpectedPolicies = new HashSet<String>();
                            _newChildExpectedPolicies.add(_policy);
                            PKIXPolicyNode _newChild = new PKIXPolicyNode(new ArrayList(), i2, _newChildExpectedPolicies, _node, _apq, _policy, false);
                            _node.addChild(_newChild);
                            policyNodes[i2].add(_newChild);
                        }
                    }
                }
            }
            PKIXPolicyNode _validPolicyTree = validPolicyTree;
            for (int j2 = i2 - 1; j2 >= 0; --j2) {
                PKIXPolicyNode node;
                List nodes = policyNodes[j2];
                for (k2 = 0; k2 < nodes.size() && ((node = (PKIXPolicyNode)nodes.get(k2)).hasChildren() || (_validPolicyTree = CertPathValidatorUtilities.removePolicyNode(_validPolicyTree, policyNodes, node)) != null); ++k2) {
                }
            }
            Set<String> criticalExtensionOids = cert.getCriticalExtensionOIDs();
            if (criticalExtensionOids != null) {
                boolean critical = criticalExtensionOids.contains(CERTIFICATE_POLICIES);
                List nodes = policyNodes[i2];
                for (int j3 = 0; j3 < nodes.size(); ++j3) {
                    PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(j3);
                    node.setCritical(critical);
                }
            }
            return _validPolicyTree;
        }
        return null;
    }

    protected static void processCertA(CertPath certPath, ExtendedPKIXParameters paramsPKIX, int index, PublicKey workingPublicKey, boolean verificationAlreadyPerformed, X500Principal workingIssuerName, X509Certificate sign) throws ExtCertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        if (!verificationAlreadyPerformed) {
            try {
                CertPathValidatorUtilities.verifyX509Certificate(cert, workingPublicKey, paramsPKIX.getSigProvider());
            }
            catch (GeneralSecurityException e2) {
                throw new ExtCertPathValidatorException("Could not validate certificate signature.", (Throwable)e2, certPath, index);
            }
        }
        try {
            cert.checkValidity(CertPathValidatorUtilities.getValidCertDateFromValidityModel(paramsPKIX, certPath, index));
        }
        catch (CertificateExpiredException e3) {
            throw new ExtCertPathValidatorException("Could not validate certificate: " + e3.getMessage(), (Throwable)e3, certPath, index);
        }
        catch (CertificateNotYetValidException e4) {
            throw new ExtCertPathValidatorException("Could not validate certificate: " + e4.getMessage(), (Throwable)e4, certPath, index);
        }
        catch (AnnotatedException e5) {
            throw new ExtCertPathValidatorException("Could not validate time of certificate.", (Throwable)e5, certPath, index);
        }
        if (paramsPKIX.isRevocationEnabled()) {
            try {
                RFC3280CertPathUtilities.checkCRLs(paramsPKIX, cert, CertPathValidatorUtilities.getValidCertDateFromValidityModel(paramsPKIX, certPath, index), sign, workingPublicKey, certs);
            }
            catch (AnnotatedException e6) {
                Throwable cause = e6;
                if (null != e6.getCause()) {
                    cause = e6.getCause();
                }
                throw new ExtCertPathValidatorException(e6.getMessage(), cause, certPath, index);
            }
        }
        if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).equals(workingIssuerName)) {
            throw new ExtCertPathValidatorException("IssuerName(" + CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert) + ") does not match SubjectName(" + workingIssuerName + ") of signing certificate.", null, certPath, index);
        }
    }

    protected static int prepareNextCertI1(CertPath certPath, int index, int explicitPolicy) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        ASN1Sequence pc = null;
        try {
            pc = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, POLICY_CONSTRAINTS));
        }
        catch (Exception e2) {
            throw new ExtCertPathValidatorException("Policy constraints extension cannot be decoded.", (Throwable)e2, certPath, index);
        }
        if (pc != null) {
            Enumeration policyConstraints = pc.getObjects();
            while (policyConstraints.hasMoreElements()) {
                try {
                    ASN1TaggedObject constraint = ASN1TaggedObject.getInstance(policyConstraints.nextElement());
                    if (constraint.getTagNo() != 0) continue;
                    int tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                    if (tmpInt < explicitPolicy) {
                        return tmpInt;
                    }
                    break;
                }
                catch (IllegalArgumentException e3) {
                    throw new ExtCertPathValidatorException("Policy constraints extension contents cannot be decoded.", (Throwable)e3, certPath, index);
                }
            }
        }
        return explicitPolicy;
    }

    protected static int prepareNextCertI2(CertPath certPath, int index, int policyMapping) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        ASN1Sequence pc = null;
        try {
            pc = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, POLICY_CONSTRAINTS));
        }
        catch (Exception e2) {
            throw new ExtCertPathValidatorException("Policy constraints extension cannot be decoded.", (Throwable)e2, certPath, index);
        }
        if (pc != null) {
            Enumeration policyConstraints = pc.getObjects();
            while (policyConstraints.hasMoreElements()) {
                try {
                    ASN1TaggedObject constraint = ASN1TaggedObject.getInstance(policyConstraints.nextElement());
                    if (constraint.getTagNo() != 1) continue;
                    int tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                    if (tmpInt < policyMapping) {
                        return tmpInt;
                    }
                    break;
                }
                catch (IllegalArgumentException e3) {
                    throw new ExtCertPathValidatorException("Policy constraints extension contents cannot be decoded.", (Throwable)e3, certPath, index);
                }
            }
        }
        return policyMapping;
    }

    protected static void prepareNextCertG(CertPath certPath, int index, PKIXNameConstraintValidator nameConstraintValidator) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        NameConstraints nc = null;
        try {
            ASN1Sequence ncSeq = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, NAME_CONSTRAINTS));
            if (ncSeq != null) {
                nc = NameConstraints.getInstance(ncSeq);
            }
        }
        catch (Exception e2) {
            throw new ExtCertPathValidatorException("Name constraints extension could not be decoded.", (Throwable)e2, certPath, index);
        }
        if (nc != null) {
            ASN1Sequence excluded;
            ASN1Sequence permitted = nc.getPermittedSubtrees();
            if (permitted != null) {
                try {
                    nameConstraintValidator.intersectPermittedSubtree(permitted);
                }
                catch (Exception ex) {
                    throw new ExtCertPathValidatorException("Permitted subtrees cannot be build from name constraints extension.", (Throwable)ex, certPath, index);
                }
            }
            if ((excluded = nc.getExcludedSubtrees()) != null) {
                Enumeration e3 = excluded.getObjects();
                try {
                    while (e3.hasMoreElements()) {
                        GeneralSubtree subtree = GeneralSubtree.getInstance(e3.nextElement());
                        nameConstraintValidator.addExcludedSubtree(subtree);
                    }
                }
                catch (Exception ex) {
                    throw new ExtCertPathValidatorException("Excluded subtrees cannot be build from name constraints extension.", (Throwable)ex, certPath, index);
                }
            }
        }
    }

    private static void checkCRL(DistributionPoint dp, ExtendedPKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, CertStatus certStatus, ReasonsMask reasonMask, List certPathCerts) throws AnnotatedException {
        Date currentDate = new Date(System.currentTimeMillis());
        if (validDate.getTime() > currentDate.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set crls = CertPathValidatorUtilities.getCompleteCRLs(dp, cert, currentDate, paramsPKIX);
        boolean validCrlFound = false;
        AnnotatedException lastException = null;
        Iterator crl_iter = crls.iterator();
        while (crl_iter.hasNext() && certStatus.getCertStatus() == 11 && !reasonMask.isAllReasons()) {
            try {
                X509CRL crl = (X509CRL)crl_iter.next();
                ReasonsMask interimReasonsMask = RFC3280CertPathUtilities.processCRLD(crl, dp);
                if (!interimReasonsMask.hasNewReasons(reasonMask)) continue;
                Set keys = RFC3280CertPathUtilities.processCRLF(crl, cert, defaultCRLSignCert, defaultCRLSignKey, paramsPKIX, certPathCerts);
                PublicKey key = RFC3280CertPathUtilities.processCRLG(crl, keys);
                X509CRL deltaCRL = null;
                if (paramsPKIX.isUseDeltasEnabled()) {
                    Set deltaCRLs = CertPathValidatorUtilities.getDeltaCRLs(currentDate, paramsPKIX, crl);
                    deltaCRL = RFC3280CertPathUtilities.processCRLH(deltaCRLs, key);
                }
                if (paramsPKIX.getValidityModel() != 1 && cert.getNotAfter().getTime() < crl.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3280CertPathUtilities.processCRLB1(dp, cert, crl);
                RFC3280CertPathUtilities.processCRLB2(dp, cert, crl);
                RFC3280CertPathUtilities.processCRLC(deltaCRL, crl, paramsPKIX);
                RFC3280CertPathUtilities.processCRLI(validDate, deltaCRL, cert, certStatus, paramsPKIX);
                RFC3280CertPathUtilities.processCRLJ(validDate, crl, cert, certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonMask.addReasons(interimReasonsMask);
                Set<String> criticalExtensions = crl.getCriticalExtensionOIDs();
                if (criticalExtensions != null) {
                    criticalExtensions = new HashSet<String>(criticalExtensions);
                    criticalExtensions.remove(X509Extensions.IssuingDistributionPoint.getId());
                    criticalExtensions.remove(X509Extensions.DeltaCRLIndicator.getId());
                    if (!criticalExtensions.isEmpty()) {
                        throw new AnnotatedException("CRL contains unsupported critical extensions.");
                    }
                }
                if (deltaCRL != null && (criticalExtensions = deltaCRL.getCriticalExtensionOIDs()) != null) {
                    criticalExtensions = new HashSet<String>(criticalExtensions);
                    criticalExtensions.remove(X509Extensions.IssuingDistributionPoint.getId());
                    criticalExtensions.remove(X509Extensions.DeltaCRLIndicator.getId());
                    if (!criticalExtensions.isEmpty()) {
                        throw new AnnotatedException("Delta CRL contains unsupported critical extension.");
                    }
                }
                validCrlFound = true;
            }
            catch (AnnotatedException e2) {
                lastException = e2;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
    }

    protected static void checkCRLs(ExtendedPKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, List certPathCerts) throws AnnotatedException {
        ExtendedPKIXParameters paramsPKIXClone;
        AnnotatedException lastException = null;
        CRLDistPoint crldp = null;
        try {
            crldp = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, CRL_DISTRIBUTION_POINTS));
        }
        catch (Exception e2) {
            throw new AnnotatedException("CRL distribution point extension could not be read.", e2);
        }
        try {
            CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(crldp, paramsPKIX);
        }
        catch (AnnotatedException e3) {
            throw new AnnotatedException("No additional CRL locations could be decoded from CRL distribution point extension.", e3);
        }
        CertStatus certStatus = new CertStatus();
        ReasonsMask reasonsMask = new ReasonsMask();
        boolean validCrlFound = false;
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e4) {
                throw new AnnotatedException("Distribution points could not be read.", e4);
            }
            if (dps != null) {
                for (int i2 = 0; i2 < dps.length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i2) {
                    paramsPKIXClone = (ExtendedPKIXParameters)paramsPKIX.clone();
                    try {
                        RFC3280CertPathUtilities.checkCRL(dps[i2], paramsPKIXClone, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts);
                        validCrlFound = true;
                        continue;
                    }
                    catch (AnnotatedException e5) {
                        lastException = e5;
                    }
                }
            }
        }
        if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                ASN1Primitive issuer = null;
                try {
                    issuer = new ASN1InputStream(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).getEncoded()).readObject();
                }
                catch (Exception e6) {
                    throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", e6);
                }
                DistributionPoint dp = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, issuer))), null, null);
                paramsPKIXClone = (ExtendedPKIXParameters)paramsPKIX.clone();
                RFC3280CertPathUtilities.checkCRL(dp, paramsPKIXClone, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts);
                validCrlFound = true;
            }
            catch (AnnotatedException e7) {
                lastException = e7;
            }
        }
        if (!validCrlFound) {
            if (lastException instanceof AnnotatedException) {
                throw lastException;
            }
            throw new AnnotatedException("No valid CRL found.", lastException);
        }
        if (certStatus.getCertStatus() != 11) {
            String message = "Certificate revocation after " + certStatus.getRevocationDate();
            message = message + ", reason: " + crlReasons[certStatus.getCertStatus()];
            throw new AnnotatedException(message);
        }
        if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
            certStatus.setCertStatus(12);
        }
        if (certStatus.getCertStatus() == 12) {
            throw new AnnotatedException("Certificate status could not be determined.");
        }
    }

    protected static int prepareNextCertJ(CertPath certPath, int index, int inhibitAnyPolicy) throws CertPathValidatorException {
        int _inhibitAnyPolicy;
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        ASN1Integer iap = null;
        try {
            iap = DERInteger.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, INHIBIT_ANY_POLICY));
        }
        catch (Exception e2) {
            throw new ExtCertPathValidatorException("Inhibit any-policy extension cannot be decoded.", (Throwable)e2, certPath, index);
        }
        if (iap != null && (_inhibitAnyPolicy = iap.getValue().intValue()) < inhibitAnyPolicy) {
            return _inhibitAnyPolicy;
        }
        return inhibitAnyPolicy;
    }

    protected static void prepareNextCertK(CertPath certPath, int index) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        BasicConstraints bc = null;
        try {
            bc = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, BASIC_CONSTRAINTS));
        }
        catch (Exception e2) {
            throw new ExtCertPathValidatorException("Basic constraints extension cannot be decoded.", (Throwable)e2, certPath, index);
        }
        if (bc != null) {
            if (!bc.isCA()) {
                throw new CertPathValidatorException("Not a CA certificate");
            }
        } else {
            throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
        }
    }

    protected static int prepareNextCertL(CertPath certPath, int index, int maxPathLength) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        if (!CertPathValidatorUtilities.isSelfIssued(cert)) {
            if (maxPathLength <= 0) {
                throw new ExtCertPathValidatorException("Max path length not greater than zero", null, certPath, index);
            }
            return maxPathLength - 1;
        }
        return maxPathLength;
    }

    protected static int prepareNextCertM(CertPath certPath, int index, int maxPathLength) throws CertPathValidatorException {
        int _plc;
        BigInteger _pathLengthConstraint;
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        BasicConstraints bc = null;
        try {
            bc = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, BASIC_CONSTRAINTS));
        }
        catch (Exception e2) {
            throw new ExtCertPathValidatorException("Basic constraints extension cannot be decoded.", (Throwable)e2, certPath, index);
        }
        if (bc != null && (_pathLengthConstraint = bc.getPathLenConstraint()) != null && (_plc = _pathLengthConstraint.intValue()) < maxPathLength) {
            return _plc;
        }
        return maxPathLength;
    }

    protected static void prepareNextCertN(CertPath certPath, int index) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        boolean[] _usage = cert.getKeyUsage();
        if (_usage != null && !_usage[5]) {
            throw new ExtCertPathValidatorException("Issuer certificate keyusage extension is critical and does not permit key signing.", null, certPath, index);
        }
    }

    protected static void prepareNextCertO(CertPath certPath, int index, Set criticalExtensions, List pathCheckers) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        Iterator tmpIter = pathCheckers.iterator();
        while (tmpIter.hasNext()) {
            try {
                ((PKIXCertPathChecker)tmpIter.next()).check(cert, criticalExtensions);
            }
            catch (CertPathValidatorException e2) {
                throw new CertPathValidatorException(e2.getMessage(), e2.getCause(), certPath, index);
            }
        }
        if (!criticalExtensions.isEmpty()) {
            throw new ExtCertPathValidatorException("Certificate has unsupported critical extension.", null, certPath, index);
        }
    }

    protected static int prepareNextCertH1(CertPath certPath, int index, int explicitPolicy) {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        if (!CertPathValidatorUtilities.isSelfIssued(cert) && explicitPolicy != 0) {
            return explicitPolicy - 1;
        }
        return explicitPolicy;
    }

    protected static int prepareNextCertH2(CertPath certPath, int index, int policyMapping) {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        if (!CertPathValidatorUtilities.isSelfIssued(cert) && policyMapping != 0) {
            return policyMapping - 1;
        }
        return policyMapping;
    }

    protected static int prepareNextCertH3(CertPath certPath, int index, int inhibitAnyPolicy) {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        if (!CertPathValidatorUtilities.isSelfIssued(cert) && inhibitAnyPolicy != 0) {
            return inhibitAnyPolicy - 1;
        }
        return inhibitAnyPolicy;
    }

    protected static int wrapupCertA(int explicitPolicy, X509Certificate cert) {
        if (!CertPathValidatorUtilities.isSelfIssued(cert) && explicitPolicy != 0) {
            --explicitPolicy;
        }
        return explicitPolicy;
    }

    protected static int wrapupCertB(CertPath certPath, int index, int explicitPolicy) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        ASN1Sequence pc = null;
        try {
            pc = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, POLICY_CONSTRAINTS));
        }
        catch (AnnotatedException e2) {
            throw new ExtCertPathValidatorException("Policy constraints could not be decoded.", (Throwable)e2, certPath, index);
        }
        if (pc != null) {
            Enumeration policyConstraints = pc.getObjects();
            while (policyConstraints.hasMoreElements()) {
                ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                switch (constraint.getTagNo()) {
                    case 0: {
                        int tmpInt;
                        try {
                            tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                        }
                        catch (Exception e3) {
                            throw new ExtCertPathValidatorException("Policy constraints requireExplicitPolicy field could not be decoded.", (Throwable)e3, certPath, index);
                        }
                        if (tmpInt != 0) break;
                        return 0;
                    }
                }
            }
        }
        return explicitPolicy;
    }

    protected static void wrapupCertF(CertPath certPath, int index, List pathCheckers, Set criticalExtensions) throws CertPathValidatorException {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate cert = (X509Certificate)certs.get(index);
        Iterator tmpIter = pathCheckers.iterator();
        while (tmpIter.hasNext()) {
            try {
                ((PKIXCertPathChecker)tmpIter.next()).check(cert, criticalExtensions);
            }
            catch (CertPathValidatorException e2) {
                throw new ExtCertPathValidatorException("Additional certificate path checker failed.", (Throwable)e2, certPath, index);
            }
        }
        if (!criticalExtensions.isEmpty()) {
            throw new ExtCertPathValidatorException("Certificate has unsupported critical extension", null, certPath, index);
        }
    }

    protected static PKIXPolicyNode wrapupCertG(CertPath certPath, ExtendedPKIXParameters paramsPKIX, Set userInitialPolicySet, int index, List[] policyNodes, PKIXPolicyNode validPolicyTree, Set acceptablePolicies) throws CertPathValidatorException {
        PKIXPolicyNode intersection;
        int n2 = certPath.getCertificates().size();
        if (validPolicyTree == null) {
            if (paramsPKIX.isExplicitPolicyRequired()) {
                throw new ExtCertPathValidatorException("Explicit policy requested but none available.", null, certPath, index);
            }
            intersection = null;
        } else if (CertPathValidatorUtilities.isAnyPolicy(userInitialPolicySet)) {
            if (paramsPKIX.isExplicitPolicyRequired()) {
                if (acceptablePolicies.isEmpty()) {
                    throw new ExtCertPathValidatorException("Explicit policy requested but none available.", null, certPath, index);
                }
                HashSet _validPolicyNodeSet = new HashSet();
                for (int j2 = 0; j2 < policyNodes.length; ++j2) {
                    List _nodeDepth = policyNodes[j2];
                    for (int k2 = 0; k2 < _nodeDepth.size(); ++k2) {
                        PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k2);
                        if (!ANY_POLICY.equals(_node.getValidPolicy())) continue;
                        Iterator _iter = _node.getChildren();
                        while (_iter.hasNext()) {
                            _validPolicyNodeSet.add(_iter.next());
                        }
                    }
                }
                for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                    String _validPolicy = _node.getValidPolicy();
                    if (acceptablePolicies.contains(_validPolicy)) continue;
                }
                if (validPolicyTree != null) {
                    for (int j3 = n2 - 1; j3 >= 0; --j3) {
                        List nodes = policyNodes[j3];
                        for (int k3 = 0; k3 < nodes.size(); ++k3) {
                            PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k3);
                            if (node.hasChildren()) continue;
                            validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, node);
                        }
                    }
                }
            }
            intersection = validPolicyTree;
        } else {
            HashSet<PKIXPolicyNode> _validPolicyNodeSet = new HashSet<PKIXPolicyNode>();
            for (int j4 = 0; j4 < policyNodes.length; ++j4) {
                List _nodeDepth = policyNodes[j4];
                for (int k4 = 0; k4 < _nodeDepth.size(); ++k4) {
                    PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k4);
                    if (!ANY_POLICY.equals(_node.getValidPolicy())) continue;
                    Iterator _iter = _node.getChildren();
                    while (_iter.hasNext()) {
                        PKIXPolicyNode _c_node = (PKIXPolicyNode)_iter.next();
                        if (ANY_POLICY.equals(_c_node.getValidPolicy())) continue;
                        _validPolicyNodeSet.add(_c_node);
                    }
                }
            }
            for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                String _validPolicy = _node.getValidPolicy();
                if (userInitialPolicySet.contains(_validPolicy)) continue;
                validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, _node);
            }
            if (validPolicyTree != null) {
                for (int j5 = n2 - 1; j5 >= 0; --j5) {
                    List nodes = policyNodes[j5];
                    for (int k5 = 0; k5 < nodes.size(); ++k5) {
                        PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k5);
                        if (node.hasChildren()) continue;
                        validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, node);
                    }
                }
            }
            intersection = validPolicyTree;
        }
        return intersection;
    }
}

