/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

public abstract class Pack {
    public static int bigEndianToInt(byte[] bs, int off) {
        int n2 = bs[off] << 24;
        n2 |= (bs[++off] & 0xFF) << 16;
        n2 |= (bs[++off] & 0xFF) << 8;
        return n2 |= bs[++off] & 0xFF;
    }

    public static void bigEndianToInt(byte[] bs, int off, int[] ns) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            ns[i2] = Pack.bigEndianToInt(bs, off);
            off += 4;
        }
    }

    public static void intToBigEndian(int n2, byte[] bs, int off) {
        bs[off] = (byte)(n2 >>> 24);
        bs[++off] = (byte)(n2 >>> 16);
        bs[++off] = (byte)(n2 >>> 8);
        bs[++off] = (byte)n2;
    }

    public static void intToBigEndian(int[] ns, byte[] bs, int off) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            Pack.intToBigEndian(ns[i2], bs, off);
            off += 4;
        }
    }

    public static long bigEndianToLong(byte[] bs, int off) {
        int hi = Pack.bigEndianToInt(bs, off);
        int lo = Pack.bigEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void longToBigEndian(long n2, byte[] bs, int off) {
        Pack.intToBigEndian((int)(n2 >>> 32), bs, off);
        Pack.intToBigEndian((int)(n2 & 0xFFFFFFFFL), bs, off + 4);
    }

    public static int littleEndianToInt(byte[] bs, int off) {
        int n2 = bs[off] & 0xFF;
        n2 |= (bs[++off] & 0xFF) << 8;
        n2 |= (bs[++off] & 0xFF) << 16;
        return n2 |= bs[++off] << 24;
    }

    public static void littleEndianToInt(byte[] bs, int off, int[] ns) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            ns[i2] = Pack.littleEndianToInt(bs, off);
            off += 4;
        }
    }

    public static void intToLittleEndian(int n2, byte[] bs, int off) {
        bs[off] = (byte)n2;
        bs[++off] = (byte)(n2 >>> 8);
        bs[++off] = (byte)(n2 >>> 16);
        bs[++off] = (byte)(n2 >>> 24);
    }

    public static void intToLittleEndian(int[] ns, byte[] bs, int off) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            Pack.intToLittleEndian(ns[i2], bs, off);
            off += 4;
        }
    }

    public static long littleEndianToLong(byte[] bs, int off) {
        int lo = Pack.littleEndianToInt(bs, off);
        int hi = Pack.littleEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void longToLittleEndian(long n2, byte[] bs, int off) {
        Pack.intToLittleEndian((int)(n2 & 0xFFFFFFFFL), bs, off);
        Pack.intToLittleEndian((int)(n2 >>> 32), bs, off + 4);
    }
}

