/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;

public class ECDSASigner
implements ECConstants,
DSA {
    ECKeyParameters key;
    SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger d2;
        BigInteger k2;
        BigInteger n2 = this.key.getParameters().getN();
        BigInteger e2 = this.calculateE(n2, message);
        BigInteger r2 = null;
        BigInteger s2 = null;
        do {
            ECPoint p2;
            BigInteger x2;
            k2 = null;
            int nBitLength = n2.bitLength();
            while ((k2 = new BigInteger(nBitLength, this.random)).equals(ZERO) || k2.compareTo(n2) >= 0 || (r2 = (x2 = (p2 = this.key.getParameters().getG().multiply(k2)).getX().toBigInteger()).mod(n2)).equals(ZERO)) {
            }
            d2 = ((ECPrivateKeyParameters)this.key).getD();
        } while ((s2 = k2.modInverse(n2).multiply(e2.add(d2.multiply(r2))).mod(n2)).equals(ZERO));
        BigInteger[] res = new BigInteger[]{r2, s2};
        return res;
    }

    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        BigInteger n2 = this.key.getParameters().getN();
        BigInteger e2 = this.calculateE(n2, message);
        if (r2.compareTo(ONE) < 0 || r2.compareTo(n2) >= 0) {
            return false;
        }
        if (s2.compareTo(ONE) < 0 || s2.compareTo(n2) >= 0) {
            return false;
        }
        BigInteger c2 = s2.modInverse(n2);
        BigInteger u1 = e2.multiply(c2).mod(n2);
        BigInteger u2 = r2.multiply(c2).mod(n2);
        ECPoint G = this.key.getParameters().getG();
        ECPoint Q = ((ECPublicKeyParameters)this.key).getQ();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, u1, Q, u2);
        BigInteger v2 = point.getX().toBigInteger().mod(n2);
        return v2.equals(r2);
    }

    private BigInteger calculateE(BigInteger n2, byte[] message) {
        int messageBitLength;
        int log2n = n2.bitLength();
        if (log2n >= (messageBitLength = message.length * 8)) {
            return new BigInteger(1, message);
        }
        BigInteger trunc = new BigInteger(1, message);
        trunc = trunc.shiftRight(messageBitLength - log2n);
        return trunc;
    }
}

