/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.stat.descriptive.AbstractUnivariateStatistic;
import org.apache.commons.math.util.FastMath;

public class Percentile
extends AbstractUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8091216485095130416L;
    private static final int MIN_SELECT_SIZE = 15;
    private static final int MAX_CACHED_LEVELS = 10;
    private double quantile = 0.0;
    private int[] cachedPivots;

    public Percentile() {
        this(50.0);
    }

    public Percentile(double p2) {
        this.setQuantile(p2);
        this.cachedPivots = null;
    }

    public Percentile(Percentile original) {
        Percentile.copy(original, this);
    }

    public void setData(double[] values) {
        if (values == null) {
            this.cachedPivots = null;
        } else {
            this.cachedPivots = new int[1023];
            Arrays.fill(this.cachedPivots, -1);
        }
        super.setData(values);
    }

    public void setData(double[] values, int begin, int length) {
        if (values == null) {
            this.cachedPivots = null;
        } else {
            this.cachedPivots = new int[1023];
            Arrays.fill(this.cachedPivots, -1);
        }
        super.setData(values, begin, length);
    }

    public double evaluate(double p2) {
        return this.evaluate(this.getDataRef(), p2);
    }

    public double evaluate(double[] values, double p2) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length, p2);
    }

    public double evaluate(double[] values, int start, int length) {
        return this.evaluate(values, start, length, this.quantile);
    }

    public double evaluate(double[] values, int begin, int length, double p2) {
        int[] pivotsHeap;
        double[] work;
        this.test(values, begin, length);
        if (p2 > 100.0 || p2 <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, p2);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double n2 = length;
        double pos = p2 * (n2 + 1.0) / 100.0;
        double fpos = FastMath.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        if (values == this.getDataRef()) {
            work = this.getDataRef();
            pivotsHeap = this.cachedPivots;
        } else {
            work = new double[length];
            System.arraycopy(values, begin, work, 0, length);
            pivotsHeap = new int[1023];
            Arrays.fill(pivotsHeap, -1);
        }
        if (pos < 1.0) {
            return this.select(work, pivotsHeap, 0);
        }
        if (pos >= n2) {
            return this.select(work, pivotsHeap, length - 1);
        }
        double lower = this.select(work, pivotsHeap, intPos - 1);
        double upper = this.select(work, pivotsHeap, intPos);
        return lower + dif * (upper - lower);
    }

    private double select(double[] work, int[] pivotsHeap, int k2) {
        int begin = 0;
        int end = work.length;
        int node = 0;
        while (end - begin > 15) {
            int pivot;
            if (node < pivotsHeap.length && pivotsHeap[node] >= 0) {
                pivot = pivotsHeap[node];
            } else {
                pivot = this.partition(work, begin, end, this.medianOf3(work, begin, end));
                if (node < pivotsHeap.length) {
                    pivotsHeap[node] = pivot;
                }
            }
            if (k2 == pivot) {
                return work[k2];
            }
            if (k2 < pivot) {
                end = pivot;
                node = Math.min(2 * node + 1, pivotsHeap.length);
                continue;
            }
            begin = pivot + 1;
            node = Math.min(2 * node + 2, pivotsHeap.length);
        }
        this.insertionSort(work, begin, end);
        return work[k2];
    }

    int medianOf3(double[] work, int begin, int end) {
        int inclusiveEnd = end - 1;
        int middle = begin + (inclusiveEnd - begin) / 2;
        double wBegin = work[begin];
        double wMiddle = work[middle];
        double wEnd = work[inclusiveEnd];
        if (wBegin < wMiddle) {
            if (wMiddle < wEnd) {
                return middle;
            }
            return wBegin < wEnd ? inclusiveEnd : begin;
        }
        if (wBegin < wEnd) {
            return begin;
        }
        return wMiddle < wEnd ? inclusiveEnd : middle;
    }

    private int partition(double[] work, int begin, int end, int pivot) {
        double value = work[pivot];
        work[pivot] = work[begin];
        int i2 = begin + 1;
        int j2 = end - 1;
        while (i2 < j2) {
            while (i2 < j2 && work[j2] >= value) {
                --j2;
            }
            while (i2 < j2 && work[i2] <= value) {
                ++i2;
            }
            if (i2 >= j2) continue;
            double tmp = work[i2];
            work[i2++] = work[j2];
            work[j2--] = tmp;
        }
        if (i2 >= end || work[i2] > value) {
            --i2;
        }
        work[begin] = work[i2];
        work[i2] = value;
        return i2;
    }

    private void insertionSort(double[] work, int begin, int end) {
        for (int j2 = begin + 1; j2 < end; ++j2) {
            double saved = work[j2];
            for (int i2 = j2 - 1; i2 >= begin && saved < work[i2]; --i2) {
                work[i2 + 1] = work[i2];
            }
            work[i2 + 1] = saved;
        }
    }

    public double getQuantile() {
        return this.quantile;
    }

    public void setQuantile(double p2) {
        if (p2 <= 0.0 || p2 > 100.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, p2);
        }
        this.quantile = p2;
    }

    public Percentile copy() {
        Percentile result = new Percentile();
        Percentile.copy(this, result);
        return result;
    }

    public static void copy(Percentile source, Percentile dest) {
        dest.setData(source.getDataRef());
        if (source.cachedPivots != null) {
            System.arraycopy(source.cachedPivots, 0, dest.cachedPivots, 0, source.cachedPivots.length);
        }
        dest.quantile = source.quantile;
    }
}

