/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import org.apache.commons.math.exception.NotStrictlyPositiveException;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.commons.math.util.FastMath;

public abstract class BitsStreamGenerator
implements RandomGenerator {
    private double nextGaussian = Double.NaN;

    public abstract void setSeed(int var1);

    public abstract void setSeed(int[] var1);

    public abstract void setSeed(long var1);

    protected abstract int next(int var1);

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public void nextBytes(byte[] bytes) {
        int random;
        int i2;
        int iEnd = bytes.length - 3;
        for (i2 = 0; i2 < iEnd; i2 += 4) {
            random = this.next(32);
            bytes[i2] = (byte)(random & 0xFF);
            bytes[i2 + 1] = (byte)(random >> 8 & 0xFF);
            bytes[i2 + 2] = (byte)(random >> 16 & 0xFF);
            bytes[i2 + 3] = (byte)(random >> 24 & 0xFF);
        }
        random = this.next(32);
        while (i2 < bytes.length) {
            bytes[i2++] = (byte)(random & 0xFF);
            random >>= 8;
        }
    }

    public double nextDouble() {
        long high = (long)this.next(26) << 26;
        int low = this.next(26);
        return (double)(high | (long)low) * 2.220446049250313E-16;
    }

    public float nextFloat() {
        return (float)this.next(23) * 1.1920929E-7f;
    }

    public double nextGaussian() {
        double random;
        if (Double.isNaN(this.nextGaussian)) {
            double x2 = this.nextDouble();
            double y = this.nextDouble();
            double alpha = Math.PI * 2 * x2;
            double r2 = FastMath.sqrt(-2.0 * FastMath.log(y));
            random = r2 * FastMath.cos(alpha);
            this.nextGaussian = r2 * FastMath.sin(alpha);
        } else {
            random = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n2) throws IllegalArgumentException {
        int random;
        if (n2 < 1) {
            throw new NotStrictlyPositiveException(n2);
        }
        int mask = n2;
        mask |= mask >> 1;
        mask |= mask >> 2;
        mask |= mask >> 4;
        mask |= mask >> 8;
        mask |= mask >> 16;
        while ((random = this.next(32) & mask) >= n2) {
        }
        return random;
    }

    public long nextLong() {
        long high = (long)this.next(32) << 32;
        long low = (long)this.next(32) & 0xFFFFFFFFL;
        return high | low;
    }
}

