/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.samtools.util.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public class Allele
implements Comparable<Allele>,
Serializable {
    public static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_ALLELE_BASES = new byte[0];
    private boolean isRef = false;
    private boolean isNoCall = false;
    private boolean isSymbolic = false;
    private byte[] bases = null;
    public static final String NO_CALL_STRING = ".";
    private static final Allele REF_A = new Allele("A", true);
    private static final Allele ALT_A = new Allele("A", false);
    private static final Allele REF_C = new Allele("C", true);
    private static final Allele ALT_C = new Allele("C", false);
    private static final Allele REF_G = new Allele("G", true);
    private static final Allele ALT_G = new Allele("G", false);
    private static final Allele REF_T = new Allele("T", true);
    private static final Allele ALT_T = new Allele("T", false);
    private static final Allele REF_N = new Allele("N", true);
    private static final Allele ALT_N = new Allele("N", false);
    public static final Allele NO_CALL = new Allele(".", false);

    protected Allele(byte[] bases, boolean isRef) {
        if (Allele.wouldBeNullAllele(bases)) {
            throw new IllegalArgumentException("Null alleles are not supported");
        }
        if (Allele.wouldBeNoCallAllele(bases)) {
            this.bases = EMPTY_ALLELE_BASES;
            this.isNoCall = true;
            if (isRef) {
                throw new IllegalArgumentException("Cannot tag a NoCall allele as the reference allele");
            }
            return;
        }
        if (Allele.wouldBeSymbolicAllele(bases)) {
            this.isSymbolic = true;
            if (isRef) {
                throw new IllegalArgumentException("Cannot tag a symbolic allele as the reference allele");
            }
        } else {
            StringUtil.toUpperCase(bases);
        }
        this.isRef = isRef;
        this.bases = bases;
        if (!Allele.acceptableAlleleBases(bases)) {
            throw new IllegalArgumentException("Unexpected base in allele bases '" + new String(bases) + "'");
        }
    }

    protected Allele(String bases, boolean isRef) {
        this(bases.getBytes(), isRef);
    }

    protected Allele(Allele allele, boolean ignoreRefState) {
        this.bases = allele.bases;
        this.isRef = ignoreRefState ? false : allele.isRef;
        this.isNoCall = allele.isNoCall;
        this.isSymbolic = allele.isSymbolic;
    }

    public static Allele create(byte[] bases, boolean isRef) {
        if (bases == null) {
            throw new IllegalArgumentException("create: the Allele base string cannot be null; use new Allele() or new Allele(\"\") to create a Null allele");
        }
        if (bases.length == 1) {
            switch (bases[0]) {
                case 46: {
                    if (isRef) {
                        throw new IllegalArgumentException("Cannot tag a NoCall allele as the reference allele");
                    }
                    return NO_CALL;
                }
                case 65: 
                case 97: {
                    return isRef ? REF_A : ALT_A;
                }
                case 67: 
                case 99: {
                    return isRef ? REF_C : ALT_C;
                }
                case 71: 
                case 103: {
                    return isRef ? REF_G : ALT_G;
                }
                case 84: 
                case 116: {
                    return isRef ? REF_T : ALT_T;
                }
                case 78: 
                case 110: {
                    return isRef ? REF_N : ALT_N;
                }
            }
            throw new IllegalArgumentException("Illegal base [" + (char)bases[0] + "] seen in the allele");
        }
        return new Allele(bases, isRef);
    }

    public static Allele create(byte base, boolean isRef) {
        return Allele.create(new byte[]{base}, isRef);
    }

    public static Allele create(byte base) {
        return Allele.create(base, false);
    }

    public static Allele extend(Allele left, byte[] right) {
        if (left.isSymbolic()) {
            throw new IllegalArgumentException("Cannot extend a symbolic allele");
        }
        byte[] bases = new byte[left.length() + right.length];
        System.arraycopy(left.getBases(), 0, bases, 0, left.length());
        System.arraycopy(right, 0, bases, left.length(), right.length);
        return Allele.create(bases, left.isReference());
    }

    public static boolean wouldBeNullAllele(byte[] bases) {
        return bases.length == 1 && bases[0] == 45 || bases.length == 0;
    }

    public static boolean wouldBeNoCallAllele(byte[] bases) {
        return bases.length == 1 && bases[0] == 46;
    }

    public static boolean wouldBeSymbolicAllele(byte[] bases) {
        if (bases.length <= 1) {
            return false;
        }
        String strBases = new String(bases);
        return bases[0] == 60 || bases[bases.length - 1] == 62 || bases[0] == 46 || bases[bases.length - 1] == 46 || strBases.contains("[") || strBases.contains("]");
    }

    public static boolean acceptableAlleleBases(String bases) {
        return Allele.acceptableAlleleBases(bases.getBytes(), true);
    }

    public static boolean acceptableAlleleBases(String bases, boolean allowNsAsAcceptable) {
        return Allele.acceptableAlleleBases(bases.getBytes(), allowNsAsAcceptable);
    }

    public static boolean acceptableAlleleBases(byte[] bases) {
        return Allele.acceptableAlleleBases(bases, true);
    }

    public static boolean acceptableAlleleBases(byte[] bases, boolean allowNsAsAcceptable) {
        if (Allele.wouldBeNullAllele(bases)) {
            return false;
        }
        if (Allele.wouldBeNoCallAllele(bases) || Allele.wouldBeSymbolicAllele(bases)) {
            return true;
        }
        block4: for (byte base : bases) {
            switch (base) {
                case 65: 
                case 67: 
                case 71: 
                case 84: 
                case 97: 
                case 99: 
                case 103: 
                case 116: {
                    continue block4;
                }
                case 78: 
                case 110: {
                    if (allowNsAsAcceptable) continue block4;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static Allele create(String bases, boolean isRef) {
        return Allele.create(bases.getBytes(), isRef);
    }

    public static Allele create(String bases) {
        return Allele.create(bases, false);
    }

    public static Allele create(byte[] bases) {
        return Allele.create(bases, false);
    }

    public static Allele create(Allele allele, boolean ignoreRefState) {
        return new Allele(allele, ignoreRefState);
    }

    public boolean isNoCall() {
        return this.isNoCall;
    }

    public boolean isCalled() {
        return !this.isNoCall();
    }

    public boolean isReference() {
        return this.isRef;
    }

    public boolean isNonReference() {
        return !this.isReference();
    }

    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    public String toString() {
        return (this.isNoCall() ? NO_CALL_STRING : this.getDisplayString()) + (this.isReference() ? "*" : "");
    }

    public byte[] getBases() {
        return this.isSymbolic ? EMPTY_ALLELE_BASES : this.bases;
    }

    public String getBaseString() {
        return this.isNoCall() ? NO_CALL_STRING : new String(this.getBases());
    }

    public String getDisplayString() {
        return new String(this.bases);
    }

    public byte[] getDisplayBases() {
        return this.bases;
    }

    public boolean equals(Object other) {
        return !(other instanceof Allele) ? false : this.equals((Allele)other, false);
    }

    public int hashCode() {
        int hash = 1;
        for (int i2 = 0; i2 < this.bases.length; ++i2) {
            hash += (i2 + 1) * this.bases[i2];
        }
        return hash;
    }

    public boolean equals(Allele other, boolean ignoreRefState) {
        return this == other || (this.isRef == other.isRef || ignoreRefState) && this.isNoCall == other.isNoCall && (this.bases == other.bases || Arrays.equals(this.bases, other.bases));
    }

    public boolean basesMatch(byte[] test) {
        return !this.isSymbolic && (this.bases == test || Arrays.equals(this.bases, test));
    }

    public boolean basesMatch(String test) {
        return this.basesMatch(test.toUpperCase().getBytes());
    }

    public boolean basesMatch(Allele test) {
        return this.basesMatch(test.getBases());
    }

    public int length() {
        return this.isSymbolic ? 0 : this.bases.length;
    }

    public static Allele getMatchingAllele(Collection<Allele> allAlleles, byte[] alleleBases) {
        for (Allele a2 : allAlleles) {
            if (!a2.basesMatch(alleleBases)) continue;
            return a2;
        }
        if (Allele.wouldBeNoCallAllele(alleleBases)) {
            return NO_CALL;
        }
        return null;
    }

    @Override
    public int compareTo(Allele other) {
        if (this.isReference() && other.isNonReference()) {
            return -1;
        }
        if (this.isNonReference() && other.isReference()) {
            return 1;
        }
        return this.getBaseString().compareTo(other.getBaseString());
    }

    public static boolean oneIsPrefixOfOther(Allele a1, Allele a2) {
        if (a2.length() >= a1.length()) {
            return Allele.firstIsPrefixOfSecond(a1, a2);
        }
        return Allele.firstIsPrefixOfSecond(a2, a1);
    }

    private static boolean firstIsPrefixOfSecond(Allele a1, Allele a2) {
        String a1String = a1.getBaseString();
        return a2.getBaseString().substring(0, a1String.length()).equals(a1String);
    }
}

