/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;

public class Slice {
    public static final int UNMAPPED_OR_NOREF = -1;
    public static final int MUTLIREF = -2;
    private static final Log log = Log.getInstance(Slice.class);
    public int sequenceId = -1;
    public int alignmentStart = -1;
    public int alignmentSpan = -1;
    public int nofRecords = -1;
    public long globalRecordCounter = -1L;
    public int nofBlocks = -1;
    public int[] contentIDs;
    public int embeddedRefBlockContentID = -1;
    public byte[] refMD5;
    public Block headerBlock;
    public BlockContentType contentType;
    public Block coreBlock;
    public Block embeddedRefBlock;
    public Map<Integer, Block> external;
    public int offset = -1;
    public long containerOffset = -1L;
    public int size = -1;
    public int index = -1;
    public long bases;
    private static final int shoulder = 10;

    private boolean alignmentBordersSanityCheck(byte[] ref) {
        if (this.alignmentStart > 0 && this.sequenceId >= 0 && ref == null) {
            throw new NullPointerException("Mapped slice reference is null.");
        }
        if (this.alignmentStart > ref.length) {
            log.error(String.format("Slice mapped outside of reference: seqid=%d, alstart=%d, counter=%d.", this.sequenceId, this.alignmentStart, this.globalRecordCounter));
            throw new RuntimeException("Slice mapped outside of the reference.");
        }
        if (this.alignmentStart - 1 + this.alignmentSpan > ref.length) {
            log.warn(String.format("Slice partially mapped outside of reference: seqid=%d, alstart=%d, alspan=%d, counter=%d.", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.globalRecordCounter));
            return false;
        }
        return true;
    }

    public boolean validateRefMD5(byte[] ref) throws NoSuchAlgorithmException {
        this.alignmentBordersSanityCheck(ref);
        if (!Slice.validateRefMD5(ref, this.alignmentStart, this.alignmentSpan, this.refMD5)) {
            String excerpt = Slice.getBrief(this.alignmentStart, this.alignmentSpan, ref, 10, null);
            if (Slice.validateRefMD5(ref, this.alignmentStart, this.alignmentSpan - 1, this.refMD5)) {
                log.warn(String.format("Reference MD5 matches partially for slice %d:%d-%d, %s", this.sequenceId, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, excerpt));
                return true;
            }
            log.error(String.format("Reference MD5 mismatch for slice %d:%d-%d, %s", this.sequenceId, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, excerpt));
            return false;
        }
        return true;
    }

    private static boolean validateRefMD5(byte[] ref, int alignmentStart, int alignmentSpan, byte[] expectedMD5) {
        int span = Math.min(alignmentSpan, ref.length - alignmentStart + 1);
        String md5 = SequenceUtil.calculateMD5String(ref, alignmentStart - 1, span);
        return md5.equals(String.format("%032x", new BigInteger(1, expectedMD5)));
    }

    private static String getBrief(int start_1based, int span, byte[] bases, int shoulderLength, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        int from_inc = start_1based - 1;
        int to_exc = start_1based + span - 1;
        if ((to_exc = Math.min(to_exc, bases.length)) - from_inc <= 2 * shoulderLength) {
            sb.append(new String(Arrays.copyOfRange(bases, from_inc, to_exc)));
        } else {
            sb.append(new String(Arrays.copyOfRange(bases, from_inc, from_inc + shoulderLength)));
            sb.append("...");
            sb.append(new String(Arrays.copyOfRange(bases, to_exc - shoulderLength, to_exc)));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String s2 = "0123456789";
        byte[] bases = s2.getBytes();
        String format = "start %d, span %d, shoulder %d:\t";
        int start = 1;
        int span = 1;
        int shoulder = 1;
        StringBuffer sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 1;
        span = 11;
        shoulder = 1;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 1;
        span = 10;
        shoulder = 10;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 1;
        shoulder = 1;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 11;
        shoulder = 1;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 10;
        shoulder = 10;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 2;
        shoulder = 2;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 4;
        shoulder = 2;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 5;
        shoulder = 2;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 10;
        shoulder = 4;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 10;
        shoulder = 5;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
        start = 2;
        span = 10;
        shoulder = 6;
        sb = new StringBuffer(String.format(format, start, span, shoulder));
        Slice.getBrief(start, span, bases, shoulder, sb);
        System.out.println(sb.toString());
    }

    public void setRefMD5(byte[] ref) {
        this.alignmentBordersSanityCheck(ref);
        if (this.sequenceId < 0 && this.alignmentStart < 1) {
            this.refMD5 = new byte[16];
            Arrays.fill(this.refMD5, (byte)0);
            log.debug("Empty slice ref md5 is set.");
        } else {
            int span = Math.min(this.alignmentSpan, ref.length - this.alignmentStart + 1);
            if (this.alignmentStart + span > ref.length + 1) {
                throw new RuntimeException("Invalid alignment boundaries.");
            }
            this.refMD5 = SequenceUtil.calculateMD5(ref, this.alignmentStart - 1, span);
            StringBuffer sb = new StringBuffer();
            int shoulder = 10;
            sb.append(new String(Arrays.copyOfRange(ref, this.alignmentStart - 1, this.alignmentStart + shoulder)));
            sb.append("...");
            sb.append(new String(Arrays.copyOfRange(ref, this.alignmentStart - 1 + span - shoulder, this.alignmentStart + span)));
            log.debug(String.format("Slice md5: %s for %d:%d-%d, %s", String.format("%032x", new BigInteger(1, this.refMD5)), this.sequenceId, this.alignmentStart, this.alignmentStart + span - 1, sb.toString()));
        }
    }
}

