/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Block {
    public BlockCompressionMethod method;
    public BlockContentType contentType;
    public int contentId;
    private int compressedContentSize;
    private int rawContentSize;
    private byte[] rawContent;
    private byte[] compressedContent;

    public Block() {
    }

    public Block(BlockCompressionMethod method, BlockContentType contentType, int contentId, byte[] rawContent, byte[] compressedContent) {
        this.method = method;
        this.contentType = contentType;
        this.contentId = contentId;
        if (rawContent != null) {
            this.setRawContent(rawContent);
        }
        if (compressedContent != null) {
            this.setCompressedContent(compressedContent);
        }
    }

    public Block(InputStream is, boolean readContent, boolean uncompress) throws IOException {
        this.method = BlockCompressionMethod.values()[is.read()];
        int contentTypeId = is.read();
        this.contentType = BlockContentType.values()[contentTypeId];
        this.contentId = ByteBufferUtils.readUnsignedITF8(is);
        this.compressedContentSize = ByteBufferUtils.readUnsignedITF8(is);
        this.rawContentSize = ByteBufferUtils.readUnsignedITF8(is);
        if (readContent) {
            this.compressedContent = new byte[this.compressedContentSize];
            ByteBufferUtils.readFully(this.compressedContent, is);
            if (uncompress) {
                this.uncompress();
            }
        }
    }

    public String toString() {
        String raw = this.rawContent == null ? "NULL" : Arrays.toString(Arrays.copyOf(this.rawContent, 20));
        String comp = this.compressedContent == null ? "NULL" : Arrays.toString(Arrays.copyOf(this.compressedContent, 20));
        return String.format("method=%d, type=%s, id=%d, raw size=%d, compressed size=%d, raw=%s, comp=%s.", new Object[]{this.method, this.contentType.name(), this.contentId, this.rawContentSize, this.compressedContentSize, raw, comp});
    }

    public boolean isCompressed() {
        return this.compressedContent != null;
    }

    public boolean isUncompressed() {
        return this.rawContent != null;
    }

    public void setRawContent(byte[] raw) {
        this.rawContent = raw;
        this.rawContentSize = raw == null ? 0 : raw.length;
        this.compressedContent = null;
        this.compressedContentSize = 0;
    }

    public byte[] getRawContent() {
        if (this.rawContent == null) {
            this.uncompress();
        }
        return this.rawContent;
    }

    public int getRawContentSize() {
        return this.rawContentSize;
    }

    public void setCompressedContent(byte[] compressed) {
        this.compressedContent = compressed;
        this.compressedContentSize = compressed == null ? 0 : compressed.length;
        this.rawContent = null;
        this.rawContentSize = 0;
    }

    public byte[] getCompressedContent() {
        if (this.compressedContent == null) {
            this.compress();
        }
        return this.compressedContent;
    }

    public void compress() {
        if (this.compressedContent != null || this.rawContent == null) {
            return;
        }
        switch (this.method) {
            case RAW: {
                this.compressedContent = this.rawContent;
                this.compressedContentSize = this.rawContentSize;
                break;
            }
            case GZIP: {
                try {
                    this.compressedContent = ByteBufferUtils.gzip(this.rawContent);
                }
                catch (IOException e2) {
                    throw new RuntimeException("This should have never happned.", e2);
                }
                this.compressedContentSize = this.compressedContent.length;
                break;
            }
        }
    }

    public void uncompress() {
        if (this.rawContent != null || this.compressedContent == null) {
            return;
        }
        switch (this.method) {
            case RAW: {
                this.rawContent = this.compressedContent;
                this.rawContentSize = this.compressedContentSize;
                break;
            }
            case GZIP: {
                try {
                    this.rawContent = ByteBufferUtils.gunzip(this.compressedContent);
                    break;
                }
                catch (IOException e2) {
                    throw new RuntimeException("This should have never happned.", e2);
                }
            }
            default: {
                throw new RuntimeException("Unknown block compression method: " + this.method.name());
            }
        }
    }

    public void write(OutputStream os) throws IOException {
        if (!this.isCompressed()) {
            this.compress();
        }
        if (!this.isUncompressed()) {
            this.uncompress();
        }
        os.write(this.method.ordinal());
        os.write(this.contentType.ordinal());
        os.write(this.contentId);
        ByteBufferUtils.writeUnsignedITF8(this.compressedContentSize, os);
        ByteBufferUtils.writeUnsignedITF8(this.rawContentSize, os);
        os.write(this.getCompressedContent());
    }
}

