/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BetaIntegerEncoding;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.ExternalLongEncoding;
import htsjdk.samtools.cram.encoding.GammaIntegerEncoding;
import htsjdk.samtools.cram.encoding.GolombIntegerEncoding;
import htsjdk.samtools.cram.encoding.GolombLongEncoding;
import htsjdk.samtools.cram.encoding.GolombRiceIntegerEncoding;
import htsjdk.samtools.cram.encoding.HuffmanByteEncoding;
import htsjdk.samtools.cram.encoding.HuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.encoding.SubexpIntegerEncoding;
import htsjdk.samtools.cram.structure.EncodingID;

public class EncodingFactory {
    public <T> Encoding<T> createEncoding(DataSeriesType valueType2, EncodingID id) {
        switch (valueType2) {
            case BYTE: {
                switch (id) {
                    case EXTERNAL: {
                        return new ExternalByteEncoding();
                    }
                    case HUFFMAN: {
                        return new HuffmanByteEncoding();
                    }
                    case NULL: {
                        return new NullEncoding();
                    }
                }
                break;
            }
            case INT: {
                switch (id) {
                    case HUFFMAN: {
                        return new HuffmanIntegerEncoding();
                    }
                    case NULL: {
                        return new NullEncoding();
                    }
                    case EXTERNAL: {
                        return new ExternalIntegerEncoding();
                    }
                    case GOLOMB: {
                        return new GolombIntegerEncoding();
                    }
                    case GOLOMB_RICE: {
                        return new GolombRiceIntegerEncoding();
                    }
                    case BETA: {
                        return new BetaIntegerEncoding();
                    }
                    case GAMMA: {
                        return new GammaIntegerEncoding();
                    }
                    case SUBEXP: {
                        return new SubexpIntegerEncoding();
                    }
                }
                break;
            }
            case LONG: {
                switch (id) {
                    case NULL: {
                        return new NullEncoding();
                    }
                    case GOLOMB: {
                        return new GolombLongEncoding();
                    }
                    case EXTERNAL: {
                        return new ExternalLongEncoding();
                    }
                }
                break;
            }
            case BYTE_ARRAY: {
                switch (id) {
                    case NULL: {
                        return new NullEncoding();
                    }
                    case BYTE_ARRAY_LEN: {
                        return new ByteArrayLenEncoding();
                    }
                    case BYTE_ARRAY_STOP: {
                        return new ByteArrayStopEncoding();
                    }
                    case EXTERNAL: {
                        return new ExternalByteArrayEncoding();
                    }
                }
                break;
            }
        }
        return null;
    }

    public Encoding<byte[]> createByteArrayEncoding(EncodingID id) {
        switch (id) {
            case BYTE_ARRAY_LEN: {
                return new ByteArrayLenEncoding();
            }
            case BYTE_ARRAY_STOP: {
                return new ByteArrayLenEncoding();
            }
            case EXTERNAL: {
                return new ExternalByteArrayEncoding();
            }
        }
        return null;
    }

    public Encoding<Byte> createByteEncoding(EncodingID id) {
        switch (id) {
            case EXTERNAL: {
                return new ExternalByteEncoding();
            }
        }
        return null;
    }

    public Encoding<Integer> createIntEncoding(EncodingID id) {
        return null;
    }
}

