/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BetaIntegerCodec;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class BetaIntegerEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.BETA;
    private int offset;
    private int bitLimit;

    public BetaIntegerEncoding() {
    }

    public BetaIntegerEncoding(int bitLimit) {
        this.bitLimit = bitLimit;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int offset, int bitLimit) {
        BetaIntegerEncoding e2 = new BetaIntegerEncoding();
        e2.offset = offset;
        e2.bitLimit = bitLimit;
        return new EncodingParams(ENCODING_ID, e2.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(this.offset, buf);
        ByteBufferUtils.writeUnsignedITF8(this.bitLimit, buf);
        buf.flip();
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.offset = ByteBufferUtils.readUnsignedITF8(buf);
        this.bitLimit = ByteBufferUtils.readUnsignedITF8(buf);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new BetaIntegerCodec(this.offset, this.bitLimit);
    }
}

