/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMSequenceRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SAMSequenceDictionary
implements Serializable {
    public static final long serialVersionUID = 1L;
    private List<SAMSequenceRecord> mSequences = new ArrayList<SAMSequenceRecord>();
    private final Map<String, SAMSequenceRecord> mSequenceMap = new HashMap<String, SAMSequenceRecord>();
    private static String DICT_MISMATCH_TEMPLATE = "SAM dictionaries are not the same: %s.";

    public SAMSequenceDictionary() {
    }

    public SAMSequenceDictionary(List<SAMSequenceRecord> list) {
        this();
        this.setSequences(list);
    }

    public List<SAMSequenceRecord> getSequences() {
        return Collections.unmodifiableList(this.mSequences);
    }

    public SAMSequenceRecord getSequence(String name) {
        return this.mSequenceMap.get(name);
    }

    public void setSequences(List<SAMSequenceRecord> list) {
        this.mSequences = list;
        this.mSequenceMap.clear();
        int index = 0;
        for (SAMSequenceRecord record : list) {
            record.setSequenceIndex(index++);
            if (this.mSequenceMap.put(record.getSequenceName(), record) == null) continue;
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + record.getSequenceName());
        }
    }

    public void addSequence(SAMSequenceRecord sequenceRecord) {
        if (this.mSequenceMap.containsKey(sequenceRecord.getSequenceName())) {
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sequenceRecord.getSequenceName());
        }
        sequenceRecord.setSequenceIndex(this.mSequences.size());
        this.mSequences.add(sequenceRecord);
        this.mSequenceMap.put(sequenceRecord.getSequenceName(), sequenceRecord);
    }

    public SAMSequenceRecord getSequence(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.mSequences.size()) {
            return null;
        }
        return this.mSequences.get(sequenceIndex);
    }

    public int getSequenceIndex(String sequenceName) {
        SAMSequenceRecord record = this.mSequenceMap.get(sequenceName);
        if (record == null) {
            return -1;
        }
        return record.getSequenceIndex();
    }

    public int size() {
        return this.mSequences.size();
    }

    public long getReferenceLength() {
        long len = 0L;
        for (SAMSequenceRecord seq : this.getSequences()) {
            len += (long)seq.getSequenceLength();
        }
        return len;
    }

    public boolean isEmpty() {
        return this.mSequences.isEmpty();
    }

    public void assertSameDictionary(SAMSequenceDictionary that) {
        if (this == that) {
            return;
        }
        Iterator<SAMSequenceRecord> thatSequences = that.mSequences.iterator();
        for (SAMSequenceRecord thisSequence : this.mSequences) {
            if (!thatSequences.hasNext()) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thisSequence + " is present in only one dictionary"));
            }
            SAMSequenceRecord thatSequence = thatSequences.next();
            if (!thatSequence.isSameSequence(thisSequence)) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thatSequence + " was found when " + thisSequence + " was expected"));
            }
        }
        if (thatSequences.hasNext()) {
            throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thatSequences.next() + " is present in only one dictionary"));
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SAMSequenceDictionary that = (SAMSequenceDictionary)o2;
        return ((Object)this.mSequences).equals(that.mSequences);
    }

    public int hashCode() {
        return ((Object)this.mSequences).hashCode();
    }
}

