/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg.color;

import java.util.BitSet;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.experimental.alg.ExactAlgorithm;
import org.jgrapht.experimental.alg.IntArrayGraphAlgorithm;

public class BrownBacktrackColoring<V, E>
extends IntArrayGraphAlgorithm<V, E>
implements ExactAlgorithm<Integer, V> {
    private int[] _color;
    private int[] _colorCount;
    private BitSet[] _allowedColors;
    private int _chi;

    public BrownBacktrackColoring(Graph<V, E> graph) {
        super(graph);
    }

    void recursiveColor(int n2) {
        int n3;
        this._colorCount[n2] = this._colorCount[n2 - 1];
        this._allowedColors[n2].set(0, this._colorCount[n2] + 1);
        for (n3 = 0; n3 < this._neighbors[n2].length; ++n3) {
            int n4 = this._neighbors[n2][n3];
            if (this._color[n4] <= 0) continue;
            this._allowedColors[n2].clear(this._color[n4]);
        }
        for (n3 = 1; n3 <= this._colorCount[n2] && this._colorCount[n2] < this._chi; ++n3) {
            if (!this._allowedColors[n2].get(n3)) continue;
            this._color[n2] = n3;
            if (n2 < this._neighbors.length - 1) {
                this.recursiveColor(n2 + 1);
                continue;
            }
            this._chi = this._colorCount[n2];
        }
        if (this._colorCount[n2] + 1 < this._chi) {
            int n5 = n2;
            this._colorCount[n5] = this._colorCount[n5] + 1;
            this._color[n2] = this._colorCount[n2];
            if (n2 < this._neighbors.length - 1) {
                this.recursiveColor(n2 + 1);
            } else {
                this._chi = this._colorCount[n2];
            }
        }
        this._color[n2] = 0;
    }

    @Override
    public Integer getResult(Map<V, Object> map) {
        int n2;
        this._chi = this._neighbors.length;
        this._color = new int[this._neighbors.length];
        this._color[0] = 1;
        this._colorCount = new int[this._neighbors.length];
        this._colorCount[0] = 1;
        this._allowedColors = new BitSet[this._neighbors.length];
        for (n2 = 0; n2 < this._neighbors.length; ++n2) {
            this._allowedColors[n2] = new BitSet(1);
        }
        this.recursiveColor(1);
        if (map != null) {
            for (n2 = 0; n2 < this._vertices.size(); ++n2) {
                map.put(this._vertices.get(n2), this._color[n2]);
            }
        }
        return this._chi;
    }
}

