/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x500.style;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.X500NameTokenizer;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class IETFUtils {
    public static RDN[] rDNsFromString(String name, X500NameStyle x500Style) {
        X500NameTokenizer nTok = new X500NameTokenizer(name);
        X500NameBuilder builder = new X500NameBuilder(x500Style);
        while (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String attr = token.substring(0, index);
            String value = token.substring(index + 1);
            ASN1ObjectIdentifier oid = x500Style.attrNameToOID(attr);
            if (value.indexOf(43) > 0) {
                X500NameTokenizer vTok = new X500NameTokenizer(value, '+');
                String v2 = vTok.nextToken();
                Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
                Vector<String> values = new Vector<String>();
                oids.addElement(oid);
                values.addElement(v2);
                while (vTok.hasMoreTokens()) {
                    String sv = vTok.nextToken();
                    int ndx = sv.indexOf(61);
                    String nm = sv.substring(0, ndx);
                    String vl = sv.substring(ndx + 1);
                    oids.addElement(x500Style.attrNameToOID(nm));
                    values.addElement(vl);
                }
                builder.addMultiValuedRDN(IETFUtils.toOIDArray(oids), IETFUtils.toValueArray(values));
                continue;
            }
            builder.addRDN(oid, value);
        }
        return builder.build().getRDNs();
    }

    private static String[] toValueArray(Vector values) {
        String[] tmp = new String[values.size()];
        for (int i2 = 0; i2 != tmp.length; ++i2) {
            tmp[i2] = (String)values.elementAt(i2);
        }
        return tmp;
    }

    private static ASN1ObjectIdentifier[] toOIDArray(Vector oids) {
        ASN1ObjectIdentifier[] tmp = new ASN1ObjectIdentifier[oids.size()];
        for (int i2 = 0; i2 != tmp.length; ++i2) {
            tmp[i2] = (ASN1ObjectIdentifier)oids.elementAt(i2);
        }
        return tmp;
    }

    public static ASN1ObjectIdentifier decodeAttrName(String name, Hashtable lookUp) {
        if (Strings.toUpperCase(name).startsWith("OID.")) {
            return new ASN1ObjectIdentifier(name.substring(4));
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(name);
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)lookUp.get(Strings.toLowerCase(name));
        if (oid == null) {
            throw new IllegalArgumentException("Unknown object id - " + name + " - passed to distinguished name");
        }
        return oid;
    }

    public static ASN1Encodable valueFromHexString(String str, int off) throws IOException {
        str = Strings.toLowerCase(str);
        byte[] data = new byte[(str.length() - off) / 2];
        for (int index = 0; index != data.length; ++index) {
            char left = str.charAt(index * 2 + off);
            char right = str.charAt(index * 2 + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n2 = index;
                data[n2] = (byte)(data[n2] | (byte)(right - 48));
                continue;
            }
            int n3 = index;
            data[n3] = (byte)(data[n3] | (byte)(right - 97 + 10));
        }
        return ASN1Primitive.fromByteArray(data);
    }

    public static void appendTypeAndValue(StringBuffer buf, AttributeTypeAndValue typeAndValue, Hashtable oidSymbols) {
        String sym = (String)oidSymbols.get(typeAndValue.getType());
        if (sym != null) {
            buf.append(sym);
        } else {
            buf.append(typeAndValue.getType().getId());
        }
        buf.append('=');
        buf.append(IETFUtils.valueToString(typeAndValue.getValue()));
    }

    public static String valueToString(ASN1Encodable value) {
        StringBuffer vBuf = new StringBuffer();
        if (value instanceof ASN1String && !(value instanceof DERUniversalString)) {
            String v2 = ((ASN1String)((Object)value)).getString();
            if (v2.length() > 0 && v2.charAt(0) == '#') {
                vBuf.append("\\" + v2);
            } else {
                vBuf.append(v2);
            }
        } else {
            try {
                vBuf.append("#" + IETFUtils.bytesToString(Hex.encode(value.toASN1Primitive().getEncoded("DER"))));
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("Other value has no encoded form");
            }
        }
        int end = vBuf.length();
        int index = 0;
        if (vBuf.length() >= 2 && vBuf.charAt(0) == '\\' && vBuf.charAt(1) == '#') {
            index += 2;
        }
        while (index != end) {
            if (vBuf.charAt(index) == ',' || vBuf.charAt(index) == '\"' || vBuf.charAt(index) == '\\' || vBuf.charAt(index) == '+' || vBuf.charAt(index) == '=' || vBuf.charAt(index) == '<' || vBuf.charAt(index) == '>' || vBuf.charAt(index) == ';') {
                vBuf.insert(index, "\\");
                ++index;
                ++end;
            }
            ++index;
        }
        return vBuf.toString();
    }

    private static String bytesToString(byte[] data) {
        char[] cs = new char[data.length];
        for (int i2 = 0; i2 != cs.length; ++i2) {
            cs[i2] = (char)(data[i2] & 0xFF);
        }
        return new String(cs);
    }

    public static String canonicalize(String s2) {
        ASN1Primitive obj;
        String value = Strings.toLowerCase(s2.trim());
        if (value.length() > 0 && value.charAt(0) == '#' && (obj = IETFUtils.decodeObject(value)) instanceof ASN1String) {
            value = Strings.toLowerCase(((ASN1String)((Object)obj)).getString().trim());
        }
        value = IETFUtils.stripInternalSpaces(value);
        return value;
    }

    private static ASN1Primitive decodeObject(String oValue) {
        try {
            return ASN1Primitive.fromByteArray(Hex.decode(oValue.substring(1)));
        }
        catch (IOException e2) {
            throw new IllegalStateException("unknown encoding in name: " + e2);
        }
    }

    public static String stripInternalSpaces(String str) {
        StringBuffer res = new StringBuffer();
        if (str.length() != 0) {
            char c1 = str.charAt(0);
            res.append(c1);
            for (int k2 = 1; k2 < str.length(); ++k2) {
                char c2 = str.charAt(k2);
                if (c1 != ' ' || c2 != ' ') {
                    res.append(c2);
                }
                c1 = c2;
            }
        }
        return res.toString();
    }
}

