/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.BigMatrix;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.SingularMatrixException;

@Deprecated
public class BigMatrixImpl
implements BigMatrix,
Serializable {
    static final BigDecimal ZERO = new BigDecimal(0);
    static final BigDecimal ONE = new BigDecimal(1);
    private static final BigDecimal TOO_SMALL = new BigDecimal(1.0E-11);
    private static final long serialVersionUID = -1011428905656140431L;
    protected BigDecimal[][] data = null;
    protected BigDecimal[][] lu = null;
    protected int[] permutation = null;
    protected int parity = 1;
    private int roundingMode = 4;
    private int scale = 64;

    public BigMatrixImpl() {
    }

    public BigMatrixImpl(int rowDimension, int columnDimension) {
        if (rowDimension < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, rowDimension, 1);
        }
        if (columnDimension < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, columnDimension, 1);
        }
        this.data = new BigDecimal[rowDimension][columnDimension];
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[][] d2) {
        this.copyIn(d2);
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[][] d2, boolean copyArray) {
        if (copyArray) {
            this.copyIn(d2);
        } else {
            if (d2 == null) {
                throw new NullPointerException();
            }
            int nRows = d2.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = d2[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            for (int r2 = 1; r2 < nRows; ++r2) {
                if (d2[r2].length == nCols) continue;
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d2[r2].length);
            }
            this.data = d2;
        }
        this.lu = null;
    }

    public BigMatrixImpl(double[][] d2) {
        int nRows = d2.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = d2[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        for (int row = 1; row < nRows; ++row) {
            if (d2[row].length == nCols) continue;
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d2[row].length);
        }
        this.copyIn(d2);
        this.lu = null;
    }

    public BigMatrixImpl(String[][] d2) {
        int nRows = d2.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = d2[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        for (int row = 1; row < nRows; ++row) {
            if (d2[row].length == nCols) continue;
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d2[row].length);
        }
        this.copyIn(d2);
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[] v2) {
        int nRows = v2.length;
        this.data = new BigDecimal[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v2[row];
        }
    }

    public BigMatrix copy() {
        return new BigMatrixImpl(this.copyOut(), false);
    }

    public BigMatrix add(BigMatrix m2) throws IllegalArgumentException {
        try {
            return this.add((BigMatrixImpl)m2);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkAdditionCompatible(this, m2);
            int rowCount = this.getRowDimension();
            int columnCount = this.getColumnDimension();
            BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
            for (int row = 0; row < rowCount; ++row) {
                BigDecimal[] dataRow = this.data[row];
                BigDecimal[] outDataRow = outData[row];
                for (int col = 0; col < columnCount; ++col) {
                    outDataRow[col] = dataRow[col].add(m2.getEntry(row, col));
                }
            }
            return new BigMatrixImpl(outData, false);
        }
    }

    public BigMatrixImpl add(BigMatrixImpl m2) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] mRow = m2.data[row];
            BigDecimal[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col].add(mRow[col]);
            }
        }
        return new BigMatrixImpl(outData, false);
    }

    public BigMatrix subtract(BigMatrix m2) throws IllegalArgumentException {
        try {
            return this.subtract((BigMatrixImpl)m2);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkSubtractionCompatible(this, m2);
            int rowCount = this.getRowDimension();
            int columnCount = this.getColumnDimension();
            BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
            for (int row = 0; row < rowCount; ++row) {
                BigDecimal[] dataRow = this.data[row];
                BigDecimal[] outDataRow = outData[row];
                for (int col = 0; col < columnCount; ++col) {
                    outDataRow[col] = dataRow[col].subtract(this.getEntry(row, col));
                }
            }
            return new BigMatrixImpl(outData, false);
        }
    }

    public BigMatrixImpl subtract(BigMatrixImpl m2) throws IllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] mRow = m2.data[row];
            BigDecimal[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col].subtract(mRow[col]);
            }
        }
        return new BigMatrixImpl(outData, false);
    }

    public BigMatrix scalarAdd(BigDecimal d2) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col].add(d2);
            }
        }
        return new BigMatrixImpl(outData, false);
    }

    public BigMatrix scalarMultiply(BigDecimal d2) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col].multiply(d2);
            }
        }
        return new BigMatrixImpl(outData, false);
    }

    public BigMatrix multiply(BigMatrix m2) throws IllegalArgumentException {
        try {
            return this.multiply((BigMatrixImpl)m2);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkMultiplicationCompatible(this, m2);
            int nRows = this.getRowDimension();
            int nCols = m2.getColumnDimension();
            int nSum = this.getColumnDimension();
            BigDecimal[][] outData = new BigDecimal[nRows][nCols];
            for (int row = 0; row < nRows; ++row) {
                BigDecimal[] dataRow = this.data[row];
                BigDecimal[] outDataRow = outData[row];
                for (int col = 0; col < nCols; ++col) {
                    BigDecimal sum = ZERO;
                    for (int i2 = 0; i2 < nSum; ++i2) {
                        sum = sum.add(dataRow[i2].multiply(m2.getEntry(i2, col)));
                    }
                    outDataRow[col] = sum;
                }
            }
            return new BigMatrixImpl(outData, false);
        }
    }

    public BigMatrixImpl multiply(BigMatrixImpl m2) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m2);
        int nRows = this.getRowDimension();
        int nCols = m2.getColumnDimension();
        int nSum = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[nRows][nCols];
        for (int row = 0; row < nRows; ++row) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] outDataRow = outData[row];
            for (int col = 0; col < nCols; ++col) {
                BigDecimal sum = ZERO;
                for (int i2 = 0; i2 < nSum; ++i2) {
                    sum = sum.add(dataRow[i2].multiply(m2.data[i2][col]));
                }
                outDataRow[col] = sum;
            }
        }
        return new BigMatrixImpl(outData, false);
    }

    public BigMatrix preMultiply(BigMatrix m2) throws IllegalArgumentException {
        return m2.multiply(this);
    }

    public BigDecimal[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataAsDoubleArray() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        double[][] d2 = new double[nRows][nCols];
        for (int i2 = 0; i2 < nRows; ++i2) {
            for (int j2 = 0; j2 < nCols; ++j2) {
                d2[i2][j2] = this.data[i2][j2].doubleValue();
            }
        }
        return d2;
    }

    public BigDecimal[][] getDataRef() {
        return this.data;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public BigDecimal getNorm() {
        BigDecimal maxColSum = ZERO;
        for (int col = 0; col < this.getColumnDimension(); ++col) {
            BigDecimal sum = ZERO;
            for (int row = 0; row < this.getRowDimension(); ++row) {
                sum = sum.add(this.data[row][col].abs());
            }
            maxColSum = maxColSum.max(sum);
        }
        return maxColSum;
    }

    public BigMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, startRow);
        MatrixUtils.checkRowIndex(this, endRow);
        if (startRow > endRow) {
            throw new MatrixIndexException(LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, startRow, endRow);
        }
        MatrixUtils.checkColumnIndex(this, startColumn);
        MatrixUtils.checkColumnIndex(this, endColumn);
        if (startColumn > endColumn) {
            throw new MatrixIndexException(LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, startColumn, endColumn);
        }
        BigDecimal[][] subMatrixData = new BigDecimal[endRow - startRow + 1][endColumn - startColumn + 1];
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            System.arraycopy(this.data[i2], startColumn, subMatrixData[i2 - startRow], 0, endColumn - startColumn + 1);
        }
        return new BigMatrixImpl(subMatrixData, false);
    }

    public BigMatrix getSubMatrix(int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        if (selectedRows.length * selectedColumns.length == 0) {
            if (selectedRows.length == 0) {
                throw new MatrixIndexException(LocalizedFormats.EMPTY_SELECTED_ROW_INDEX_ARRAY, new Object[0]);
            }
            throw new MatrixIndexException(LocalizedFormats.EMPTY_SELECTED_COLUMN_INDEX_ARRAY, new Object[0]);
        }
        BigDecimal[][] subMatrixData = new BigDecimal[selectedRows.length][selectedColumns.length];
        try {
            for (int i2 = 0; i2 < selectedRows.length; ++i2) {
                BigDecimal[] subI = subMatrixData[i2];
                BigDecimal[] dataSelectedI = this.data[selectedRows[i2]];
                for (int j2 = 0; j2 < selectedColumns.length; ++j2) {
                    subI[j2] = dataSelectedI[selectedColumns[j2]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            for (int row : selectedRows) {
                MatrixUtils.checkRowIndex(this, row);
            }
            for (int column : selectedColumns) {
                MatrixUtils.checkColumnIndex(this, column);
            }
        }
        return new BigMatrixImpl(subMatrixData, false);
    }

    public void setSubMatrix(BigDecimal[][] subMatrix, int row, int column) throws MatrixIndexException {
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        for (int r2 = 1; r2 < nRows; ++r2) {
            if (subMatrix[r2].length == nCols) continue;
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[r2].length);
        }
        if (this.data == null) {
            if (row > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            this.data = new BigDecimal[nRows][nCols];
            System.arraycopy(subMatrix, 0, this.data, 0, subMatrix.length);
        } else {
            MatrixUtils.checkRowIndex(this, row);
            MatrixUtils.checkColumnIndex(this, column);
            MatrixUtils.checkRowIndex(this, nRows + row - 1);
            MatrixUtils.checkColumnIndex(this, nCols + column - 1);
        }
        for (int i2 = 0; i2 < nRows; ++i2) {
            System.arraycopy(subMatrix[i2], 0, this.data[row + i2], column, nCols);
        }
        this.lu = null;
    }

    public BigMatrix getRowMatrix(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int ncols = this.getColumnDimension();
        BigDecimal[][] out = new BigDecimal[1][ncols];
        System.arraycopy(this.data[row], 0, out[0], 0, ncols);
        return new BigMatrixImpl(out, false);
    }

    public BigMatrix getColumnMatrix(int column) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            out[row][0] = this.data[row][column];
        }
        return new BigMatrixImpl(out, false);
    }

    public BigDecimal[] getRow(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int ncols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[ncols];
        System.arraycopy(this.data[row], 0, out, 0, ncols);
        return out;
    }

    public double[] getRowAsDoubleArray(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int ncols = this.getColumnDimension();
        double[] out = new double[ncols];
        for (int i2 = 0; i2 < ncols; ++i2) {
            out[i2] = this.data[row][i2].doubleValue();
        }
        return out;
    }

    public BigDecimal[] getColumn(int col) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, col);
        int nRows = this.getRowDimension();
        BigDecimal[] out = new BigDecimal[nRows];
        for (int i2 = 0; i2 < nRows; ++i2) {
            out[i2] = this.data[i2][col];
        }
        return out;
    }

    public double[] getColumnAsDoubleArray(int col) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, col);
        int nrows = this.getRowDimension();
        double[] out = new double[nrows];
        for (int i2 = 0; i2 < nrows; ++i2) {
            out[i2] = this.data[i2][col].doubleValue();
        }
        return out;
    }

    public BigDecimal getEntry(int row, int column) throws MatrixIndexException {
        try {
            return this.data[row][column];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public double getEntryAsDouble(int row, int column) throws MatrixIndexException {
        return this.getEntry(row, column).doubleValue();
    }

    public BigMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[nCols][nRows];
        for (int row = 0; row < nRows; ++row) {
            BigDecimal[] dataRow = this.data[row];
            for (int col = 0; col < nCols; ++col) {
                outData[col][row] = dataRow[col];
            }
        }
        return new BigMatrixImpl(outData, false);
    }

    public BigMatrix inverse() throws InvalidMatrixException {
        return this.solve(MatrixUtils.createBigIdentityMatrix(this.getRowDimension()));
    }

    public BigDecimal getDeterminant() throws InvalidMatrixException {
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (this.isSingular()) {
            return ZERO;
        }
        BigDecimal det = this.parity == 1 ? ONE : ONE.negate();
        for (int i2 = 0; i2 < this.getRowDimension(); ++i2) {
            det = det.multiply(this.lu[i2][i2]);
        }
        return det;
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    public boolean isSingular() {
        if (this.lu == null) {
            try {
                this.luDecompose();
                return false;
            }
            catch (InvalidMatrixException ex) {
                return true;
            }
        }
        return false;
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data[0].length;
    }

    public BigDecimal getTrace() throws IllegalArgumentException {
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        BigDecimal trace = this.data[0][0];
        for (int i2 = 1; i2 < this.getRowDimension(); ++i2) {
            trace = trace.add(this.data[i2][i2]);
        }
        return trace;
    }

    public BigDecimal[] operate(BigDecimal[] v2) throws IllegalArgumentException {
        if (v2.length != this.getColumnDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v2.length, this.getColumnDimension());
        }
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[nRows];
        for (int row = 0; row < nRows; ++row) {
            BigDecimal sum = ZERO;
            for (int i2 = 0; i2 < nCols; ++i2) {
                sum = sum.add(this.data[row][i2].multiply(v2[i2]));
            }
            out[row] = sum;
        }
        return out;
    }

    public BigDecimal[] operate(double[] v2) throws IllegalArgumentException {
        BigDecimal[] bd = new BigDecimal[v2.length];
        for (int i2 = 0; i2 < bd.length; ++i2) {
            bd[i2] = new BigDecimal(v2[i2]);
        }
        return this.operate(bd);
    }

    public BigDecimal[] preMultiply(BigDecimal[] v2) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        if (v2.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v2.length, nRows);
        }
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[nCols];
        for (int col = 0; col < nCols; ++col) {
            BigDecimal sum = ZERO;
            for (int i2 = 0; i2 < nRows; ++i2) {
                sum = sum.add(this.data[i2][col].multiply(v2[i2]));
            }
            out[col] = sum;
        }
        return out;
    }

    public BigDecimal[] solve(BigDecimal[] b2) throws IllegalArgumentException, InvalidMatrixException {
        int nRows = this.getRowDimension();
        if (b2.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b2.length, nRows);
        }
        BigMatrixImpl bMatrix = new BigMatrixImpl(b2);
        BigDecimal[][] solution = ((BigMatrixImpl)this.solve(bMatrix)).getDataRef();
        BigDecimal[] out = new BigDecimal[nRows];
        for (int row = 0; row < nRows; ++row) {
            out[row] = solution[row][0];
        }
        return out;
    }

    public BigDecimal[] solve(double[] b2) throws IllegalArgumentException, InvalidMatrixException {
        BigDecimal[] bd = new BigDecimal[b2.length];
        for (int i2 = 0; i2 < bd.length; ++i2) {
            bd[i2] = new BigDecimal(b2[i2]);
        }
        return this.solve(bd);
    }

    public BigMatrix solve(BigMatrix b2) throws IllegalArgumentException, InvalidMatrixException {
        int col;
        if (b2.getRowDimension() != this.getRowDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b2.getRowDimension(), b2.getColumnDimension(), this.getRowDimension(), "n");
        }
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (this.isSingular()) {
            throw new SingularMatrixException();
        }
        int nCol = this.getColumnDimension();
        int nColB = b2.getColumnDimension();
        int nRowB = b2.getRowDimension();
        BigDecimal[][] bp = new BigDecimal[nRowB][nColB];
        for (int row = 0; row < nRowB; ++row) {
            BigDecimal[] bpRow = bp[row];
            for (int col2 = 0; col2 < nColB; ++col2) {
                bpRow[col2] = b2.getEntry(this.permutation[row], col2);
            }
        }
        for (col = 0; col < nCol; ++col) {
            for (int i2 = col + 1; i2 < nCol; ++i2) {
                BigDecimal[] bpI = bp[i2];
                BigDecimal[] luI = this.lu[i2];
                for (int j2 = 0; j2 < nColB; ++j2) {
                    bpI[j2] = bpI[j2].subtract(bp[col][j2].multiply(luI[col]));
                }
            }
        }
        for (col = nCol - 1; col >= 0; --col) {
            BigDecimal[] bpCol = bp[col];
            BigDecimal luDiag = this.lu[col][col];
            for (int j3 = 0; j3 < nColB; ++j3) {
                bpCol[j3] = bpCol[j3].divide(luDiag, this.scale, this.roundingMode);
            }
            for (int i3 = 0; i3 < col; ++i3) {
                BigDecimal[] bpI = bp[i3];
                BigDecimal[] luI = this.lu[i3];
                for (int j4 = 0; j4 < nColB; ++j4) {
                    bpI[j4] = bpI[j4].subtract(bp[col][j4].multiply(luI[col]));
                }
            }
        }
        return new BigMatrixImpl(bp, false);
    }

    public void luDecompose() throws InvalidMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        this.lu = this.getData();
        this.permutation = new int[nRows];
        for (int row = 0; row < nRows; ++row) {
            this.permutation[row] = row;
        }
        this.parity = 1;
        for (int col = 0; col < nCols; ++col) {
            BigDecimal sum = ZERO;
            for (int row = 0; row < col; ++row) {
                BigDecimal[] luRow = this.lu[row];
                sum = luRow[col];
                for (int i2 = 0; i2 < row; ++i2) {
                    sum = sum.subtract(luRow[i2].multiply(this.lu[i2][col]));
                }
                luRow[col] = sum;
            }
            int max = col;
            BigDecimal largest = ZERO;
            for (int row = col; row < nRows; ++row) {
                BigDecimal[] luRow = this.lu[row];
                sum = luRow[col];
                for (int i3 = 0; i3 < col; ++i3) {
                    sum = sum.subtract(luRow[i3].multiply(this.lu[i3][col]));
                }
                luRow[col] = sum;
                if (sum.abs().compareTo(largest) != 1) continue;
                largest = sum.abs();
                max = row;
            }
            if (this.lu[max][col].abs().compareTo(TOO_SMALL) <= 0) {
                this.lu = null;
                throw new SingularMatrixException();
            }
            if (max != col) {
                BigDecimal tmp = ZERO;
                for (int i4 = 0; i4 < nCols; ++i4) {
                    tmp = this.lu[max][i4];
                    this.lu[max][i4] = this.lu[col][i4];
                    this.lu[col][i4] = tmp;
                }
                int temp = this.permutation[max];
                this.permutation[max] = this.permutation[col];
                this.permutation[col] = temp;
                this.parity = -this.parity;
            }
            BigDecimal luDiag = this.lu[col][col];
            for (int row = col + 1; row < nRows; ++row) {
                BigDecimal[] luRow = this.lu[row];
                luRow[col] = luRow[col].divide(luDiag, this.scale, this.roundingMode);
            }
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("BigMatrixImpl{");
        if (this.data != null) {
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (i2 > 0) {
                    res.append(",");
                }
                res.append("{");
                for (int j2 = 0; j2 < this.data[0].length; ++j2) {
                    if (j2 > 0) {
                        res.append(",");
                    }
                    res.append(this.data[i2][j2]);
                }
                res.append("}");
            }
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigMatrixImpl)) {
            return false;
        }
        BigMatrix m2 = (BigMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m2.getColumnDimension() != nCols || m2.getRowDimension() != nRows) {
            return false;
        }
        for (int row = 0; row < nRows; ++row) {
            BigDecimal[] dataRow = this.data[row];
            for (int col = 0; col < nCols; ++col) {
                if (dataRow[col].equals(m2.getEntry(row, col))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        for (int row = 0; row < nRows; ++row) {
            BigDecimal[] dataRow = this.data[row];
            for (int col = 0; col < nCols; ++col) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * dataRow[col].hashCode();
            }
        }
        return ret;
    }

    protected BigMatrix getLUMatrix() throws InvalidMatrixException {
        if (this.lu == null) {
            this.luDecompose();
        }
        return new BigMatrixImpl(this.lu);
    }

    protected int[] getPermutation() {
        int[] out = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, out, 0, this.permutation.length);
        return out;
    }

    private BigDecimal[][] copyOut() {
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][this.getColumnDimension()];
        for (int i2 = 0; i2 < nRows; ++i2) {
            System.arraycopy(this.data[i2], 0, out[i2], 0, this.data[i2].length);
        }
        return out;
    }

    private void copyIn(BigDecimal[][] in) {
        this.setSubMatrix(in, 0, 0);
    }

    private void copyIn(double[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        for (int i2 = 0; i2 < nRows; ++i2) {
            BigDecimal[] dataI = this.data[i2];
            double[] inI = in[i2];
            for (int j2 = 0; j2 < nCols; ++j2) {
                dataI[j2] = new BigDecimal(inI[j2]);
            }
        }
        this.lu = null;
    }

    private void copyIn(String[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        for (int i2 = 0; i2 < nRows; ++i2) {
            BigDecimal[] dataI = this.data[i2];
            String[] inI = in[i2];
            for (int j2 = 0; j2 < nCols; ++j2) {
                dataI[j2] = new BigDecimal(inI[j2]);
            }
        }
        this.lu = null;
    }
}

