/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

public class ScannerUtilities {
    protected static final int[] IDENTIFIER_START = new int[]{0, 0, -2013265922, 0x7FFFFFE};
    protected static final int[] NAME = new int[]{0, 67051520, -2013265922, 0x7FFFFFE};
    protected static final int[] HEXADECIMAL = new int[]{0, 0x3FF0000, 126, 126};
    protected static final int[] STRING = new int[]{512, -133, -1, Integer.MAX_VALUE};
    protected static final int[] URI = new int[]{0, -902, -1, Integer.MAX_VALUE};

    protected ScannerUtilities() {
    }

    public static boolean isCSSSpace(char c2) {
        return c2 <= ' ' && (4294981120L >> c2 & 1L) != 0L;
    }

    public static boolean isCSSIdentifierStartCharacter(char c2) {
        return c2 >= '\u0080' || (IDENTIFIER_START[c2 >> 5] & 1 << (c2 & 0x1F)) != 0;
    }

    public static boolean isCSSNameCharacter(char c2) {
        return c2 >= '\u0080' || (NAME[c2 >> 5] & 1 << (c2 & 0x1F)) != 0;
    }

    public static boolean isCSSHexadecimalCharacter(char c2) {
        return c2 < '\u0080' && (HEXADECIMAL[c2 >> 5] & 1 << (c2 & 0x1F)) != 0;
    }

    public static boolean isCSSStringCharacter(char c2) {
        return c2 >= '\u0080' || (STRING[c2 >> 5] & 1 << (c2 & 0x1F)) != 0;
    }

    public static boolean isCSSURICharacter(char c2) {
        return c2 >= '\u0080' || (URI[c2 >> 5] & 1 << (c2 & 0x1F)) != 0;
    }
}

