/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridFS {
    private static final Logger LOGGER = Logger.getLogger("com.mongodb.gridfs");
    public static final int DEFAULT_CHUNKSIZE = 262144;
    @Deprecated
    public static final long MAX_CHUNKSIZE = 3500000L;
    public static final String DEFAULT_BUCKET = "fs";
    protected final DB _db;
    protected final String _bucketName;
    protected final DBCollection _filesCollection;
    protected final DBCollection _chunkCollection;

    public GridFS(DB db) {
        this(db, DEFAULT_BUCKET);
    }

    public GridFS(DB db, String bucket) {
        this._db = db;
        this._bucketName = bucket;
        this._filesCollection = this._db.getCollection(this._bucketName + ".files");
        this._chunkCollection = this._db.getCollection(this._bucketName + ".chunks");
        try {
            if (this._filesCollection.count() < 1000L) {
                this._filesCollection.ensureIndex(BasicDBObjectBuilder.start().add("filename", 1).add("uploadDate", 1).get());
            }
            if (this._chunkCollection.count() < 1000L) {
                this._chunkCollection.ensureIndex(BasicDBObjectBuilder.start().add("files_id", 1).add("n", 1).get(), BasicDBObjectBuilder.start().add("unique", true).get());
            }
        }
        catch (MongoException e2) {
            LOGGER.info(String.format("Unable to ensure indices on GridFS collections in database %s", db.getName()));
        }
        this._filesCollection.setObjectClass(GridFSDBFile.class);
    }

    public DBCursor getFileList() {
        return this.getFileList(new BasicDBObject());
    }

    public DBCursor getFileList(DBObject query) {
        return this.getFileList(query, new BasicDBObject("filename", (Object)1));
    }

    public DBCursor getFileList(DBObject query, DBObject sort) {
        return this._filesCollection.find(query).sort(sort);
    }

    public GridFSDBFile find(ObjectId id) {
        return this.findOne(id);
    }

    public GridFSDBFile findOne(ObjectId id) {
        return this.findOne(new BasicDBObject("_id", id));
    }

    public GridFSDBFile findOne(String filename) {
        return this.findOne(new BasicDBObject("filename", filename));
    }

    public GridFSDBFile findOne(DBObject query) {
        return this._fix(this._filesCollection.findOne(query));
    }

    public List<GridFSDBFile> find(String filename) {
        return this.find(filename, null);
    }

    public List<GridFSDBFile> find(String filename, DBObject sort) {
        return this.find(new BasicDBObject("filename", filename), sort);
    }

    public List<GridFSDBFile> find(DBObject query) {
        return this.find(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GridFSDBFile> find(DBObject query, DBObject sort) {
        ArrayList<GridFSDBFile> files = new ArrayList<GridFSDBFile>();
        DBCursor c2 = null;
        try {
            c2 = this._filesCollection.find(query);
            if (sort != null) {
                c2.sort(sort);
            }
            while (c2.hasNext()) {
                files.add(this._fix(c2.next()));
            }
        }
        finally {
            if (c2 != null) {
                c2.close();
            }
        }
        return files;
    }

    protected GridFSDBFile _fix(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (!(o2 instanceof GridFSDBFile)) {
            throw new RuntimeException("somehow didn't get a GridFSDBFile");
        }
        GridFSDBFile f2 = (GridFSDBFile)o2;
        f2._fs = this;
        return f2;
    }

    public void remove(ObjectId id) {
        this._filesCollection.remove(new BasicDBObject("_id", id));
        this._chunkCollection.remove(new BasicDBObject("files_id", id));
    }

    public void remove(String filename) {
        this.remove(new BasicDBObject("filename", filename));
    }

    public void remove(DBObject query) {
        for (GridFSDBFile f2 : this.find(query)) {
            f2.remove();
        }
    }

    public GridFSInputFile createFile(byte[] data) {
        return this.createFile((InputStream)new ByteArrayInputStream(data), true);
    }

    public GridFSInputFile createFile(File f2) throws IOException {
        return this.createFile(new FileInputStream(f2), f2.getName(), true);
    }

    public GridFSInputFile createFile(InputStream in) {
        return this.createFile(in, null);
    }

    public GridFSInputFile createFile(InputStream in, boolean closeStreamOnPersist) {
        return this.createFile(in, null, closeStreamOnPersist);
    }

    public GridFSInputFile createFile(InputStream in, String filename) {
        return new GridFSInputFile(this, in, filename);
    }

    public GridFSInputFile createFile(InputStream in, String filename, boolean closeStreamOnPersist) {
        return new GridFSInputFile(this, in, filename, closeStreamOnPersist);
    }

    public GridFSInputFile createFile(String filename) {
        return new GridFSInputFile(this, filename);
    }

    public GridFSInputFile createFile() {
        return new GridFSInputFile(this);
    }

    public String getBucketName() {
        return this._bucketName;
    }

    public DB getDB() {
        return this._db;
    }
}

