/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DBPointer;
import com.mongodb.DBRefBase;
import org.bson.BSONObject;
import org.bson.BasicBSONEncoder;
import org.bson.io.OutputBuffer;
import org.bson.types.ObjectId;

public class DefaultDBEncoder
extends BasicBSONEncoder
implements DBEncoder {
    public static DBEncoderFactory FACTORY = new DefaultFactory();

    public int writeObject(OutputBuffer buf, BSONObject o2) {
        this.set(buf);
        int x2 = super.putObject(o2);
        this.done();
        return x2;
    }

    protected boolean putSpecial(String name, Object val) {
        if (val instanceof DBPointer) {
            DBPointer r2 = (DBPointer)val;
            this.putDBPointer(name, r2._ns, (ObjectId)r2._id);
            return true;
        }
        if (val instanceof DBRefBase) {
            this.putDBRef(name, (DBRefBase)val);
            return true;
        }
        return false;
    }

    protected void putDBPointer(String name, String ns, ObjectId oid) {
        this._put((byte)12, name);
        this._putValueString(ns);
        this._buf.writeInt(oid._time());
        this._buf.writeInt(oid._machine());
        this._buf.writeInt(oid._inc());
    }

    protected void putDBRef(String name, DBRefBase ref) {
        this._put((byte)3, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putObjectField("$ref", ref.getRef());
        this._putObjectField("$id", ref.getId());
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    public String toString() {
        return "DefaultDBEncoder";
    }

    static class DefaultFactory
    implements DBEncoderFactory {
        DefaultFactory() {
        }

        public DBEncoder create() {
            return new DefaultDBEncoder();
        }

        public String toString() {
            return "DefaultDBEncoder.DefaultFactory";
        }
    }
}

