/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyleRange;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledLabel
extends JLabel {
    private static final String uiClassID = "StyledLabelUI";
    private List<StyleRange> _styleRanges;
    private boolean _lineWrap;
    private int _rows;
    private int _maxRows;
    private int _minRows;
    private int _preferredWidth;
    private int _rowGap;
    private boolean _truncated = false;
    private boolean _ignoreColorSettings;
    public static final String PROPERTY_STYLE_RANGE = "styleRange";
    public static final String PROPERTY_IGNORE_COLOR_SETTINGS = "ignoreColorSettings";

    public StyledLabel() {
        this.setMaximumSize(null);
    }

    public StyledLabel(Icon image) {
        super(image);
        this.setMaximumSize(null);
    }

    public StyledLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.setMaximumSize(null);
    }

    public StyledLabel(String text) {
        super(text);
        this.setMaximumSize(null);
    }

    public StyledLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.setMaximumSize(null);
    }

    public StyledLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.setMaximumSize(null);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized void addStyleRange(StyleRange styleRange) {
        if (styleRange == null) {
            throw new IllegalArgumentException("StyleRange cannot be null.");
        }
        List<StyleRange> ranges = this.internalGetStyleRanges();
        for (int i2 = ranges.size() - 1; i2 >= 0; --i2) {
            StyleRange range = ranges.get(i2);
            if (range.getStart() != styleRange.getStart() || range.getLength() != styleRange.getLength()) continue;
            ranges.remove(i2);
        }
        this.internalGetStyleRanges().add(styleRange);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRange);
    }

    public synchronized void setStyleRanges(StyleRange[] styleRanges) {
        this.internalGetStyleRanges().clear();
        this.addStyleRanges(styleRanges);
    }

    public synchronized void addStyleRanges(StyleRange[] styleRanges) {
        if (styleRanges != null) {
            for (StyleRange styleRange : styleRanges) {
                this.internalGetStyleRanges().add(styleRange);
            }
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRanges);
        } else {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
        }
    }

    public synchronized StyleRange[] getStyleRanges() {
        List<StyleRange> list = this.internalGetStyleRanges();
        return list.toArray(new StyleRange[list.size()]);
    }

    private List<StyleRange> internalGetStyleRanges() {
        if (this._styleRanges == null) {
            this._styleRanges = new Vector<StyleRange>();
        }
        return this._styleRanges;
    }

    public synchronized void clearStyleRange(StyleRange styleRange) {
        if (this.internalGetStyleRanges().remove(styleRange)) {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, styleRange, null);
        }
    }

    public synchronized void clearStyleRanges() {
        this.internalGetStyleRanges().clear();
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
    }

    public boolean isIgnoreColorSettings() {
        return this._ignoreColorSettings;
    }

    public void setIgnoreColorSettings(boolean ignoreColorSettings) {
        boolean old = this._ignoreColorSettings;
        if (old != ignoreColorSettings) {
            this._ignoreColorSettings = ignoreColorSettings;
            this.firePropertyChange(PROPERTY_IGNORE_COLOR_SETTINGS, old, ignoreColorSettings);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.isLineWrap() ? new Dimension(1, 1) : super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.isLineWrap() ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : super.getMaximumSize();
    }

    public void setPreferredWidth(int preferredWidth) {
        this._preferredWidth = preferredWidth;
    }

    public int getPreferredWidth() {
        return this._preferredWidth;
    }

    public boolean isLineWrap() {
        return this._lineWrap;
    }

    public void setLineWrap(boolean lineWrap) {
        this._lineWrap = lineWrap;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) {
        this._rows = rows;
    }

    public int getRowGap() {
        return this._rowGap;
    }

    public void setRowGap(int rowGap) {
        this._rowGap = rowGap;
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setMaxRows(int maxRows) {
        this._maxRows = maxRows;
    }

    public int getMinRows() {
        return this._minRows;
    }

    public void setMinRows(int minRows) {
        this._minRows = minRows;
    }

    public boolean isTruncated() {
        return this._truncated;
    }

    public void setTruncated(boolean truncated) {
        this._truncated = truncated;
    }
}

