/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.quality;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProvider;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

@CommandLineProgramProperties(usage="Classify PF-Failing reads in a HiSeqX Illumina Basecalling directory into various categories. The classification is based on a heuristic that was derived by looking at a few titration experiments.", usageShort="Classify PF-Failing reads in a HiSeqX Illumina Basecalling directory into various categories.", programGroup=Metrics.class)
public class CollectHiSeqXPfFailMetrics
extends CommandLineProgram {
    @Option(doc="The Illumina basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(shortName="O", doc="Basename for metrics file. Resulting file will be <OUTPUT>.pffail_summary_metrics", optional=false)
    public File OUTPUT;
    @Option(shortName="P", doc="The fraction of (non-PF) reads for which to output explicit classification. Output file will be <OUTPUT>.pffail_detailed_metrics (if PROB_EXPLICIT_READS != 0)", optional=true)
    public double PROB_EXPLICIT_READS = 0.0;
    @Option(doc="Lane number.", shortName="L")
    public Integer LANE;
    @Option(shortName="NP", doc="Run this many PerTileBarcodeExtractors in parallel.  If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0 then the number of cores used will be the number available on the machine less NUM_PROCESSORS.", optional=true)
    public int NUM_PROCESSORS = 1;
    @Option(doc="Number of cycles to look at. At time of writing PF status gets determined at cycle 24 so numbers greater than this will yield strange results. In addition, PF status is currently determined at cycle 24, so running this with any other value is neither tested nor recommended.", optional=true)
    public int N_CYCLES = 24;
    private static final Log LOG = Log.getInstance(CollectHiSeqXPfFailMetrics.class);
    private final Map<Integer, PFFailSummaryMetric> tileToSummaryMetrics = new LinkedHashMap<Integer, PFFailSummaryMetric>();
    private final Map<Integer, List<PFFailDetailedMetric>> tileToDetailedMetrics = new LinkedHashMap<Integer, List<PFFailDetailedMetric>>();
    private final ReadStructure READ_STRUCTURE = new ReadStructure(this.N_CYCLES + "T");
    public static final String detailedMetricsExtension = ".pffail_detailed_metrics";
    public static final String summaryMetricsExtension = ".pffail_summary_metrics";

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.N_CYCLES < 0) {
            errors.add("Number of Cycles to look at must be greater than 0");
        }
        if (this.PROB_EXPLICIT_READS > 1.0 || this.PROB_EXPLICIT_READS < 0.0) {
            errors.add("PROB_EXPLICIT_READS must be a probability, i.e., 0 <= PROB_EXPLICIT_READS <= 1");
        }
        if (errors.size() > 0) {
            return errors.toArray(new String[errors.size()]);
        }
        return super.customCommandLineValidation();
    }

    public static void main(String[] args) {
        new CollectHiSeqXPfFailMetrics().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IlluminaDataProviderFactory factory = new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, this.READ_STRUCTURE, new BclQualityEvaluationStrategy(2), IlluminaDataType.BaseCalls, IlluminaDataType.PF, IlluminaDataType.QualityScores, IlluminaDataType.Position);
        File summaryMetricsFileName = new File(this.OUTPUT + summaryMetricsExtension);
        File detailedMetricsFileName = new File(this.OUTPUT + detailedMetricsExtension);
        IOUtil.assertFileIsWritable(summaryMetricsFileName);
        if (this.PROB_EXPLICIT_READS != 0.0) {
            IOUtil.assertFileIsWritable(detailedMetricsFileName);
        }
        int numProcessors = this.NUM_PROCESSORS == 0 ? Runtime.getRuntime().availableProcessors() : (this.NUM_PROCESSORS < 0 ? Runtime.getRuntime().availableProcessors() + this.NUM_PROCESSORS : this.NUM_PROCESSORS);
        LOG.info("Processing with " + numProcessors + " PerTilePFMetricsExtractor(s).");
        ExecutorService pool = Executors.newFixedThreadPool(numProcessors);
        ArrayList<PerTilePFMetricsExtractor> extractors = new ArrayList<PerTilePFMetricsExtractor>(factory.getAvailableTiles().size());
        for (int tile : factory.getAvailableTiles()) {
            this.tileToSummaryMetrics.put(tile, new PFFailSummaryMetric(Integer.toString(tile)));
            this.tileToDetailedMetrics.put(tile, new ArrayList());
            PerTilePFMetricsExtractor extractor = new PerTilePFMetricsExtractor(tile, this.tileToSummaryMetrics.get(tile), (Collection<PFFailDetailedMetric>)this.tileToDetailedMetrics.get(tile), factory, this.PROB_EXPLICIT_READS);
            extractors.add(extractor);
        }
        try {
            for (PerTilePFMetricsExtractor extractor : extractors) {
                pool.submit(extractor);
            }
            pool.shutdown();
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable e2) {
            LOG.error(e2, "Parent thread encountered problem submitting extractors to thread pool or awaiting shutdown of threadpool.  Attempting to kill threadpool.");
            pool.shutdownNow();
            return 2;
        }
        LOG.info("Processed " + extractors.size() + " tiles.");
        for (PerTilePFMetricsExtractor extractor : extractors) {
            if (extractor.getException() == null) continue;
            LOG.error("Abandoning metrics calculation because one or more PerTilePFMetricsExtractors failed.");
            return 4;
        }
        MetricsFile detailedMetrics = this.getMetricsFile();
        for (List<PFFailDetailedMetric> detailedMetricCollection : this.tileToDetailedMetrics.values()) {
            for (PFFailDetailedMetric metric : detailedMetricCollection) {
                detailedMetrics.addMetric(metric);
            }
        }
        if (this.PROB_EXPLICIT_READS > 0.0) {
            detailedMetrics.write(detailedMetricsFileName);
        }
        PFFailSummaryMetric totalMetric = new PFFailSummaryMetric("All");
        for (PFFailSummaryMetric summaryMetric : this.tileToSummaryMetrics.values()) {
            totalMetric.merge(summaryMetric);
        }
        totalMetric.calculateDerivedFields();
        MetricsFile summaryMetricsFile = this.getMetricsFile();
        summaryMetricsFile.addMetric(totalMetric);
        for (PFFailSummaryMetric summaryMetric : this.tileToSummaryMetrics.values()) {
            summaryMetric.calculateDerivedFields();
            summaryMetricsFile.addMetric(summaryMetric);
        }
        summaryMetricsFile.write(summaryMetricsFileName);
        return 0;
    }

    private static int countEquals(byte[] array, byte toCount) {
        int count = 0;
        for (byte t2 : array) {
            if (t2 != toCount) continue;
            ++count;
        }
        return count;
    }

    private static int countGreaterThan(byte[] array, byte value) {
        int count = 0;
        for (byte t2 : array) {
            if (t2 <= value) continue;
            ++count;
        }
        return count;
    }

    public static class PFFailSummaryMetric
    extends MetricBase {
        public String TILE = null;
        public int READS = 0;
        public int PF_FAIL_READS = 0;
        public double PCT_PF_FAIL_READS = 0.0;
        public int PF_FAIL_EMPTY = 0;
        public double PCT_PF_FAIL_EMPTY = 0.0;
        public int PF_FAIL_POLYCLONAL = 0;
        public double PCT_PF_FAIL_POLYCLONAL = 0.0;
        public int PF_FAIL_MISALIGNED = 0;
        public double PCT_PF_FAIL_MISALIGNED = 0.0;
        public int PF_FAIL_UNKNOWN = 0;
        public double PCT_PF_FAIL_UNKNOWN = 0.0;

        public PFFailSummaryMetric(String tile) {
            this.TILE = tile;
        }

        public PFFailSummaryMetric() {
        }

        public void merge(PFFailSummaryMetric metric) {
            this.READS += metric.READS;
            this.PF_FAIL_READS += metric.PF_FAIL_READS;
            this.PF_FAIL_EMPTY += metric.PF_FAIL_EMPTY;
            this.PF_FAIL_MISALIGNED += metric.PF_FAIL_MISALIGNED;
            this.PF_FAIL_POLYCLONAL += metric.PF_FAIL_POLYCLONAL;
            this.PF_FAIL_UNKNOWN += metric.PF_FAIL_UNKNOWN;
        }

        public void calculateDerivedFields() {
            if (this.READS != 0) {
                this.PCT_PF_FAIL_READS = (double)this.PF_FAIL_READS / (double)this.READS;
                this.PCT_PF_FAIL_EMPTY = (double)this.PF_FAIL_EMPTY / (double)this.READS;
                this.PCT_PF_FAIL_MISALIGNED = (double)this.PF_FAIL_MISALIGNED / (double)this.READS;
                this.PCT_PF_FAIL_POLYCLONAL = (double)this.PF_FAIL_POLYCLONAL / (double)this.READS;
                this.PCT_PF_FAIL_UNKNOWN = (double)this.PF_FAIL_UNKNOWN / (double)this.READS;
            }
        }
    }

    public static class PFFailDetailedMetric
    extends MetricBase {
        public Integer TILE;
        public int X;
        public int Y;
        public int NUM_N;
        public int NUM_Q_GT_TWO;
        public ReadClassifier.PfFailReason CLASSIFICATION;

        public PFFailDetailedMetric(Integer TILE, int x2, int y, int NUM_N, int NUM_Q_GT_TWO, ReadClassifier.PfFailReason CLASSIFICATION) {
            this.TILE = TILE;
            this.X = x2;
            this.Y = y;
            this.NUM_N = NUM_N;
            this.NUM_Q_GT_TWO = NUM_Q_GT_TWO;
            this.CLASSIFICATION = CLASSIFICATION;
        }

        public PFFailDetailedMetric() {
        }
    }

    protected static class ReadClassifier {
        private final int numNs;
        private final int numQGtTwo;
        private PfFailReason failClass = null;

        public ReadClassifier(ReadData read) {
            int length = read.getBases().length;
            this.numNs = CollectHiSeqXPfFailMetrics.countEquals(read.getBases(), (byte)46);
            this.numQGtTwo = CollectHiSeqXPfFailMetrics.countGreaterThan(read.getQualities(), (byte)2);
            this.failClass = PfFailReason.UNKNOWN;
            if (this.numNs >= length - 1) {
                this.failClass = PfFailReason.MISALIGNED;
            } else if (this.numNs <= 1) {
                if (this.numQGtTwo <= length / 3) {
                    this.failClass = PfFailReason.EMPTY;
                } else if (this.numQGtTwo >= length / 2) {
                    this.failClass = PfFailReason.POLYCLONAL;
                }
            }
        }

        public static enum PfFailReason {
            EMPTY,
            POLYCLONAL,
            MISALIGNED,
            UNKNOWN;

        }
    }

    private static class PerTilePFMetricsExtractor
    implements Runnable {
        private final int tile;
        private final PFFailSummaryMetric summaryMetric;
        final Collection<PFFailDetailedMetric> detailedMetrics;
        private Exception exception = null;
        private final IlluminaDataProvider provider;
        private final double pWriteDetailed;
        private final Random random = new Random();

        public PerTilePFMetricsExtractor(int tile, PFFailSummaryMetric summaryMetric, Collection<PFFailDetailedMetric> detailedMetrics, IlluminaDataProviderFactory factory, double pWriteDetailed) {
            this.tile = tile;
            this.summaryMetric = summaryMetric;
            this.detailedMetrics = detailedMetrics;
            this.pWriteDetailed = pWriteDetailed;
            this.provider = factory.makeDataProvider(Arrays.asList(tile));
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOG.info("Extracting PF metrics for tile " + this.tile);
                block11: while (this.provider.hasNext()) {
                    ClusterData cluster = this.provider.next();
                    ++this.summaryMetric.READS;
                    if (cluster.isPf().booleanValue()) continue;
                    ++this.summaryMetric.PF_FAIL_READS;
                    ReadClassifier readClassifier = new ReadClassifier(cluster.getRead(0));
                    if (this.random.nextDouble() < this.pWriteDetailed) {
                        this.detailedMetrics.add(new PFFailDetailedMetric(this.tile, cluster.getX(), cluster.getY(), readClassifier.numNs, readClassifier.numQGtTwo, readClassifier.failClass));
                    }
                    switch (readClassifier.failClass) {
                        case EMPTY: {
                            ++this.summaryMetric.PF_FAIL_EMPTY;
                            continue block11;
                        }
                        case MISALIGNED: {
                            ++this.summaryMetric.PF_FAIL_MISALIGNED;
                            continue block11;
                        }
                        case POLYCLONAL: {
                            ++this.summaryMetric.PF_FAIL_POLYCLONAL;
                            continue block11;
                        }
                        case UNKNOWN: {
                            ++this.summaryMetric.PF_FAIL_UNKNOWN;
                            continue block11;
                        }
                    }
                    LOG.error("Got unexpected fail Reason");
                }
            }
            catch (Exception e2) {
                LOG.error(e2, "Error processing tile ", this.tile);
                this.exception = e2;
            }
            finally {
                this.provider.close();
            }
        }
    }
}

