/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.AbstractPathElement;
import org.jgrapht.alg.AbstractPathElementList;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.alg.RankingPathElement;
import org.jgrapht.graph.DirectedMaskSubgraph;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.graph.UndirectedMaskSubgraph;

final class RankingPathElementList<V, E>
extends AbstractPathElementList<V, E, RankingPathElement<V, E>> {
    private V guardVertexToNotDisconnect = null;
    private Map<RankingPathElement<V, E>, Boolean> path2disconnect = new HashMap<RankingPathElement<V, E>, Boolean>();

    RankingPathElementList(Graph<V, E> graph, int n2, RankingPathElement<V, E> rankingPathElement) {
        super(graph, n2, rankingPathElement);
    }

    RankingPathElementList(Graph<V, E> graph, int n2, RankingPathElementList<V, E> rankingPathElementList, E e2) {
        this(graph, n2, rankingPathElementList, e2, null);
        assert (!this.pathElements.isEmpty());
    }

    RankingPathElementList(Graph<V, E> graph, int n2, RankingPathElementList<V, E> rankingPathElementList, E e2, V v2) {
        super(graph, n2, rankingPathElementList, e2);
        this.guardVertexToNotDisconnect = v2;
        for (int i2 = 0; i2 < rankingPathElementList.size(); ++i2) {
            RankingPathElement rankingPathElement = (RankingPathElement)rankingPathElementList.get(i2);
            if (this.isNotValidPath(rankingPathElement, e2) || this.size() >= this.maxSize) continue;
            double d2 = this.calculatePathWeight(rankingPathElement, e2);
            RankingPathElement rankingPathElement2 = new RankingPathElement(this.graph, rankingPathElement, e2, d2);
            this.pathElements.add(rankingPathElement2);
        }
    }

    RankingPathElementList(Graph<V, E> graph, int n2, V v2) {
        super(graph, n2, v2);
    }

    public boolean addPathElements(RankingPathElementList<V, E> rankingPathElementList, E e2) {
        assert (this.vertex.equals(Graphs.getOppositeVertex(this.graph, e2, rankingPathElementList.getVertex())));
        boolean bl = false;
        int n2 = 0;
        for (int i2 = 0; i2 < rankingPathElementList.size(); ++i2) {
            RankingPathElement rankingPathElement = (RankingPathElement)rankingPathElementList.get(i2);
            if (this.isNotValidPath(rankingPathElement, e2)) continue;
            double d2 = this.calculatePathWeight(rankingPathElement, e2);
            RankingPathElement rankingPathElement2 = new RankingPathElement(this.graph, rankingPathElement, e2, d2);
            RankingPathElement rankingPathElement3 = null;
            while (n2 < this.size()) {
                rankingPathElement3 = (RankingPathElement)this.get(n2);
                if (d2 < rankingPathElement3.getWeight()) {
                    this.pathElements.add(n2, rankingPathElement2);
                    bl = true;
                    if (this.size() <= this.maxSize) break;
                    this.pathElements.remove(this.maxSize);
                    break;
                }
                if (d2 == rankingPathElement3.getWeight()) {
                    this.pathElements.add(n2 + 1, rankingPathElement2);
                    bl = true;
                    if (this.size() <= this.maxSize) break;
                    this.pathElements.remove(this.maxSize);
                    break;
                }
                ++n2;
            }
            if (!(d2 > rankingPathElement3.getWeight())) continue;
            if (this.size() >= this.maxSize) break;
            this.pathElements.add(rankingPathElement2);
            bl = true;
        }
        return bl;
    }

    List<RankingPathElement<V, E>> getPathElements() {
        return this.pathElements;
    }

    private double calculatePathWeight(RankingPathElement<V, E> rankingPathElement, E e2) {
        double d2 = this.graph.getEdgeWeight(e2);
        if (rankingPathElement.getPrevEdge() != null) {
            d2 += rankingPathElement.getWeight();
        }
        return d2;
    }

    private boolean isGuardVertexDisconnected(RankingPathElement<V, E> rankingPathElement) {
        ConnectivityInspector<Object, E> connectivityInspector;
        PathMask<V, E> pathMask;
        if (this.guardVertexToNotDisconnect == null) {
            return false;
        }
        if (this.path2disconnect.containsKey(rankingPathElement)) {
            return this.path2disconnect.get(rankingPathElement);
        }
        if (this.graph instanceof DirectedGraph) {
            pathMask = new PathMask<V, E>(rankingPathElement);
            DirectedMaskSubgraph<V, E> directedMaskSubgraph = new DirectedMaskSubgraph<V, E>((DirectedGraph)this.graph, pathMask);
            connectivityInspector = new ConnectivityInspector<Object, E>(directedMaskSubgraph);
        } else {
            pathMask = new PathMask<V, E>(rankingPathElement);
            UndirectedMaskSubgraph<V, E> undirectedMaskSubgraph = new UndirectedMaskSubgraph<V, E>((UndirectedGraph)this.graph, pathMask);
            connectivityInspector = new ConnectivityInspector<V, E>(undirectedMaskSubgraph);
        }
        if (pathMask.isVertexMasked(this.guardVertexToNotDisconnect)) {
            this.path2disconnect.put(rankingPathElement, true);
            return true;
        }
        if (!connectivityInspector.pathExists(this.vertex, this.guardVertexToNotDisconnect)) {
            this.path2disconnect.put(rankingPathElement, true);
            return true;
        }
        this.path2disconnect.put(rankingPathElement, false);
        return false;
    }

    private boolean isNotValidPath(RankingPathElement<V, E> rankingPathElement, E e2) {
        return !this.isSimplePath(rankingPathElement, e2) || this.isGuardVertexDisconnected(rankingPathElement);
    }

    private boolean isSimplePath(RankingPathElement<V, E> rankingPathElement, E e2) {
        AbstractPathElement abstractPathElement = rankingPathElement;
        while (abstractPathElement.getPrevEdge() != null) {
            if (abstractPathElement.getVertex() == this.vertex) {
                return false;
            }
            abstractPathElement = abstractPathElement.getPrevPathElement();
        }
        return true;
    }

    private static class PathMask<V, E>
    implements MaskFunctor<V, E> {
        private Set<E> maskedEdges = new HashSet();
        private Set<V> maskedVertices = new HashSet<V>();

        PathMask(RankingPathElement<V, E> abstractPathElement) {
            while (abstractPathElement.getPrevEdge() != null) {
                this.maskedEdges.add(abstractPathElement.getPrevEdge());
                this.maskedVertices.add(abstractPathElement.getVertex());
                abstractPathElement = abstractPathElement.getPrevPathElement();
            }
            this.maskedVertices.add(abstractPathElement.getVertex());
        }

        @Override
        public boolean isEdgeMasked(E e2) {
            return this.maskedEdges.contains(e2);
        }

        @Override
        public boolean isVertexMasked(V v2) {
            return this.maskedVertices.contains(v2);
        }
    }
}

