/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.help;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.broadinstitute.gatk.utils.help.ForumDiscussion;
import org.broadinstitute.gatk.utils.help.GATKDocWorkUnit;

public class ForumAPIUtils {
    private static final String ACCESS_TOKEN = "access_token=";

    public static List<String> getPostedTools(String forumKey) {
        ForumDiscussion[] discussions;
        Gson gson = new Gson();
        ArrayList<String> output = new ArrayList<String>();
        String text = ForumAPIUtils.httpGet("https://gatkforums.broadinstitute.org/api/v1/categories.json?CategoryIdentifier=tool-bulletin&page=1-100000&access_token=" + forumKey);
        APIQuery details = gson.fromJson(text, APIQuery.class);
        for (ForumDiscussion post : discussions = details.Discussions) {
            output.add(post.Name);
        }
        return output;
    }

    private static String httpGet(String urlStr) {
        String output = "";
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpGet getRequest = new HttpGet(urlStr);
            getRequest.addHeader("accept", "application/json");
            HttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            output = IOUtils.toString(response.getEntity().getContent());
            httpClient.getConnectionManager().shutdown();
        }
        catch (ClientProtocolException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return output;
    }

    private static String httpPost(String data, String URL2) {
        try {
            String line;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpPost postRequest = new HttpPost(URL2);
            StringEntity input = new StringEntity(data);
            input.setContentType("application/json");
            postRequest.setEntity((HttpEntity)input);
            HttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String output = "";
            System.out.println("Output from Server .... \n");
            while ((line = br.readLine()) != null) {
                output = output + line + '\n';
                System.out.println(line);
            }
            br.close();
            httpClient.getConnectionManager().shutdown();
            return output;
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return null;
    }

    public static void postToForum(GATKDocWorkUnit tool, String forumKey) {
        ForumDiscussion post = new ForumDiscussion(tool);
        Gson gson = new Gson();
        String data = gson.toJson(post.getPostData());
        ForumAPIUtils.httpPost(data, "https://gatkforums.broadinstitute.org/api/v1/post/discussion.json?access_token=" + forumKey);
    }

    class APIQuery {
        ForumDiscussion[] Discussions;
    }
}

