/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BufferedByteWriter {
    ByteArrayOutputStream buffer;

    public BufferedByteWriter() {
        this(8192);
    }

    public BufferedByteWriter(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buffer = new ByteArrayOutputStream(size);
    }

    public byte[] getBytes() {
        return this.buffer.toByteArray();
    }

    public int bytesWritten() {
        return this.buffer.size();
    }

    public void put(int b2) throws IOException {
        this.buffer.write(b2);
    }

    public void put(byte[] b2) throws IOException {
        this.buffer.write(b2);
    }

    public void put(byte[] b2, int off, int len) throws IOException {
        this.buffer.write(b2, off, len);
    }

    public void putInt(int v2) throws IOException {
        this.buffer.write(v2 >>> 0 & 0xFF);
        this.buffer.write(v2 >>> 8 & 0xFF);
        this.buffer.write(v2 >>> 16 & 0xFF);
        this.buffer.write(v2 >>> 24 & 0xFF);
    }

    public void putShort(short v2) throws IOException {
        this.buffer.write(v2 >>> 0 & 0xFF);
        this.buffer.write(v2 >>> 8 & 0xFF);
    }

    public void putFloat(float f2) throws IOException {
        int v2 = Float.floatToIntBits(f2);
        this.putInt(v2);
    }

    public void putDouble(Double f2) throws IOException {
        long v2 = Double.doubleToLongBits(f2);
        this.putLong(v2);
    }

    public void putLong(long v2) throws IOException {
        this.buffer.write((byte)(v2 >>> 0));
        this.buffer.write((byte)(v2 >>> 8));
        this.buffer.write((byte)(v2 >>> 16));
        this.buffer.write((byte)(v2 >>> 24));
        this.buffer.write((byte)(v2 >>> 32));
        this.buffer.write((byte)(v2 >>> 40));
        this.buffer.write((byte)(v2 >>> 48));
        this.buffer.write((byte)(v2 >>> 56));
    }

    public void putNullTerminatedString(String s2) throws IOException {
        this.buffer.write(s2.getBytes());
        this.buffer.write(0);
    }
}

