/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frequency
implements Serializable {
    private static final long serialVersionUID = -3845586908418844111L;
    private final TreeMap<Comparable<?>, Long> freqTable;

    public Frequency() {
        this.freqTable = new TreeMap();
    }

    public Frequency(Comparator<?> comparator) {
        this.freqTable = new TreeMap(comparator);
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        StringBuilder outBuffer = new StringBuilder();
        outBuffer.append("Value \t Freq. \t Pct. \t Cum Pct. \n");
        for (Comparable<?> value : this.freqTable.keySet()) {
            outBuffer.append(value);
            outBuffer.append('\t');
            outBuffer.append(this.getCount(value));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getPct(value)));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getCumPct(value)));
            outBuffer.append('\n');
        }
        return outBuffer.toString();
    }

    @Deprecated
    public void addValue(Object v2) {
        if (!(v2 instanceof Comparable)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.CLASS_DOESNT_IMPLEMENT_COMPARABLE, v2.getClass().getName());
        }
        this.addValue((Comparable)v2);
    }

    public void addValue(Comparable<?> v2) {
        Long obj = v2;
        if (v2 instanceof Integer) {
            obj = ((Integer)((Object)v2)).longValue();
        }
        try {
            Long count = this.freqTable.get(obj);
            if (count == null) {
                this.freqTable.put(obj, 1L);
            } else {
                this.freqTable.put(obj, count + 1L);
            }
        }
        catch (ClassCastException ex) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSTANCES_NOT_COMPARABLE_TO_EXISTING_VALUES, v2.getClass().getName());
        }
    }

    public void addValue(int v2) {
        this.addValue(Long.valueOf(v2));
    }

    @Deprecated
    public void addValue(Integer v2) {
        this.addValue(Long.valueOf(v2.longValue()));
    }

    public void addValue(long v2) {
        this.addValue(Long.valueOf(v2));
    }

    public void addValue(char v2) {
        this.addValue(Character.valueOf(v2));
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator<Comparable<?>> valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public long getSumFreq() {
        long result = 0L;
        Iterator<Long> iterator = this.freqTable.values().iterator();
        while (iterator.hasNext()) {
            result += iterator.next().longValue();
        }
        return result;
    }

    @Deprecated
    public long getCount(Object v2) {
        return this.getCount((Comparable)v2);
    }

    public long getCount(Comparable<?> v2) {
        if (v2 instanceof Integer) {
            return this.getCount(((Integer)v2).longValue());
        }
        long result = 0L;
        try {
            Long count = this.freqTable.get(v2);
            if (count != null) {
                result = count;
            }
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        return result;
    }

    public long getCount(int v2) {
        return this.getCount(Long.valueOf(v2));
    }

    public long getCount(long v2) {
        return this.getCount(Long.valueOf(v2));
    }

    public long getCount(char v2) {
        return this.getCount(Character.valueOf(v2));
    }

    public int getUniqueCount() {
        return this.freqTable.keySet().size();
    }

    @Deprecated
    public double getPct(Object v2) {
        return this.getPct((Comparable)v2);
    }

    public double getPct(Comparable<?> v2) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(v2) / (double)sumFreq;
    }

    public double getPct(int v2) {
        return this.getPct(Long.valueOf(v2));
    }

    public double getPct(long v2) {
        return this.getPct(Long.valueOf(v2));
    }

    public double getPct(char v2) {
        return this.getPct(Character.valueOf(v2));
    }

    @Deprecated
    public long getCumFreq(Object v2) {
        return this.getCumFreq((Comparable)v2);
    }

    public long getCumFreq(Comparable<?> v2) {
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        if (v2 instanceof Integer) {
            return this.getCumFreq(((Integer)v2).longValue());
        }
        Comparator<Comparable<?>> c2 = this.freqTable.comparator();
        if (c2 == null) {
            c2 = new NaturalComparator();
        }
        long result = 0L;
        try {
            Long value = this.freqTable.get(v2);
            if (value != null) {
                result = value;
            }
        }
        catch (ClassCastException ex) {
            return result;
        }
        if (c2.compare(v2, this.freqTable.firstKey()) < 0) {
            return 0L;
        }
        if (c2.compare(v2, this.freqTable.lastKey()) >= 0) {
            return this.getSumFreq();
        }
        Iterator<Comparable<?>> values = this.valuesIterator();
        while (values.hasNext()) {
            Comparable<?> nextValue = values.next();
            if (c2.compare(v2, nextValue) > 0) {
                result += this.getCount(nextValue);
                continue;
            }
            return result;
        }
        return result;
    }

    public long getCumFreq(int v2) {
        return this.getCumFreq(Long.valueOf(v2));
    }

    public long getCumFreq(long v2) {
        return this.getCumFreq(Long.valueOf(v2));
    }

    public long getCumFreq(char v2) {
        return this.getCumFreq(Character.valueOf(v2));
    }

    @Deprecated
    public double getCumPct(Object v2) {
        return this.getCumPct((Comparable)v2);
    }

    public double getCumPct(Comparable<?> v2) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(v2) / (double)sumFreq;
    }

    public double getCumPct(int v2) {
        return this.getCumPct(Long.valueOf(v2));
    }

    public double getCumPct(long v2) {
        return this.getCumPct(Long.valueOf(v2));
    }

    public double getCumPct(char v2) {
        return this.getCumPct(Character.valueOf(v2));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.freqTable == null ? 0 : this.freqTable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency other = (Frequency)obj;
        return !(this.freqTable == null ? other.freqTable != null : !this.freqTable.equals(other.freqTable));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NaturalComparator<T extends Comparable<T>>
    implements Comparator<Comparable<T>>,
    Serializable {
        private static final long serialVersionUID = -3852193713161395148L;

        private NaturalComparator() {
        }

        @Override
        public int compare(Comparable<T> o1, Comparable<T> o2) {
            return o1.compareTo(o2);
        }
    }
}

