/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.MatrixIndexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFieldVector<T extends FieldElement<T>>
implements FieldVector<T>,
Serializable {
    private static final long serialVersionUID = 7648186910365927050L;
    protected T[] data;
    private final Field<T> field;

    public ArrayFieldVector(Field<T> field) {
        this(field, 0);
    }

    public ArrayFieldVector(Field<T> field, int size) {
        this.field = field;
        this.data = this.buildArray(size);
        Arrays.fill(this.data, field.getZero());
    }

    public ArrayFieldVector(int size, T preset) {
        this(preset.getField(), size);
        Arrays.fill(this.data, preset);
    }

    public ArrayFieldVector(T[] d2) throws IllegalArgumentException {
        try {
            this.field = d2[0].getField();
            this.data = (FieldElement[])d2.clone();
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
    }

    public ArrayFieldVector(Field<T> field, T[] d2) {
        this.field = field;
        this.data = (FieldElement[])d2.clone();
    }

    public ArrayFieldVector(T[] d2, boolean copyArray) throws NullPointerException, IllegalArgumentException {
        if (d2.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        this.field = d2[0].getField();
        this.data = copyArray ? (FieldElement[])d2.clone() : d2;
    }

    public ArrayFieldVector(Field<T> field, T[] d2, boolean copyArray) {
        this.field = field;
        this.data = copyArray ? (FieldElement[])d2.clone() : d2;
    }

    public ArrayFieldVector(T[] d2, int pos, int size) {
        if (d2.length < pos + size) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POSITION_SIZE_MISMATCH_INPUT_ARRAY, pos, size, d2.length);
        }
        this.field = d2[0].getField();
        this.data = this.buildArray(size);
        System.arraycopy(d2, pos, this.data, 0, size);
    }

    public ArrayFieldVector(FieldVector<T> v2) {
        this.field = v2.getField();
        this.data = this.buildArray(v2.getDimension());
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = v2.getEntry(i2);
        }
    }

    public ArrayFieldVector(ArrayFieldVector<T> v2) {
        this.field = v2.getField();
        this.data = (FieldElement[])v2.data.clone();
    }

    public ArrayFieldVector(ArrayFieldVector<T> v2, boolean deep) {
        this.field = v2.getField();
        this.data = deep ? (FieldElement[])v2.data.clone() : v2.data;
    }

    public ArrayFieldVector(ArrayFieldVector<T> v1, ArrayFieldVector<T> v2) {
        this.field = v1.getField();
        this.data = this.buildArray(v1.data.length + v2.data.length);
        System.arraycopy(v1.data, 0, this.data, 0, v1.data.length);
        System.arraycopy(v2.data, 0, this.data, v1.data.length, v2.data.length);
    }

    public ArrayFieldVector(ArrayFieldVector<T> v1, T[] v2) {
        this.field = v1.getField();
        this.data = this.buildArray(v1.data.length + v2.length);
        System.arraycopy(v1.data, 0, this.data, 0, v1.data.length);
        System.arraycopy(v2, 0, this.data, v1.data.length, v2.length);
    }

    public ArrayFieldVector(T[] v1, ArrayFieldVector<T> v2) {
        this.field = v2.getField();
        this.data = this.buildArray(v1.length + v2.data.length);
        System.arraycopy(v1, 0, this.data, 0, v1.length);
        System.arraycopy(v2.data, 0, this.data, v1.length, v2.data.length);
    }

    public ArrayFieldVector(T[] v1, T[] v2) {
        try {
            this.data = this.buildArray(v1.length + v2.length);
            System.arraycopy(v1, 0, this.data, 0, v1.length);
            System.arraycopy(v2, 0, this.data, v1.length, v2.length);
            this.field = this.data[0].getField();
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
    }

    public ArrayFieldVector(Field<T> field, T[] v1, T[] v2) {
        if (v1.length + v2.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        this.data = this.buildArray(v1.length + v2.length);
        System.arraycopy(v1, 0, this.data, 0, v1.length);
        System.arraycopy(v2, 0, this.data, v1.length, v2.length);
        this.field = this.data[0].getField();
    }

    private T[] buildArray(int length) {
        return (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), length);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldVector<T> copy() {
        return new ArrayFieldVector<T>(this, true);
    }

    @Override
    public FieldVector<T> add(FieldVector<T> v2) throws IllegalArgumentException {
        try {
            return this.add((ArrayFieldVector)v2);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v2);
            FieldElement[] out = this.buildArray(this.data.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                out[i2] = (FieldElement)this.data[i2].add(v2.getEntry(i2));
            }
            return new ArrayFieldVector(out);
        }
    }

    @Override
    public FieldVector<T> add(T[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        FieldElement[] out = this.buildArray(this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)this.data[i2].add(v2[i2]);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public ArrayFieldVector<T> add(ArrayFieldVector<T> v2) throws IllegalArgumentException {
        return (ArrayFieldVector)this.add((FieldElement[])v2.data);
    }

    @Override
    public FieldVector<T> subtract(FieldVector<T> v2) throws IllegalArgumentException {
        try {
            return this.subtract((ArrayFieldVector)v2);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v2);
            FieldElement[] out = this.buildArray(this.data.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                out[i2] = (FieldElement)this.data[i2].subtract(v2.getEntry(i2));
            }
            return new ArrayFieldVector(out);
        }
    }

    @Override
    public FieldVector<T> subtract(T[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        FieldElement[] out = this.buildArray(this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)this.data[i2].subtract(v2[i2]);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public ArrayFieldVector<T> subtract(ArrayFieldVector<T> v2) throws IllegalArgumentException {
        return (ArrayFieldVector)this.subtract((FieldElement[])v2.data);
    }

    @Override
    public FieldVector<T> mapAdd(T d2) {
        FieldElement[] out = this.buildArray(this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)this.data[i2].add(d2);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapAddToSelf(T d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)this.data[i2].add(d2);
        }
        return this;
    }

    @Override
    public FieldVector<T> mapSubtract(T d2) {
        FieldElement[] out = this.buildArray(this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)this.data[i2].subtract(d2);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapSubtractToSelf(T d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)this.data[i2].subtract(d2);
        }
        return this;
    }

    @Override
    public FieldVector<T> mapMultiply(T d2) {
        FieldElement[] out = this.buildArray(this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)this.data[i2].multiply(d2);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapMultiplyToSelf(T d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)this.data[i2].multiply(d2);
        }
        return this;
    }

    @Override
    public FieldVector<T> mapDivide(T d2) {
        FieldElement[] out = this.buildArray(this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)this.data[i2].divide(d2);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapDivideToSelf(T d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)this.data[i2].divide(d2);
        }
        return this;
    }

    @Override
    public FieldVector<T> mapInv() {
        FieldElement[] out = this.buildArray(this.data.length);
        FieldElement one = (FieldElement)this.field.getOne();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)one.divide(this.data[i2]);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapInvToSelf() {
        FieldElement one = (FieldElement)this.field.getOne();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)one.divide(this.data[i2]);
        }
        return this;
    }

    @Override
    public FieldVector<T> ebeMultiply(FieldVector<T> v2) throws IllegalArgumentException {
        try {
            return this.ebeMultiply((ArrayFieldVector)v2);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v2);
            FieldElement[] out = this.buildArray(this.data.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                out[i2] = (FieldElement)this.data[i2].multiply(v2.getEntry(i2));
            }
            return new ArrayFieldVector(out);
        }
    }

    @Override
    public FieldVector<T> ebeMultiply(T[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        FieldElement[] out = this.buildArray(this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)this.data[i2].multiply(v2[i2]);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public ArrayFieldVector<T> ebeMultiply(ArrayFieldVector<T> v2) throws IllegalArgumentException {
        return (ArrayFieldVector)this.ebeMultiply((FieldElement[])v2.data);
    }

    @Override
    public FieldVector<T> ebeDivide(FieldVector<T> v2) throws IllegalArgumentException {
        try {
            return this.ebeDivide((ArrayFieldVector)v2);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v2);
            FieldElement[] out = this.buildArray(this.data.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                out[i2] = (FieldElement)this.data[i2].divide(v2.getEntry(i2));
            }
            return new ArrayFieldVector(out);
        }
    }

    @Override
    public FieldVector<T> ebeDivide(T[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        FieldElement[] out = this.buildArray(this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            out[i2] = (FieldElement)this.data[i2].divide(v2[i2]);
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public ArrayFieldVector<T> ebeDivide(ArrayFieldVector<T> v2) throws IllegalArgumentException {
        return (ArrayFieldVector)this.ebeDivide((FieldElement[])v2.data);
    }

    @Override
    public T[] getData() {
        return (FieldElement[])this.data.clone();
    }

    public T[] getDataRef() {
        return this.data;
    }

    @Override
    public T dotProduct(FieldVector<T> v2) throws IllegalArgumentException {
        try {
            return this.dotProduct((ArrayFieldVector)v2);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v2);
            FieldElement dot = (FieldElement)this.field.getZero();
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                dot = (FieldElement)dot.add(this.data[i2].multiply(v2.getEntry(i2)));
            }
            return (T)dot;
        }
    }

    @Override
    public T dotProduct(T[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        FieldElement dot = (FieldElement)this.field.getZero();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            dot = (FieldElement)dot.add(this.data[i2].multiply(v2[i2]));
        }
        return (T)dot;
    }

    @Override
    public T dotProduct(ArrayFieldVector<T> v2) throws IllegalArgumentException {
        return (T)this.dotProduct((FieldElement[])v2.data);
    }

    @Override
    public FieldVector<T> projection(FieldVector<T> v2) {
        return v2.mapMultiply((FieldElement)this.dotProduct(v2).divide(v2.dotProduct(v2)));
    }

    @Override
    public FieldVector<T> projection(T[] v2) {
        return this.projection(new ArrayFieldVector(v2, false));
    }

    @Override
    public ArrayFieldVector<T> projection(ArrayFieldVector<T> v2) {
        return (ArrayFieldVector)v2.mapMultiply((FieldElement)this.dotProduct(v2).divide(v2.dotProduct(v2)));
    }

    @Override
    public FieldMatrix<T> outerProduct(FieldVector<T> v2) throws IllegalArgumentException {
        try {
            return this.outerProduct((ArrayFieldVector)v2);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v2);
            int m2 = this.data.length;
            Array2DRowFieldMatrix<FieldElement> out = new Array2DRowFieldMatrix<FieldElement>(this.field, m2, m2);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                for (int j2 = 0; j2 < this.data.length; ++j2) {
                    out.setEntry(i2, j2, (FieldElement)this.data[i2].multiply(v2.getEntry(j2)));
                }
            }
            return out;
        }
    }

    @Override
    public FieldMatrix<T> outerProduct(ArrayFieldVector<T> v2) throws IllegalArgumentException {
        return this.outerProduct((FieldElement[])v2.data);
    }

    @Override
    public FieldMatrix<T> outerProduct(T[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        int m2 = this.data.length;
        Array2DRowFieldMatrix<FieldElement> out = new Array2DRowFieldMatrix<FieldElement>(this.field, m2, m2);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (int j2 = 0; j2 < this.data.length; ++j2) {
                out.setEntry(i2, j2, (FieldElement)this.data[i2].multiply(v2[j2]));
            }
        }
        return out;
    }

    @Override
    public T getEntry(int index) throws MatrixIndexException {
        return this.data[index];
    }

    @Override
    public int getDimension() {
        return this.data.length;
    }

    @Override
    public FieldVector<T> append(FieldVector<T> v2) {
        try {
            return this.append((ArrayFieldVector)v2);
        }
        catch (ClassCastException cce) {
            return new ArrayFieldVector<T>(this, new ArrayFieldVector<T>(v2));
        }
    }

    @Override
    public ArrayFieldVector<T> append(ArrayFieldVector<T> v2) {
        return new ArrayFieldVector<T>(this, v2);
    }

    @Override
    public FieldVector<T> append(T in) {
        FieldElement[] out = this.buildArray(this.data.length + 1);
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        out[this.data.length] = in;
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> append(T[] in) {
        return new ArrayFieldVector(this, in);
    }

    @Override
    public FieldVector<T> getSubVector(int index, int n2) {
        ArrayFieldVector<T> out = new ArrayFieldVector<T>(this.field, n2);
        try {
            System.arraycopy(this.data, index, out.data, 0, n2);
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
            this.checkIndex(index + n2 - 1);
        }
        return out;
    }

    @Override
    public void setEntry(int index, T value) {
        try {
            this.data[index] = value;
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
        }
    }

    @Override
    public void setSubVector(int index, FieldVector<T> v2) {
        try {
            try {
                this.set(index, (ArrayFieldVector)v2);
            }
            catch (ClassCastException cce) {
                for (int i2 = index; i2 < index + v2.getDimension(); ++i2) {
                    this.data[i2] = v2.getEntry(i2 - index);
                }
            }
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
            this.checkIndex(index + v2.getDimension() - 1);
        }
    }

    @Override
    public void setSubVector(int index, T[] v2) {
        try {
            System.arraycopy(v2, 0, this.data, index, v2.length);
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
            this.checkIndex(index + v2.length - 1);
        }
    }

    public void set(int index, ArrayFieldVector<T> v2) throws MatrixIndexException {
        this.setSubVector(index, (FieldElement[])v2.data);
    }

    @Override
    public void set(T value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public T[] toArray() {
        return (FieldElement[])this.data.clone();
    }

    protected void checkVectorDimensions(FieldVector<T> v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.getDimension());
    }

    protected void checkVectorDimensions(int n2) throws IllegalArgumentException {
        if (this.data.length != n2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, this.data.length, n2);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        try {
            FieldVector rhs = (FieldVector)other;
            if (this.data.length != rhs.getDimension()) {
                return false;
            }
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (this.data[i2].equals(rhs.getEntry(i2))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public int hashCode() {
        int h2 = 3542;
        for (T a2 : this.data) {
            h2 ^= a2.hashCode();
        }
        return h2;
    }

    private void checkIndex(int index) throws MatrixIndexException {
        if (index < 0 || index >= this.getDimension()) {
            throw new MatrixIndexException(LocalizedFormats.INDEX_OUT_OF_RANGE, index, 0, this.getDimension() - 1);
        }
    }
}

