/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.parser;

public class StringParser {
    private static final int UCHAR_LEN = 4;
    private static final int SHIFT = 12;
    private static final int BASE10 = 10;
    private static final char LAST_ASCII = '\u007f';
    private static final char FIRST_ASCII = ' ';

    public static String buildString(CharSequence str, boolean eatsep) {
        StringBuilder strb = new StringBuilder(str.length());
        char sep = eatsep ? str.charAt(0) : (char)'\u0000';
        int end = str.length() - (eatsep ? 1 : 0);
        int begin = eatsep ? 1 : 0;
        StringParser.read(strb, str, begin, end, sep);
        return strb.toString();
    }

    public static int readString(StringBuilder strb, CharSequence str, int index, char sep) {
        return StringParser.read(strb, str, index, str.length(), sep);
    }

    private static int read(StringBuilder strb, CharSequence str, int begin, int end, char sep) {
        int index;
        boolean escape = false;
        for (index = begin; index < end; ++index) {
            char c2 = str.charAt(index);
            if (escape) {
                if (c2 == 'u' && index + 4 < end && StringParser.readUnicodeChar(strb, str, index + 1) > 0) {
                    index += 4;
                } else {
                    boolean notSeparator;
                    boolean bl = sep == '\u0000' ? c2 != '\'' && c2 != '\"' : (notSeparator = c2 != sep);
                    if (notSeparator && c2 != '\\') {
                        strb.append('\\');
                    }
                    strb.append(c2);
                }
                escape = false;
                continue;
            }
            if (c2 == '\\') {
                escape = true;
                continue;
            }
            strb.append(c2);
            if (c2 == sep) break;
        }
        return index;
    }

    private static int readUnicodeChar(StringBuilder strb, CharSequence str, int begin) {
        char xc = '\u0000';
        int bits = 12;
        int value = 0;
        for (int offset = 0; offset < 4; ++offset) {
            char c2 = str.charAt(begin + offset);
            if (c2 >= '0' && c2 <= '9') {
                value = c2 - 48;
            } else if (c2 >= 'a' && c2 <= 'h') {
                value = c2 - 97 + 10;
            } else if (c2 >= 'A' && c2 <= 'H') {
                value = c2 - 65 + 10;
            } else {
                return 0;
            }
            xc = (char)(xc | value << bits);
            bits -= 4;
        }
        strb.append(xc);
        return 4;
    }

    public static String escapeString(String str, char delim) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder strb = new StringBuilder(length + 2);
        strb.append(delim);
        block11: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    strb.append("\\b");
                    continue block11;
                }
                case '\t': {
                    strb.append("\\t");
                    continue block11;
                }
                case '\n': {
                    strb.append("\\n");
                    continue block11;
                }
                case '\f': {
                    strb.append("\\f");
                    continue block11;
                }
                case '\r': {
                    strb.append("\\r");
                    continue block11;
                }
                case '\"': {
                    strb.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    strb.append("\\'");
                    continue block11;
                }
                case '\\': {
                    strb.append("\\\\");
                    continue block11;
                }
                default: {
                    if (c2 >= ' ' && c2 <= '\u007f') {
                        strb.append(c2);
                        continue block11;
                    }
                    strb.append('\\');
                    strb.append('u');
                    String hex = Integer.toHexString(c2);
                    for (int h2 = hex.length(); h2 < 4; ++h2) {
                        strb.append('0');
                    }
                    strb.append(hex);
                }
            }
        }
        strb.append(delim);
        return strb.toString();
    }
}

