/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class SortingLongCollection {
    public static final int SIZEOF = 8;
    public static final int MAX_ITEMS_IN_RAM = (int)Math.floor(2.68167019545E8);
    private final File[] tmpDir;
    private final int maxValuesInRam;
    private int numValuesInRam = 0;
    private long[] ramValues;
    private boolean doneAdding = false;
    private boolean cleanedUp = false;
    private final List<File> files = new ArrayList<File>();
    private int iterationIndex = 0;
    private PriorityQueue<PeekFileValueIterator> priorityQueue;

    public SortingLongCollection(int maxValuesInRam, File ... tmpDir) {
        if (maxValuesInRam <= 0) {
            throw new IllegalArgumentException("maxValuesInRam must be > 0");
        }
        this.tmpDir = tmpDir;
        this.maxValuesInRam = Math.min(maxValuesInRam, MAX_ITEMS_IN_RAM);
        this.ramValues = new long[maxValuesInRam];
    }

    public void add(long value) {
        if (this.doneAdding) {
            throw new IllegalStateException("Cannot add after calling doneAddingStartIteration()");
        }
        if (this.numValuesInRam == this.maxValuesInRam) {
            this.spillToDisk();
        }
        this.ramValues[this.numValuesInRam++] = value;
    }

    public void doneAddingStartIteration() {
        if (this.cleanedUp || this.doneAdding) {
            throw new IllegalStateException("Cannot call doneAddingStartIteration() after cleanup() was called.");
        }
        this.doneAdding = true;
        if (this.files.isEmpty()) {
            Arrays.sort(this.ramValues, 0, this.numValuesInRam);
            return;
        }
        if (this.numValuesInRam > 0) {
            this.spillToDisk();
        }
        this.priorityQueue = new PriorityQueue<PeekFileValueIterator>(this.files.size(), new PeekFileValueIteratorComparator());
        for (File f2 : this.files) {
            FileValueIterator it = new FileValueIterator(f2);
            if (!it.hasNext()) continue;
            this.priorityQueue.offer(new PeekFileValueIterator(it));
        }
        this.ramValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spillToDisk() {
        try {
            Arrays.sort(this.ramValues, 0, this.numValuesInRam);
            File f2 = IOUtil.newTempFile("sortingcollection.", ".tmp", this.tmpDir, 0x140000000L);
            FilterOutputStream os = null;
            try {
                long numBytes = this.numValuesInRam * 8;
                os = new DataOutputStream(IOUtil.maybeBufferOutputStream(new FileOutputStream(f2)));
                f2.deleteOnExit();
                for (int i2 = 0; i2 < this.numValuesInRam; ++i2) {
                    ((DataOutputStream)os).writeLong(this.ramValues[i2]);
                }
                ((DataOutputStream)os).flush();
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
            this.numValuesInRam = 0;
            this.files.add(f2);
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    public void cleanup() {
        this.doneAdding = true;
        this.cleanedUp = true;
        this.ramValues = null;
        IOUtil.deleteFiles(this.files);
    }

    public boolean hasNext() {
        if (!this.doneAdding || this.cleanedUp) {
            throw new IllegalStateException();
        }
        if (this.ramValues != null) {
            return this.iterationIndex < this.numValuesInRam;
        }
        return !this.priorityQueue.isEmpty();
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.ramValues != null) {
            return this.ramValues[this.iterationIndex++];
        }
        PeekFileValueIterator fileIterator = this.priorityQueue.poll();
        long ret = fileIterator.next();
        if (fileIterator.hasNext()) {
            this.priorityQueue.offer(fileIterator);
        } else {
            fileIterator.close();
        }
        return ret;
    }

    private static class PeekFileValueIteratorComparator
    implements Comparator<PeekFileValueIterator> {
        private PeekFileValueIteratorComparator() {
        }

        @Override
        public int compare(PeekFileValueIterator it1, PeekFileValueIterator it2) {
            if (it1.peek() < it2.peek()) {
                return -1;
            }
            if (it1.peek() == it2.peek()) {
                return 0;
            }
            return 1;
        }
    }

    private static class PeekFileValueIterator {
        private FileValueIterator underlyingIterator;
        private long peekValue;
        private boolean hasPeekedValue = false;

        PeekFileValueIterator(FileValueIterator underlyingIterator) {
            this.underlyingIterator = underlyingIterator;
        }

        boolean hasNext() {
            return this.hasPeekedValue || this.underlyingIterator.hasNext();
        }

        long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.hasPeekedValue) {
                this.hasPeekedValue = false;
                return this.peekValue;
            }
            return this.underlyingIterator.next();
        }

        long peek() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.hasPeekedValue) {
                this.peekValue = this.underlyingIterator.next();
                this.hasPeekedValue = true;
            }
            return this.peekValue;
        }

        void close() {
            this.underlyingIterator.close();
            this.hasPeekedValue = false;
            this.underlyingIterator = null;
        }
    }

    private static class FileValueIterator {
        private final File file;
        private final DataInputStream is;
        private long currentRecord = 0L;
        private boolean isCurrentRecord = true;

        FileValueIterator(File file) {
            this.file = file;
            try {
                this.is = new DataInputStream(IOUtil.maybeBufferInputStream(new FileInputStream(file)));
                this.next();
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeIOException(file.getAbsolutePath(), e2);
            }
        }

        boolean hasNext() {
            return this.isCurrentRecord;
        }

        long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long ret = this.currentRecord;
            try {
                this.currentRecord = this.is.readLong();
            }
            catch (EOFException eof) {
                this.isCurrentRecord = false;
                this.currentRecord = 0L;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return ret;
        }

        void close() {
            CloserUtil.close(this.is);
            IOUtil.deleteFiles(this.file);
        }
    }
}

