/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalTree;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntervalTreeMap<T>
extends AbstractMap<Interval, T> {
    private final Map<String, IntervalTree<T>> mSequenceMap = new HashMap<String, IntervalTree<T>>();
    private final EntrySet mEntrySet = new EntrySet();

    public IntervalTree<T> debugGetTree(String sequence) {
        return this.mSequenceMap.get(sequence);
    }

    public IntervalTreeMap() {
    }

    public IntervalTreeMap(Map<? extends Interval, ? extends T> map) {
        for (Map.Entry<Interval, T> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.mSequenceMap.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        return this.containsKey((Interval)object);
    }

    public boolean containsKey(Interval key) {
        IntervalTree<T> tree = this.mSequenceMap.get(key.getSequence());
        if (tree == null) {
            return false;
        }
        return tree.find(key.getStart(), key.getEnd()) != null;
    }

    @Override
    public Set<Map.Entry<Interval, T>> entrySet() {
        return this.mEntrySet;
    }

    @Override
    public boolean equals(Object o2) {
        if (!(o2 instanceof IntervalTreeMap)) {
            return false;
        }
        return ((Object)this.mSequenceMap).equals(((IntervalTreeMap)o2).mSequenceMap);
    }

    @Override
    public int hashCode() {
        return ((Object)this.mSequenceMap).hashCode();
    }

    @Override
    public T get(Object object) {
        if (!(object instanceof Interval)) {
            return null;
        }
        return this.get((Interval)object);
    }

    public T get(Interval key) {
        IntervalTree<T> tree = this.mSequenceMap.get(key.getSequence());
        if (tree == null) {
            return null;
        }
        IntervalTree.Node<T> node = tree.find(key.getStart(), key.getEnd());
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    @Override
    public boolean isEmpty() {
        for (IntervalTree<T> tree : this.mSequenceMap.values()) {
            if (tree.size() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public T put(Interval key, T value) {
        IntervalTree<Object> tree = this.mSequenceMap.get(key.getSequence());
        if (tree == null) {
            tree = new IntervalTree();
            this.mSequenceMap.put(key.getSequence(), tree);
        }
        return tree.put(key.getStart(), key.getEnd(), value);
    }

    @Override
    public T remove(Object object) {
        if (!(object instanceof Interval)) {
            return null;
        }
        return this.remove((Interval)object);
    }

    public T remove(Interval key) {
        IntervalTree<T> tree = this.mSequenceMap.get(key.getSequence());
        if (tree == null) {
            return null;
        }
        return tree.remove(key.getStart(), key.getEnd());
    }

    @Override
    public int size() {
        int size = 0;
        for (IntervalTree<T> tree : this.mSequenceMap.values()) {
            size += tree.size();
        }
        return size;
    }

    public boolean containsOverlapping(Interval key) {
        IntervalTree<T> tree = this.mSequenceMap.get(key.getSequence());
        return tree != null && tree.overlappers(key.getStart(), key.getEnd()).hasNext();
    }

    public Collection<T> getOverlapping(Interval key) {
        ArrayList<T> result = new ArrayList<T>();
        IntervalTree<T> tree = this.mSequenceMap.get(key.getSequence());
        if (tree != null) {
            Iterator<IntervalTree.Node<T>> iterator = tree.overlappers(key.getStart(), key.getEnd());
            while (iterator.hasNext()) {
                result.add(iterator.next().getValue());
            }
        }
        return result;
    }

    public boolean containsContained(Interval key) {
        IntervalTree<T> tree = this.mSequenceMap.get(key.getSequence());
        if (tree == null) {
            return false;
        }
        Iterator<IntervalTree.Node<T>> iterator = tree.overlappers(key.getStart(), key.getEnd());
        while (iterator.hasNext()) {
            IntervalTree.Node<T> node = iterator.next();
            if (node.getStart() < key.getStart() || node.getEnd() > key.getEnd()) continue;
            return true;
        }
        return false;
    }

    public Collection<T> getContained(Interval key) {
        ArrayList<T> result = new ArrayList<T>();
        IntervalTree<T> tree = this.mSequenceMap.get(key.getSequence());
        if (tree != null) {
            Iterator<IntervalTree.Node<T>> iterator = tree.overlappers(key.getStart(), key.getEnd());
            while (iterator.hasNext()) {
                IntervalTree.Node<T> node = iterator.next();
                if (node.getStart() < key.getStart() || node.getEnd() > key.getEnd()) continue;
                result.add(node.getValue());
            }
        }
        return result;
    }

    private class MapEntry
    implements Map.Entry<Interval, T> {
        private final Interval mKey;
        private T mValue;

        MapEntry(Interval key, T value) {
            this.mKey = key;
            this.mValue = value;
        }

        @Override
        public Interval getKey() {
            return this.mKey;
        }

        @Override
        public T getValue() {
            return this.mValue;
        }

        @Override
        public T setValue(T value) {
            this.mValue = value;
            return IntervalTreeMap.this.put(this.mKey, this.mValue);
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<Interval, T>> {
        private String mSequence = null;
        private Iterator<String> mSequenceIterator = null;
        private Iterator<IntervalTree.Node<T>> mTreeIterator = null;

        EntryIterator() {
            this.mSequenceIterator = IntervalTreeMap.this.mSequenceMap.keySet().iterator();
            this.advanceSequence();
        }

        @Override
        public boolean hasNext() {
            return this.mTreeIterator != null && this.mTreeIterator.hasNext();
        }

        @Override
        public Map.Entry<Interval, T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator exhausted");
            }
            IntervalTree.Node node = this.mTreeIterator.next();
            String sequence = this.mSequence;
            if (!this.mTreeIterator.hasNext()) {
                this.advanceSequence();
            }
            Interval key = new Interval(sequence, node.getStart(), node.getEnd());
            Object value = node.getValue();
            return new MapEntry(key, value);
        }

        @Override
        public void remove() {
            if (this.mTreeIterator == null) {
                throw new IllegalStateException("Iterator.next() has not been called");
            }
            this.mTreeIterator.remove();
        }

        private void advanceSequence() {
            while (this.mSequenceIterator.hasNext()) {
                this.mSequence = this.mSequenceIterator.next();
                this.mTreeIterator = ((IntervalTree)IntervalTreeMap.this.mSequenceMap.get(this.mSequence)).iterator();
                if (!this.mTreeIterator.hasNext()) continue;
                break;
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Interval, T>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            IntervalTreeMap.this.clear();
        }

        public boolean contains(Map.Entry<Interval, T> entry) {
            if (entry == null) {
                return false;
            }
            return entry.getValue().equals(IntervalTreeMap.this.get(entry.getKey()));
        }

        @Override
        public boolean isEmpty() {
            return IntervalTreeMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<Interval, T>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return this.remove((Map.Entry)object);
        }

        public boolean remove(Map.Entry<Interval, T> entry) {
            if (this.contains(entry)) {
                IntervalTreeMap.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return IntervalTreeMap.this.size();
        }
    }
}

