/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stats;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.util.stats.KaplanMeierEstimator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class KMPlotFrame
extends JFrame {
    Collection<Track> tracks;
    private XYPlot plot;
    int maxTime = 60;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JPanel panel2;
    private JLabel label2;
    private JComboBox survivalColumnControl;
    private JPanel panel3;
    private JLabel label3;
    private JComboBox censurColumnControl;
    private JPanel panel4;
    private JLabel label4;
    private JComboBox groupByControl;

    public KMPlotFrame(Collection<Track> tracks) {
        this.tracks = tracks;
        this.initComponents();
        XYDataset dataset = this.updateDataset();
        JFreeChart chart = ChartFactory.createXYLineChart("", "Time", "Survival", dataset, PlotOrientation.VERTICAL, true, true, false);
        XYStepRenderer renderer = new XYStepRenderer();
        this.plot = chart.getXYPlot();
        this.plot.setRenderer(renderer);
        ChartPanel plotPanel = new ChartPanel(chart);
        this.contentPanel.add((Component)plotPanel, "Center");
        this.censurColumnControl.addItem("");
        this.survivalColumnControl.addItem("");
        this.groupByControl.addItem("");
        List<String> allAttributes = AttributeManager.getInstance().getAttributeNames();
        List<String> groupableAttributes = AttributeManager.getInstance().getGroupableAttributes();
        String survivalColumn = null;
        String censureColumn = null;
        String sampleColumn = null;
        for (String key : allAttributes) {
            this.censurColumnControl.addItem(key);
            this.survivalColumnControl.addItem(key);
            String tmp = key.toLowerCase();
            if (tmp.contains("survival") || tmp.contains("daystodeath")) {
                survivalColumn = key;
            }
            if (tmp.contains("censure")) {
                censureColumn = key;
            }
            if (!tmp.contains("sample")) continue;
            sampleColumn = key;
        }
        for (String key : groupableAttributes) {
            this.groupByControl.addItem(key);
        }
        if (survivalColumn != null) {
            this.survivalColumnControl.setSelectedItem(survivalColumn);
        }
        if (censureColumn != null) {
            this.censurColumnControl.setSelectedItem(censureColumn);
        }
        if (sampleColumn != null) {
            // empty if block
        }
    }

    private void closeButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    public XYDataset updateDataset() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        String survivalColumn = (String)this.survivalColumnControl.getSelectedItem();
        String censureColumn = (String)this.censurColumnControl.getSelectedItem();
        String groupByColumn = (String)this.groupByControl.getSelectedItem();
        if (survivalColumn != null) {
            ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>(this.tracks.size());
            HashSet<String> participants = new HashSet<String>();
            for (Track t2 : this.tracks) {
                try {
                    String group;
                    int survivalDays;
                    String string = t2.getSample();
                    if (participants.contains(string)) continue;
                    participants.add(string);
                    String survivalString = t2.getAttributeValue(survivalColumn);
                    int survival = survivalDays = Integer.parseInt(survivalString);
                    String censureString = censureColumn == null ? null : t2.getAttributeValue(censureColumn);
                    boolean censured = censureString != null && censureString.equals("1");
                    String string2 = group = groupByColumn == null ? null : t2.getAttributeValue(groupByColumn);
                    if (group == null) {
                        group = "<No value>";
                    }
                    dataPoints.add(new DataPoint(string, survival, censured, group));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            HashMap<String, ArrayList<DataPoint>> map = new HashMap<String, ArrayList<DataPoint>>();
            for (DataPoint dataPoint : dataPoints) {
                String g2 = dataPoint.getGroup();
                ArrayList<DataPoint> pts = (ArrayList<DataPoint>)map.get(g2);
                if (pts == null) {
                    pts = new ArrayList<DataPoint>();
                    map.put(g2, pts);
                }
                pts.add(dataPoint);
            }
            for (Map.Entry entry : map.entrySet()) {
                List pts = (List)entry.getValue();
                Collections.sort(pts);
                int[] time = new int[pts.size()];
                boolean[] censured = new boolean[pts.size()];
                for (int i2 = 0; i2 < pts.size(); ++i2) {
                    time[i2] = ((DataPoint)pts.get((int)i2)).time;
                    censured[i2] = ((DataPoint)pts.get((int)i2)).censured;
                }
                List<KaplanMeierEstimator.Interval> controlIntervals = KaplanMeierEstimator.compute(time, censured);
                XYSeries series1 = new XYSeries((Comparable)entry.getKey());
                for (KaplanMeierEstimator.Interval interval : controlIntervals) {
                    series1.add((double)interval.getEnd(), interval.getCumulativeSurvival());
                }
                dataset.addSeries(series1);
            }
        }
        return dataset;
    }

    private void survivalColumnControlActionPerformed(ActionEvent e2) {
        XYDataset dataset = this.updateDataset();
        this.plot.setDataset(dataset);
        this.repaint();
    }

    private void initComponents() {
        Rectangle bounds;
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.survivalColumnControl = new JComboBox();
        this.panel3 = new JPanel();
        this.label3 = new JLabel();
        this.censurColumnControl = new JComboBox();
        this.panel4 = new JPanel();
        this.label4 = new JLabel();
        this.groupByControl = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Kaplan-Meier Plot");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panel1.setAlignmentX(0.0f);
        this.panel1.setLayout(new BoxLayout(this.panel1, 1));
        this.panel2.setAlignmentX(1.0f);
        this.panel2.setLayout(null);
        this.label2.setText("Survival column");
        this.panel2.add(this.label2);
        this.label2.setBounds(new Rectangle(new Point(5, 10), this.label2.getPreferredSize()));
        this.survivalColumnControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                KMPlotFrame.this.survivalColumnControlActionPerformed(e2);
            }
        });
        this.panel2.add(this.survivalColumnControl);
        this.survivalColumnControl.setBounds(120, 5, 235, this.survivalColumnControl.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.panel2.getComponentCount(); ++i2) {
            bounds = this.panel2.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel2.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel2.setMinimumSize(preferredSize);
        this.panel2.setPreferredSize(preferredSize);
        this.panel1.add(this.panel2);
        this.panel3.setAlignmentX(1.0f);
        this.panel3.setLayout(null);
        this.label3.setText("Censored column");
        this.panel3.add(this.label3);
        this.label3.setBounds(new Rectangle(new Point(5, 10), this.label3.getPreferredSize()));
        this.censurColumnControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                KMPlotFrame.this.survivalColumnControlActionPerformed(e2);
            }
        });
        this.panel3.add(this.censurColumnControl);
        this.censurColumnControl.setBounds(120, 5, 235, this.censurColumnControl.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i3 = 0; i3 < this.panel3.getComponentCount(); ++i3) {
            bounds = this.panel3.getComponent(i3).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel3.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel3.setMinimumSize(preferredSize);
        this.panel3.setPreferredSize(preferredSize);
        this.panel1.add(this.panel3);
        this.panel4.setAlignmentX(1.0f);
        this.panel4.setLayout(null);
        this.label4.setText("Group by");
        this.panel4.add(this.label4);
        this.label4.setBounds(new Rectangle(new Point(5, 10), this.label4.getPreferredSize()));
        this.groupByControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                KMPlotFrame.this.survivalColumnControlActionPerformed(e2);
            }
        });
        this.panel4.add(this.groupByControl);
        this.groupByControl.setBounds(120, 5, 235, this.groupByControl.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i4 = 0; i4 < this.panel4.getComponentCount(); ++i4) {
            bounds = this.panel4.getComponent(i4).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel4.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel4.setMinimumSize(preferredSize);
        this.panel4.setPreferredSize(preferredSize);
        this.panel1.add(this.panel4);
        this.contentPanel.add((Component)this.panel1, "North");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(565, 510);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static class DataPoint
    implements Comparable<DataPoint> {
        String participant;
        int time;
        boolean censured;
        private String group;

        DataPoint(String participant, int time, boolean censured, String group) {
            this.censured = censured;
            this.participant = participant;
            this.group = group;
            this.time = time;
        }

        @Override
        public int compareTo(DataPoint dataPoint) {
            return this.time - dataPoint.time;
        }

        public String getGroup() {
            return this.group;
        }
    }
}

