/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.BisulfiteBaseInfo;
import org.broad.igv.sam.BisulfiteBaseInfoNOMeseq;
import org.broad.igv.sam.FeatureRenderer;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.util.ChromosomeColors;

public class AlignmentRenderer
implements FeatureRenderer {
    private static Logger log = Logger.getLogger(AlignmentRenderer.class);
    public static final Color GROUP_DIVIDER_COLOR = new Color(200, 200, 200);
    private static byte[] softClippedReference = new byte[1000];
    private static Color smallISizeColor = new Color(0, 0, 150);
    private static Color largeISizeColor = new Color(150, 0, 0);
    private static Color purple = new Color(118, 24, 220);
    private static Color deletionColor = Color.black;
    private static Color skippedColor = new Color(150, 184, 200);
    public static Color grey1 = new Color(200, 200, 200);
    private static Stroke thickStroke = new BasicStroke(2.0f);
    private final Color bisulfiteColorFw1 = new Color(195, 195, 195);
    private final Color bisulfiteColorRev1 = new Color(195, 210, 195);
    private final Color nomeseqColor = new Color(195, 195, 195);
    public static final Color negStrandColor = new Color(150, 150, 230);
    public static final Color posStrandColor = new Color(230, 150, 150);
    private ColorTable readGroupColors;
    private ColorTable sampleColors;
    private ColorTable tagValueColors;
    private final Color LR_COLOR = grey1;
    private final Color RL_COLOR = new Color(0, 150, 0);
    private final Color RR_COLOR = new Color(20, 50, 200);
    private final Color LL_COLOR = new Color(0, 150, 150);
    private final Color OUTLINE_COLOR = new Color(185, 185, 185);
    private static final Color SUPPLEMENTARY_OUTLINE_COLOR = Color.blue;
    private static Map<String, AlignmentTrack.OrientationType> frOrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> f1f2OrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> f2f1OrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> rfOrientationTypes;
    private Map<AlignmentTrack.OrientationType, Color> typeToColorMap;
    public static HashMap<Character, Color> nucleotideColors;
    PreferenceManager prefs = PreferenceManager.getInstance();
    private static AlignmentRenderer instance;
    private TreeSet<Shape> arcsByStart;
    private TreeSet<Shape> arcsByEnd;
    private HashMap<Shape, Alignment> curveMap;

    private static void setNucleotideColors() {
        PreferenceManager prefs = PreferenceManager.getInstance();
        nucleotideColors = new HashMap();
        Color a2 = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.A"), Color.green);
        Color c2 = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.C"), Color.blue);
        Color t2 = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.T"), Color.red);
        Color g2 = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.G"), Color.gray);
        Color n2 = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.N"), Color.gray);
        nucleotideColors.put(Character.valueOf('A'), a2);
        nucleotideColors.put(Character.valueOf('a'), a2);
        nucleotideColors.put(Character.valueOf('C'), c2);
        nucleotideColors.put(Character.valueOf('c'), c2);
        nucleotideColors.put(Character.valueOf('T'), t2);
        nucleotideColors.put(Character.valueOf('t'), t2);
        nucleotideColors.put(Character.valueOf('G'), g2);
        nucleotideColors.put(Character.valueOf('g'), g2);
        nucleotideColors.put(Character.valueOf('N'), n2);
        nucleotideColors.put(Character.valueOf('n'), n2);
    }

    public static AlignmentRenderer getInstance() {
        if (instance == null) {
            instance = new AlignmentRenderer();
        }
        return instance;
    }

    private AlignmentRenderer() {
        this.initializeTagColors();
        this.curveMap = new HashMap();
        this.arcsByStart = new TreeSet<Shape>(new Comparator<Shape>(){

            @Override
            public int compare(Shape o1, Shape o2) {
                double x1 = o1.getBounds().getMinX();
                double x2 = o2.getBounds().getMinX();
                return (int)Math.signum(x1 - x2);
            }
        });
        this.arcsByEnd = new TreeSet<Shape>(new Comparator<Shape>(){

            @Override
            public int compare(Shape o1, Shape o2) {
                double x1 = o1.getBounds().getMaxX();
                double x2 = o2.getBounds().getMaxX();
                return (int)Math.signum(x1 - x2);
            }
        });
    }

    private static void initializeTagTypes() {
        frOrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        frOrientationTypes.put("F1R2", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F2R1", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F R ", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("FR", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F1F2", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("F2F1", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("F F ", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("FF", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("R1R2", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R2R1", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R R ", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("RR", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R1F2", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("R2F1", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("R F ", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("RF", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        rfOrientationTypes.put("R1F2", AlignmentTrack.OrientationType.LR);
        rfOrientationTypes.put("R2F1", AlignmentTrack.OrientationType.LR);
        rfOrientationTypes.put("R1R2", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("R2R1", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("R R ", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("RR ", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("F1F2", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F2F1", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F F ", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("FF", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F1R2", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("F2R1", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("F R ", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("FR", AlignmentTrack.OrientationType.RL);
        f2f1OrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        f2f1OrientationTypes.put("F2F1", AlignmentTrack.OrientationType.LR);
        f2f1OrientationTypes.put("R1R2", AlignmentTrack.OrientationType.LR);
        f2f1OrientationTypes.put("F2R1", AlignmentTrack.OrientationType.LL);
        f2f1OrientationTypes.put("R1F2", AlignmentTrack.OrientationType.LL);
        f2f1OrientationTypes.put("R2F1", AlignmentTrack.OrientationType.RR);
        f2f1OrientationTypes.put("F1R2", AlignmentTrack.OrientationType.RR);
        f2f1OrientationTypes.put("R2R1", AlignmentTrack.OrientationType.RL);
        f2f1OrientationTypes.put("F1F2", AlignmentTrack.OrientationType.RL);
        f1f2OrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        f1f2OrientationTypes.put("F1F2", AlignmentTrack.OrientationType.LR);
        f1f2OrientationTypes.put("R2R1", AlignmentTrack.OrientationType.LR);
        f1f2OrientationTypes.put("F1R2", AlignmentTrack.OrientationType.LL);
        f1f2OrientationTypes.put("R2F1", AlignmentTrack.OrientationType.LL);
        f1f2OrientationTypes.put("R1F2", AlignmentTrack.OrientationType.RR);
        f1f2OrientationTypes.put("F2R1", AlignmentTrack.OrientationType.RR);
        f1f2OrientationTypes.put("R1R2", AlignmentTrack.OrientationType.RL);
        f1f2OrientationTypes.put("F2F1", AlignmentTrack.OrientationType.RL);
    }

    private void initializeTagColors() {
        ColorPalette palette = ColorUtilities.getPalette("Pastel 1");
        this.readGroupColors = new PaletteColorTable(palette);
        this.sampleColors = new PaletteColorTable(palette);
        this.tagValueColors = new PaletteColorTable(palette);
        this.typeToColorMap = new HashMap<AlignmentTrack.OrientationType, Color>(5);
        this.typeToColorMap.put(AlignmentTrack.OrientationType.LL, this.LL_COLOR);
        this.typeToColorMap.put(AlignmentTrack.OrientationType.LR, this.LR_COLOR);
        this.typeToColorMap.put(AlignmentTrack.OrientationType.RL, this.RL_COLOR);
        this.typeToColorMap.put(AlignmentTrack.OrientationType.RR, this.RR_COLOR);
        this.typeToColorMap.put(null, grey1);
    }

    @Override
    public void renderAlignments(List<Alignment> alignments, RenderContext context, Rectangle rowRect, Rectangle trackRect, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, Map<String, Color> selectedReadNames) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Font font = FontManager.getFont(10);
        boolean completeReadsOnly = PreferenceManager.getInstance().getAsBoolean("SAM.COMPLETE_READS_ONLY");
        if (alignments != null && alignments.size() > 0) {
            int lastPixelDrawn = -1;
            for (Alignment alignment : alignments) {
                Graphics2D g2;
                Color alignmentColor;
                double pixelStart = ((double)alignment.getStart() - origin) / locScale;
                double pixelEnd = ((double)alignment.getEnd() - origin) / locScale;
                if (pixelEnd < (double)rowRect.x || pixelStart > rowRect.getMaxX() || completeReadsOnly && (pixelStart < (double)rowRect.x || pixelEnd > rowRect.getMaxX())) continue;
                double pixelWidth = pixelEnd - pixelStart;
                if (!(!(pixelWidth < 4.0) || AlignmentTrack.isBisulfiteColorType(renderOptions.getColorOption()) && pixelWidth >= 1.0)) {
                    alignmentColor = this.getAlignmentColor(alignment, renderOptions);
                    if (pixelEnd <= (double)lastPixelDrawn && alignmentColor == grey1) continue;
                    g2 = context.getGraphic2DForColor(alignmentColor);
                    g2.setFont(font);
                    int w2 = Math.max(1, (int)pixelWidth);
                    int h2 = (int)Math.max(1.0, rowRect.getHeight() - 2.0);
                    int y = (int)(rowRect.getY() + (rowRect.getHeight() - (double)h2) / 2.0);
                    g2.fillRect((int)pixelStart, y, w2, h2);
                    lastPixelDrawn = (int)pixelStart + w2;
                    continue;
                }
                if (alignment instanceof PairedAlignment) {
                    this.drawPairedAlignment((PairedAlignment)alignment, rowRect, trackRect, context, renderOptions, leaveMargin, selectedReadNames, font);
                    continue;
                }
                alignmentColor = this.getAlignmentColor(alignment, renderOptions);
                g2 = context.getGraphic2DForColor(alignmentColor);
                g2.setFont(font);
                this.drawAlignment(alignment, rowRect, trackRect, g2, context, alignmentColor, renderOptions, leaveMargin, selectedReadNames);
            }
            boolean showCenterLine = this.prefs.getAsBoolean("SAM.SHOW_CENTER_LINE");
            int bottom = rowRect.y + rowRect.height;
            if (locScale < 5.0 && showCenterLine) {
                double center = (int)(context.getReferenceFrame().getCenter() - origin);
                int centerLeftP = (int)(center / locScale);
                int centerRightP = (int)((center + 1.0) / locScale);
                Graphics2D gBlack = context.getGraphic2DForColor(Color.black);
                GraphicUtils.drawDottedDashLine(gBlack, centerLeftP, rowRect.y, centerLeftP, bottom);
                if (centerRightP - centerLeftP > 2) {
                    GraphicUtils.drawDottedDashLine(gBlack, centerRightP, rowRect.y, centerRightP, bottom);
                }
            }
        }
    }

    private void drawSimpleAlignment(Alignment alignment, Rectangle rect, Graphics2D g2, RenderContext context, boolean flagUnmappedPair) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        int x2 = (int)(((double)alignment.getStart() - origin) / locScale);
        int length = alignment.getEnd() - alignment.getStart();
        int w2 = (int)Math.ceil((double)length / locScale);
        int h2 = (int)Math.max(1.0, rect.getHeight() - 2.0);
        int y = (int)(rect.getY() + (rect.getHeight() - (double)h2) / 2.0);
        int arrowLength = Math.min(5, w2 / 6);
        int[] xPoly = null;
        int[] yPoly = new int[]{y, y, y + h2 / 2, y + h2, y + h2};
        if (x2 < rect.x && x2 + w2 > rect.x + rect.width) {
            x2 = rect.x;
            w2 = rect.width;
            arrowLength = 0;
        } else if (x2 < rect.x) {
            int delta = rect.x - x2;
            x2 = rect.x;
            w2 -= delta;
            if (alignment.isNegativeStrand()) {
                arrowLength = 0;
            }
        } else if (x2 + w2 > rect.x + rect.width) {
            w2 -= x2 + w2 - (rect.x + rect.width);
            if (!alignment.isNegativeStrand()) {
                arrowLength = 0;
            }
        }
        xPoly = alignment.isNegativeStrand() ? new int[]{x2 + w2, x2, x2 - arrowLength, x2, x2 + w2} : new int[]{x2, x2 + w2, x2 + w2 + arrowLength, x2 + w2, x2};
        g2.fillPolygon(xPoly, yPoly, xPoly.length);
        if (flagUnmappedPair && alignment.isPaired() && !alignment.getMate().isMapped()) {
            Graphics2D cRed = context.getGraphic2DForColor(Color.red);
            cRed.drawPolygon(xPoly, yPoly, xPoly.length);
        }
    }

    private void drawPairedAlignment(PairedAlignment pair, Rectangle rowRect, Rectangle trackRect, RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, Map<String, Color> selectedReadNames, Font font) {
        Color alignmentColor1;
        if (renderOptions.isPairedArcView() && this.getOutlierStatus(pair, renderOptions) == 0) {
            return;
        }
        double locScale = context.getScale();
        Color alignmentColor2 = null;
        if (renderOptions.isPairedArcView()) {
            renderOptions.setColorOption(AlignmentTrack.ColorOption.INSERT_SIZE);
            alignmentColor2 = alignmentColor1 = this.getAlignmentColor(pair, renderOptions);
        } else {
            alignmentColor1 = this.getAlignmentColor(pair.firstAlignment, renderOptions);
        }
        Graphics2D g2 = context.getGraphic2DForColor(alignmentColor1);
        g2.setFont(font);
        this.drawAlignment(pair.firstAlignment, rowRect, trackRect, g2, context, alignmentColor1, renderOptions, leaveMargin, selectedReadNames);
        if (pair.secondAlignment != null) {
            if (alignmentColor2 == null) {
                alignmentColor2 = this.getAlignmentColor(pair.secondAlignment, renderOptions);
            }
        } else {
            return;
        }
        g2 = context.getGraphic2DForColor(alignmentColor2);
        this.drawAlignment(pair.secondAlignment, rowRect, trackRect, g2, context, alignmentColor2, renderOptions, leaveMargin, selectedReadNames);
        Color lineColor = grey1;
        if (alignmentColor1.equals(alignmentColor2) || pair.secondAlignment == null) {
            lineColor = alignmentColor1;
        }
        Graphics2D gLine = context.getGraphic2DForColor(lineColor);
        double origin = context.getOrigin();
        int startX = (int)(((double)pair.firstAlignment.getEnd() - origin) / locScale);
        int endX = (int)(((double)pair.firstAlignment.getMate().getStart() - origin) / locScale);
        int h2 = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
        int y = (int)rowRect.getY();
        if (renderOptions.isPairedArcView()) {
            int relation = this.compareToBounds(pair, renderOptions);
            if (relation <= -1 || relation >= 1) {
                return;
            }
            GeneralPath path = new GeneralPath(1, 4);
            int curveHeight = (int)Math.log(endX - startX) * h2;
            double botY = y + h2 / 2;
            double topY = y + h2 / 2 - curveHeight;
            double midX = (endX + startX) / 2;
            path.moveTo((double)startX, botY);
            path.quadTo(midX, topY, (double)endX, botY);
            path.quadTo(midX, topY - 2.0, (double)startX, botY);
            path.closePath();
            this.arcsByStart.add(path);
            this.arcsByEnd.add(path);
            this.curveMap.put(path, pair);
            gLine.setColor(alignmentColor2);
            gLine.draw(path);
        } else {
            startX = Math.max(rowRect.x, startX);
            endX = Math.min(rowRect.x + rowRect.width, endX);
            gLine.drawLine(startX, y + h2 / 2, endX, y + h2 / 2);
        }
    }

    private void drawAlignment(Alignment alignment, Rectangle rowRect, Rectangle trackRect, Graphics2D g2, RenderContext context, Color alignmentColor, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, Map<String, Color> selectedReadNames) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        if (blocks == null || blocks.length == 0) {
            this.drawSimpleAlignment(alignment, rowRect, g2, context, renderOptions.flagUnmappedPairs);
            return;
        }
        AlignmentBlock terminalBlock = alignment.isNegativeStrand() ? blocks[0] : blocks[blocks.length - 1];
        int lastBlockEnd = Integer.MIN_VALUE;
        int blockNumber = -1;
        char[] gapTypes = alignment.getGapTypes();
        boolean highZoom = locScale < 0.1251;
        Graphics2D outlineGraphics = context.getGraphic2DForColor(this.OUTLINE_COLOR);
        Graphics2D terminalGrpahics = context.getGraphic2DForColor(Color.DARK_GRAY);
        boolean isZeroQuality = alignment.getMappingQuality() == 0 && renderOptions.flagZeroQualityAlignments;
        int h2 = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
        int y = (int)rowRect.getY();
        for (AlignmentBlock aBlock : alignment.getAlignmentBlocks()) {
            ++blockNumber;
            int blockPixelStart = (int)(((double)aBlock.getStart() - origin) / locScale);
            int blockPixelWidth = (int)Math.ceil((double)aBlock.getLength() / locScale);
            if (highZoom && blockPixelWidth > 10) {
                ++blockPixelStart;
                blockPixelWidth -= 2;
            }
            if (blockPixelStart + blockPixelWidth >= rowRect.x && (double)blockPixelStart <= rowRect.getMaxX()) {
                Shape blockShape = null;
                if (aBlock == terminalBlock && blockPixelWidth > 10) {
                    if (h2 > 10) {
                        int arrowLength = Math.min(5, blockPixelWidth / 6);
                        if (blockPixelStart < rowRect.x && blockPixelStart + blockPixelWidth > rowRect.x + rowRect.width) {
                            blockPixelStart = rowRect.x;
                            blockPixelWidth = rowRect.width;
                            arrowLength = 0;
                        } else if (blockPixelStart < rowRect.x) {
                            int delta = rowRect.x - blockPixelStart;
                            blockPixelStart = rowRect.x;
                            blockPixelWidth -= delta;
                            if (alignment.isNegativeStrand()) {
                                arrowLength = 0;
                            }
                        } else if (blockPixelStart + blockPixelWidth > rowRect.x + rowRect.width) {
                            blockPixelWidth -= blockPixelStart + blockPixelWidth - (rowRect.x + rowRect.width);
                            if (!alignment.isNegativeStrand()) {
                                arrowLength = 0;
                            }
                        }
                        int[] yPoly = new int[]{y, y, y + h2 / 2, y + h2, y + h2};
                        int[] xPoly = alignment.isNegativeStrand() ? new int[]{blockPixelStart + blockPixelWidth, blockPixelStart, blockPixelStart - arrowLength, blockPixelStart, blockPixelStart + blockPixelWidth} : new int[]{blockPixelStart, blockPixelStart + blockPixelWidth, blockPixelStart + blockPixelWidth + arrowLength, blockPixelStart + blockPixelWidth, blockPixelStart};
                        blockShape = new Polygon(xPoly, yPoly, xPoly.length);
                    } else {
                        int tH = Math.max(1, h2 - 1);
                        if (alignment.isNegativeStrand()) {
                            blockShape = new Rectangle(blockPixelStart, y, blockPixelWidth, h2);
                            terminalGrpahics.drawLine(blockPixelStart, y, blockPixelStart, y + tH);
                        } else {
                            blockShape = new Rectangle(blockPixelStart, y, blockPixelWidth, h2);
                            terminalGrpahics.drawLine(blockPixelStart + blockPixelWidth + 1, y, blockPixelStart + blockPixelWidth + 1, y + tH);
                        }
                    }
                } else {
                    blockShape = new Rectangle(blockPixelStart, y, blockPixelWidth, h2);
                }
                g2.fill(blockShape);
                if (isZeroQuality) {
                    outlineGraphics.draw(blockShape);
                }
                if (renderOptions.flagUnmappedPairs && alignment.isPaired() && !alignment.getMate().isMapped()) {
                    Graphics2D cRed = context.getGraphic2DForColor(Color.red);
                    cRed.draw(blockShape);
                }
                if (alignment.isSupplementary()) {
                    context.getGraphic2DForColor(SUPPLEMENTARY_OUTLINE_COLOR).draw(blockShape);
                }
                if (selectedReadNames.containsKey(alignment.getReadName())) {
                    Color c2 = selectedReadNames.get(alignment.getReadName());
                    if (c2 == null) {
                        c2 = Color.blue;
                    }
                    Graphics2D cBlue = context.getGraphic2DForColor(c2);
                    Stroke s2 = cBlue.getStroke();
                    cBlue.setStroke(thickStroke);
                    cBlue.draw(blockShape);
                    cBlue.setStroke(s2);
                }
            }
            if ((locScale < 5.0 || AlignmentTrack.isBisulfiteColorType(renderOptions.getColorOption()) && locScale < 100.0) && (renderOptions.showMismatches || renderOptions.showAllBases)) {
                this.drawBases(context, rowRect, alignment, aBlock, alignmentColor, renderOptions);
            }
            if (lastBlockEnd > Integer.MIN_VALUE && blockPixelStart > rowRect.x) {
                Stroke stroke;
                Graphics2D gLine;
                int gapIdx = blockNumber - 1;
                Color gapLineColor = deletionColor;
                if (gapTypes != null && gapIdx < gapTypes.length && gapTypes[gapIdx] == 'N') {
                    gLine = context.getGraphic2DForColor(skippedColor);
                    stroke = gLine.getStroke();
                } else {
                    gLine = context.getGraphic2DForColor(gapLineColor);
                    stroke = gLine.getStroke();
                    gLine.setStroke(thickStroke);
                }
                int startX = Math.max(rowRect.x, lastBlockEnd);
                int endX = Math.min(rowRect.x + rowRect.width, blockPixelStart);
                gLine.drawLine(startX, y + h2 / 2, endX, y + h2 / 2);
                gLine.setStroke(stroke);
            }
            if ((double)(lastBlockEnd = blockPixelStart + blockPixelWidth) > rowRect.getMaxX()) break;
        }
        if (locScale < 1.0) {
            this.drawInsertions(origin, rowRect, locScale, alignment, context, renderOptions);
        }
        if (renderOptions.isPairedArcView()) {
            try {
                Graphics2D gLine = context.getGraphic2DForColor(alignmentColor);
                if (!alignment.getChr().equalsIgnoreCase(alignment.getMate().getChr())) {
                    gLine.drawLine(lastBlockEnd, y + h2 / 2, lastBlockEnd, (int)trackRect.getMinY());
                }
            }
            catch (NullPointerException e2) {
                // empty catch block
            }
        }
    }

    private void drawBases(RenderContext context, Rectangle rect, Alignment baseAlignment, AlignmentBlock block, Color alignmentColor, AlignmentTrack.RenderOptions renderOptions) {
        boolean showAllBases;
        boolean isSoftClipped = block.isSoftClipped();
        String chr = context.getChr();
        int start = block.getStart();
        int end = block.getEnd();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        byte[] reference = isSoftClipped ? softClippedReference : genome.getSequence(chr, start, end);
        boolean haveBases = block.hasBases() && block.getLength() > 0;
        AlignmentTrack.ShadeBasesOption shadeBasesOption = renderOptions.shadeBasesOption;
        AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
        boolean bl = showAllBases = renderOptions.showAllBases && colorOption != AlignmentTrack.ColorOption.BISULFITE && colorOption != AlignmentTrack.ColorOption.NOMESEQ;
        if (!(showAllBases || haveBases && reference != null)) {
            return;
        }
        byte[] read = haveBases ? block.getBases() : reference;
        double locScale = context.getScale();
        double origin = context.getOrigin();
        int pY = (int)rect.getY();
        int dY = (int)rect.getHeight();
        int dX = (int)Math.max(1.0, 1.0 / locScale);
        Graphics2D g2 = (Graphics2D)context.getGraphics().create();
        if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (dX >= 8) {
            Font f2 = FontManager.getFont(1, Math.min(dX, 12));
            g2.setFont(f2);
        }
        BisulfiteBaseInfo bisinfo = null;
        boolean nomeseqMode = renderOptions.getColorOption().equals((Object)AlignmentTrack.ColorOption.NOMESEQ);
        boolean bisulfiteMode = AlignmentTrack.isBisulfiteColorType(renderOptions.getColorOption());
        if (nomeseqMode) {
            bisinfo = new BisulfiteBaseInfoNOMeseq(reference, baseAlignment, block, renderOptions.bisulfiteContext);
        } else if (bisulfiteMode) {
            bisinfo = new BisulfiteBaseInfo(reference, baseAlignment, block, renderOptions.bisulfiteContext);
        }
        for (int loc = start; loc < end; ++loc) {
            boolean misMatch;
            int idx = loc - start;
            boolean bl2 = misMatch = haveBases && AlignmentUtils.isMisMatch(reference, read, isSoftClipped, idx);
            if (!showAllBases && (bisulfiteMode || !misMatch) && (!bisulfiteMode || BisulfiteBaseInfo.DisplayStatus.NOTHING.equals((Object)bisinfo.getDisplayStatus(idx)))) continue;
            char c2 = (char)read[idx];
            Color color = nucleotideColors.get(Character.valueOf(c2));
            if (bisulfiteMode) {
                color = bisinfo.getDisplayColor(idx);
            }
            if (color == null) {
                color = Color.black;
            }
            if (AlignmentTrack.ShadeBasesOption.QUALITY == shadeBasesOption) {
                byte qual = block.getQuality(loc - start);
                color = this.getShadedColor(qual, color, alignmentColor, this.prefs);
            } else if ((AlignmentTrack.ShadeBasesOption.FLOW_SIGNAL_DEVIATION_READ == shadeBasesOption || AlignmentTrack.ShadeBasesOption.FLOW_SIGNAL_DEVIATION_REFERENCE == shadeBasesOption) && block.hasFlowSignals()) {
                color = this.getFlowSignalColor(reference, misMatch, genome, block, chr, start, loc, idx, shadeBasesOption, alignmentColor, color);
            }
            double bisulfiteXaxisShift = bisulfiteMode ? bisinfo.getXaxisShift(idx) : 0.0;
            int pX = (int)(((double)loc + bisulfiteXaxisShift - origin) / locScale);
            if ((double)pX > rect.getMaxX()) break;
            if ((double)(pX + dX) < rect.getX()) continue;
            BisulfiteBaseInfo.DisplayStatus bisstatus = bisinfo == null ? null : bisinfo.getDisplayStatus(idx);
            this.drawBase(g2, color, c2, pX, pY, dX, dY, bisulfiteMode, bisstatus);
        }
    }

    private Color getFlowSignalColor(byte[] reference, boolean misMatch, Genome genome, AlignmentBlock block, String chr, int start, int loc, int idx, AlignmentTrack.ShadeBasesOption shadeBasesOption, Color alignmentColor, Color color) {
        int flowSignalDiff;
        int expectedFlowSignal;
        int flowSignal = block.getFlowSignalSubContext(loc - start).getCurrentSignal();
        if (AlignmentTrack.ShadeBasesOption.FLOW_SIGNAL_DEVIATION_READ == shadeBasesOption) {
            expectedFlowSignal = 100 * (short)(((double)flowSignal + 50.0) / 100.0);
        } else if (!misMatch) {
            byte refbase = reference[idx];
            expectedFlowSignal = 100;
            int pos = start + idx - 1;
            while (0 <= pos && genome.getReference(chr, pos) == refbase) {
                --pos;
                expectedFlowSignal += 100;
            }
            pos = start + idx + 1;
            while (pos < genome.getChromosome(chr).getLength() && genome.getReference(chr, pos) == refbase) {
                ++pos;
                expectedFlowSignal += 100;
            }
        } else {
            expectedFlowSignal = 0;
        }
        int n2 = flowSignalDiff = expectedFlowSignal < flowSignal ? flowSignal - expectedFlowSignal : expectedFlowSignal - flowSignal;
        if (flowSignalDiff <= 0) {
            flowSignalDiff = 0;
        } else if (50 < flowSignalDiff) {
            flowSignalDiff = 50;
        }
        flowSignalDiff = 50 - flowSignalDiff;
        int minQ = this.prefs.getAsInt("SAM.BASE_QUALITY_MIN");
        int maxQ = this.prefs.getAsInt("SAM.BASE_QUALITY_MAX");
        flowSignalDiff = flowSignalDiff * (maxQ - minQ) / 50;
        byte qual = 127 < flowSignalDiff ? (byte)127 : (flowSignalDiff < -128 ? (byte)-128 : (byte)((byte)flowSignalDiff));
        return this.getShadedColor(qual, color, alignmentColor, this.prefs);
    }

    private void drawBase(Graphics2D g2, Color color, char c2, int pX, int pY, int dX, int dY, boolean bisulfiteMode, BisulfiteBaseInfo.DisplayStatus bisstatus) {
        if (dY >= 12 && dX >= 8 && (!bisulfiteMode || bisulfiteMode && bisstatus.equals((Object)BisulfiteBaseInfo.DisplayStatus.CHARACTER))) {
            g2.setColor(color);
            GraphicUtils.drawCenteredText(new char[]{c2}, pX, pY + 1, dX, dY - 2, g2);
        } else {
            int dW;
            int pX0i = pX;
            int dXi = dX;
            if (bisulfiteMode && bisstatus.equals((Object)BisulfiteBaseInfo.DisplayStatus.COLOR) && dXi < 3) {
                int expansion = dXi;
                pX0i -= expansion;
                dXi += 2 * expansion;
            }
            int n2 = dW = dXi > 4 ? dXi - 1 : dXi;
            if (color != null) {
                g2.setColor(color);
                if (dY < 10) {
                    g2.fillRect(pX0i, pY, dXi, dY);
                } else {
                    g2.fillRect(pX0i, pY + 1, dW, dY - 3);
                }
            }
        }
    }

    private Color getShadedColor(byte qual, Color foregroundColor, Color backgroundColor, PreferenceManager prefs) {
        float alpha = 0.0f;
        int minQ = prefs.getAsInt("SAM.BASE_QUALITY_MIN");
        if (qual < minQ) {
            alpha = 0.1f;
        } else {
            int maxQ = prefs.getAsInt("SAM.BASE_QUALITY_MAX");
            alpha = Math.max(0.1f, Math.min(1.0f, 0.1f + 0.9f * (float)(qual - minQ) / (float)(maxQ - minQ)));
        }
        alpha = (float)((int)(alpha * 10.0f + 0.5f)) / 10.0f;
        if (alpha >= 1.0f) {
            return foregroundColor;
        }
        Color color = ColorUtilities.getCompositeColor(backgroundColor, foregroundColor, alpha);
        return color;
    }

    private void drawInsertions(double origin, Rectangle rect, double locScale, Alignment alignment, RenderContext context, AlignmentTrack.RenderOptions renderOptions) {
        AlignmentBlock[] insertions = alignment.getInsertions();
        if (insertions != null) {
            for (AlignmentBlock aBlock : insertions) {
                Graphics2D gInsertion;
                int x2 = (int)(((double)aBlock.getStart() - origin) / locScale);
                int h2 = (int)Math.max(1.0, rect.getHeight() - 2.0);
                int y = (int)(rect.getY() + (rect.getHeight() - (double)h2) / 2.0);
                if ((double)x2 > rect.getMaxX()) break;
                if ((double)x2 < rect.getX()) continue;
                if (renderOptions.isFlagLargeInsertions() && aBlock.getBases().length > renderOptions.getLargeInsertionsThreshold()) {
                    gInsertion = context.getGraphic2DForColor(Color.red);
                    gInsertion.fillRect(x2 - 5, y, 10, 2);
                    gInsertion.fillRect(x2 - 3, y, 6, h2);
                    gInsertion.fillRect(x2 - 5, y + h2 - 2, 10, 2);
                    continue;
                }
                gInsertion = context.getGraphic2DForColor(purple);
                gInsertion.fillRect(x2 - 2, y, 4, 2);
                gInsertion.fillRect(x2 - 1, y, 2, h2);
                gInsertion.fillRect(x2 - 2, y + h2 - 2, 4, 2);
            }
        }
    }

    private Color getAlignmentColor(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        Color color = alignment.getColor();
        if (color != null) {
            return color;
        }
        Color c2 = alignment.isSupplementary() ? Color.darkGray : grey1;
        AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
        switch (colorOption) {
            case BISULFITE: {
                c2 = alignment.getFirstOfPairStrand() == Strand.POSITIVE ? this.bisulfiteColorFw1 : this.bisulfiteColorRev1;
                break;
            }
            case NOMESEQ: {
                c2 = this.nomeseqColor;
                break;
            }
            case UNEXPECTED_PAIR: 
            case PAIR_ORIENTATION: {
                c2 = this.getOrientationColor(alignment, AlignmentRenderer.getPEStats(alignment, renderOptions));
                if (colorOption == AlignmentTrack.ColorOption.PAIR_ORIENTATION) break;
            }
            case INSERT_SIZE: {
                boolean sameChr;
                boolean isPairedAlignment = alignment instanceof PairedAlignment;
                if ((!alignment.isPaired() || !alignment.getMate().isMapped()) && !isPairedAlignment) break;
                boolean bl = sameChr = isPairedAlignment || alignment.getMate().getChr().equals(alignment.getChr());
                if (sameChr) {
                    int readDistance = Math.abs(alignment.getInferredInsertSize());
                    if (readDistance == 0) break;
                    int minThreshold = renderOptions.getMinInsertSize();
                    int maxThreshold = renderOptions.getMaxInsertSize();
                    PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
                    if (renderOptions.isComputeIsizes() && peStats != null) {
                        minThreshold = peStats.getMinThreshold();
                        maxThreshold = peStats.getMaxThreshold();
                    }
                    if (readDistance < minThreshold) {
                        c2 = smallISizeColor;
                        break;
                    }
                    if (readDistance <= maxThreshold) break;
                    c2 = largeISizeColor;
                    break;
                }
                c2 = ChromosomeColors.getColor(alignment.getMate().getChr());
                if (c2 != null) break;
                c2 = Color.black;
                break;
            }
            case READ_STRAND: {
                if (alignment.isNegativeStrand()) {
                    c2 = negStrandColor;
                    break;
                }
                c2 = posStrandColor;
                break;
            }
            case FIRST_OF_PAIR_STRAND: {
                Strand fragmentStrand = alignment.getFirstOfPairStrand();
                if (fragmentStrand == Strand.NEGATIVE) {
                    c2 = negStrandColor;
                    break;
                }
                if (fragmentStrand != Strand.POSITIVE) break;
                c2 = posStrandColor;
                break;
            }
            case READ_GROUP: {
                String rg = alignment.getReadGroup();
                if (rg == null) break;
                c2 = this.readGroupColors.get(rg);
                break;
            }
            case SAMPLE: {
                String sample = alignment.getSample();
                if (sample == null) break;
                c2 = this.sampleColors.get(sample);
                break;
            }
            case TAG: {
                Object tagValue;
                String tag = renderOptions.getColorByTag();
                if (tag == null || (tagValue = alignment.getAttribute(tag)) == null) break;
                c2 = this.tagValueColors.get(tagValue.toString());
                break;
            }
        }
        if (c2 == null) {
            c2 = grey1;
        }
        if (alignment.getMappingQuality() == 0 && renderOptions.flagZeroQualityAlignments) {
            float alpha = 0.15f;
            return ColorUtilities.getCompositeColor(Color.white, c2, alpha);
        }
        return c2;
    }

    public static PEStats getPEStats(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        String lb = alignment.getLibrary();
        if (lb == null) {
            lb = "null";
        }
        PEStats peStats = null;
        if (renderOptions.peStats != null) {
            peStats = renderOptions.peStats.get(lb);
        }
        return peStats;
    }

    private int getOutlierStatus(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
        if (renderOptions.isComputeIsizes() && peStats != null) {
            int minThreshold = peStats.getMinOutlierInsertSize();
            int maxThreshold = peStats.getMaxOutlierInsertSize();
            int dist = Math.abs(alignment.getInferredInsertSize());
            if (dist >= minThreshold || dist <= maxThreshold) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    private int compareToBounds(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        int dist;
        int minThreshold = renderOptions.getMinInsertSize();
        int maxThreshold = renderOptions.getMaxInsertSize();
        PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
        if (renderOptions.isComputeIsizes() && peStats != null) {
            minThreshold = peStats.getMinThreshold();
            maxThreshold = peStats.getMaxThreshold();
        }
        if ((dist = Math.abs(alignment.getInferredInsertSize())) < minThreshold) {
            return -1;
        }
        if (dist > maxThreshold) {
            return 1;
        }
        return 0;
    }

    private static Color getColorRelDistance(PairedAlignment pair) {
        if (pair.secondAlignment == null) {
            return grey1;
        }
        int dist = Math.abs(pair.getInferredInsertSize());
        double logDist = Math.log(dist);
        Color minColor = smallISizeColor;
        Color maxColor = largeISizeColor;
        ContinuousColorScale colorScale = new ContinuousColorScale(0.0, 20.0, minColor, maxColor);
        return colorScale.getColor((float)logDist);
    }

    private Color getOrientationColor(Alignment alignment, PEStats peStats) {
        AlignmentTrack.OrientationType type = AlignmentRenderer.getOrientationType(alignment, peStats);
        Color c2 = this.typeToColorMap.get((Object)type);
        return c2 == null ? grey1 : c2;
    }

    static AlignmentTrack.OrientationType getOrientationType(Alignment alignment, PEStats peStats) {
        AlignmentTrack.OrientationType type = null;
        if (alignment.isPaired()) {
            String pairOrientation = alignment.getPairOrientation();
            if (peStats != null) {
                PEStats.Orientation libraryOrientation = peStats.getOrientation();
                switch (libraryOrientation) {
                    case FR: {
                        type = frOrientationTypes.get(pairOrientation);
                        break;
                    }
                    case RF: {
                        type = rfOrientationTypes.get(pairOrientation);
                        break;
                    }
                    case F1F2: {
                        type = f1f2OrientationTypes.get(pairOrientation);
                        break;
                    }
                    case F2F1: {
                        type = f2f1OrientationTypes.get(pairOrientation);
                    }
                }
            } else {
                type = alignment.getAttribute("CS") != null ? f2f1OrientationTypes.get(pairOrientation) : frOrientationTypes.get(pairOrientation);
            }
        }
        return type;
    }

    private Color getTemplateStrandColor(Alignment alignment) {
        Object c2 = null;
        if (alignment.isPaired()) {
            String pairOrientation = alignment.getPairOrientation();
            return this.tagValueColors.get(pairOrientation);
        }
        return c2 == null ? grey1 : c2;
    }

    public SortedSet<Shape> curveOverlap(double x2) {
        QuadCurve2D.Double tcurve = new QuadCurve2D.Double();
        ((QuadCurve2D)tcurve).setCurve(x2, 0.0, x2, 0.0, x2, 0.0);
        TreeSet<Shape> overlap = new TreeSet<Shape>((SortedSet<Shape>)this.arcsByStart.headSet(tcurve, true));
        overlap.retainAll(this.arcsByEnd.tailSet(tcurve, true));
        return overlap;
    }

    public Alignment getAlignmentForCurve(Shape curve) {
        return this.curveMap.get(curve);
    }

    public void clearCurveMaps() {
        this.curveMap.clear();
        this.arcsByStart.clear();
        this.arcsByEnd.clear();
    }

    static {
        AlignmentRenderer.initializeTagTypes();
        AlignmentRenderer.setNucleotideColors();
    }
}

