/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.lists;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.VariantListEntry;
import org.broad.igv.lists.VariantListManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;

public class VariantListNavigator
extends JDialog {
    private JScrollPane scrollPane1;
    private JList variantList;
    private JPanel panel1;
    private JButton loadVariantsButton;

    public VariantListNavigator(Frame owner) {
        super(owner);
        this.initComponents();
        this.setAlwaysOnTop(true);
        this.setLocation(owner.getBounds().width - 200, 50);
        this.refreshList();
    }

    private void refreshList() {
        VariantListEntry[] variantListArray = VariantListManager.variantList.toArray(new VariantListEntry[0]);
        this.variantList.setListData(variantListArray);
    }

    private void variantListValueChanged(ListSelectionEvent e2) {
        this.processVariant((VariantListEntry)this.variantList.getSelectedValue());
    }

    private void loadVariantsButtonActionPerformed(ActionEvent e2) {
        File variantListFile = FileDialogUtils.chooseFile("Import variant list");
        if (variantListFile != null) {
            try {
                VariantListManager.loadVariants(new ResourceLocator(variantListFile.getAbsolutePath()));
            }
            catch (IOException e1) {
                MessageUtils.showMessage("Error loading variant file: " + e2.toString());
            }
        }
        this.refreshList();
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.variantList = new JList();
        this.panel1 = new JPanel();
        this.loadVariantsButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.variantList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                VariantListNavigator.this.variantListValueChanged(e2);
            }
        });
        this.scrollPane1.setViewportView(this.variantList);
        contentPane.add((Component)this.scrollPane1, "Center");
        this.panel1.setLayout(null);
        this.loadVariantsButton.setText("Load variants...");
        this.loadVariantsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VariantListNavigator.this.loadVariantsButtonActionPerformed(e2);
            }
        });
        this.panel1.add(this.loadVariantsButton);
        this.loadVariantsButton.setBounds(new Rectangle(new Point(0, 0), this.loadVariantsButton.getPreferredSize()));
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.panel1.getComponentCount(); ++i2) {
            Rectangle bounds = this.panel1.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel1.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel1.setMinimumSize(preferredSize);
        this.panel1.setPreferredSize(preferredSize);
        contentPane.add((Component)this.panel1, "North");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) {
        new VariantListNavigator(null).setVisible(true);
    }

    void processVariant(final VariantListEntry variant) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.variantList.setEnabled(false);
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public String getName() {
                return "Process variant: " + variant.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
                    for (String sample : variant.samples) {
                        String path = VariantListManager.samplePathMap.get(sample);
                        if (path == null) {
                            MessageUtils.showMessage("Sample not found: " + sample);
                            continue;
                        }
                        locators.add(new ResourceLocator(path));
                    }
                    IGV.getInstance().resetSession(null);
                    IGV.getInstance().loadTracks(locators);
                }
                catch (Throwable throwable) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Genome genome = GenomeManager.getInstance().getCurrentGenome();
                            String chr = genome == null ? variant.chr : genome.getChromosomeAlias(variant.chr);
                            String locus = chr + ":" + variant.position;
                            IGV.getInstance().goToLocus(locus);
                            VariantListNavigator.this.setCursor(Cursor.getDefaultCursor());
                            VariantListNavigator.this.variantList.setEnabled(true);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    throw throwable;
                }
                Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                SwingUtilities.invokeLater(runnable);
            }
        };
        LongRunningTask.submit(runnable);
    }
}

