/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SSL3Mac;
import org.bouncycastle.crypto.tls.TlsClientContext;

class CombinedHash
implements Digest {
    protected TlsClientContext context;
    protected MD5Digest md5;
    protected SHA1Digest sha1;

    CombinedHash() {
        this.md5 = new MD5Digest();
        this.sha1 = new SHA1Digest();
    }

    CombinedHash(TlsClientContext context) {
        this.context = context;
        this.md5 = new MD5Digest();
        this.sha1 = new SHA1Digest();
    }

    CombinedHash(CombinedHash t2) {
        this.context = t2.context;
        this.md5 = new MD5Digest(t2.md5);
        this.sha1 = new SHA1Digest(t2.sha1);
    }

    public String getAlgorithmName() {
        return this.md5.getAlgorithmName() + " and " + this.sha1.getAlgorithmName();
    }

    public int getDigestSize() {
        return 36;
    }

    public void update(byte in) {
        this.md5.update(in);
        this.sha1.update(in);
    }

    public void update(byte[] in, int inOff, int len) {
        this.md5.update(in, inOff, len);
        this.sha1.update(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) {
        if (this.context != null) {
            boolean isTls;
            boolean bl = isTls = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
            if (!isTls) {
                this.ssl3Complete(this.md5, SSL3Mac.MD5_IPAD, SSL3Mac.MD5_OPAD);
                this.ssl3Complete(this.sha1, SSL3Mac.SHA1_IPAD, SSL3Mac.SHA1_OPAD);
            }
        }
        int i1 = this.md5.doFinal(out, outOff);
        int i2 = this.sha1.doFinal(out, outOff + 16);
        return i1 + i2;
    }

    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }

    protected void ssl3Complete(Digest d2, byte[] ipad, byte[] opad) {
        byte[] secret = this.context.getSecurityParameters().masterSecret;
        d2.update(secret, 0, secret.length);
        d2.update(ipad, 0, ipad.length);
        byte[] tmp = new byte[d2.getDigestSize()];
        d2.doFinal(tmp, 0);
        d2.update(secret, 0, secret.length);
        d2.update(opad, 0, opad.length);
        d2.update(tmp, 0, tmp.length);
    }
}

