/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class PKCS12ParametersGenerator
extends PBEParametersGenerator {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    private Digest digest;
    private int u;
    private int v;

    public PKCS12ParametersGenerator(Digest digest) {
        this.digest = digest;
        if (!(digest instanceof ExtendedDigest)) {
            throw new IllegalArgumentException("Digest " + digest.getAlgorithmName() + " unsupported");
        }
        this.u = digest.getDigestSize();
        this.v = ((ExtendedDigest)digest).getByteLength();
    }

    private void adjust(byte[] a2, int aOff, byte[] b2) {
        int x2 = (b2[b2.length - 1] & 0xFF) + (a2[aOff + b2.length - 1] & 0xFF) + 1;
        a2[aOff + b2.length - 1] = (byte)x2;
        x2 >>>= 8;
        for (int i2 = b2.length - 2; i2 >= 0; --i2) {
            a2[aOff + i2] = (byte)(x2 += (b2[i2] & 0xFF) + (a2[aOff + i2] & 0xFF));
            x2 >>>= 8;
        }
    }

    private byte[] generateDerivedKey(int idByte, int n2) {
        byte[] P;
        byte[] S;
        byte[] D = new byte[this.v];
        byte[] dKey = new byte[n2];
        for (int i2 = 0; i2 != D.length; ++i2) {
            D[i2] = (byte)idByte;
        }
        if (this.salt != null && this.salt.length != 0) {
            S = new byte[this.v * ((this.salt.length + this.v - 1) / this.v)];
            for (int i3 = 0; i3 != S.length; ++i3) {
                S[i3] = this.salt[i3 % this.salt.length];
            }
        } else {
            S = new byte[]{};
        }
        if (this.password != null && this.password.length != 0) {
            P = new byte[this.v * ((this.password.length + this.v - 1) / this.v)];
            for (int i4 = 0; i4 != P.length; ++i4) {
                P[i4] = this.password[i4 % this.password.length];
            }
        } else {
            P = new byte[]{};
        }
        byte[] I = new byte[S.length + P.length];
        System.arraycopy(S, 0, I, 0, S.length);
        System.arraycopy(P, 0, I, S.length, P.length);
        byte[] B = new byte[this.v];
        int c2 = (n2 + this.u - 1) / this.u;
        for (int i5 = 1; i5 <= c2; ++i5) {
            int j2;
            byte[] A = new byte[this.u];
            this.digest.update(D, 0, D.length);
            this.digest.update(I, 0, I.length);
            this.digest.doFinal(A, 0);
            for (j2 = 1; j2 < this.iterationCount; ++j2) {
                this.digest.update(A, 0, A.length);
                this.digest.doFinal(A, 0);
            }
            for (j2 = 0; j2 != B.length; ++j2) {
                B[j2] = A[j2 % A.length];
            }
            for (j2 = 0; j2 != I.length / this.v; ++j2) {
                this.adjust(I, j2 * this.v, B);
            }
            if (i5 == c2) {
                System.arraycopy(A, 0, dKey, (i5 - 1) * this.u, dKey.length - (i5 - 1) * this.u);
                continue;
            }
            System.arraycopy(A, 0, dKey, (i5 - 1) * this.u, A.length);
        }
        return dKey;
    }

    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] dKey = this.generateDerivedKey(1, keySize /= 8);
        return new KeyParameter(dKey, 0, keySize);
    }

    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[] dKey = this.generateDerivedKey(1, keySize /= 8);
        byte[] iv = this.generateDerivedKey(2, ivSize /= 8);
        return new ParametersWithIV(new KeyParameter(dKey, 0, keySize), iv, 0, ivSize);
    }

    public CipherParameters generateDerivedMacParameters(int keySize) {
        byte[] dKey = this.generateDerivedKey(3, keySize /= 8);
        return new KeyParameter(dKey, 0, keySize);
    }
}

