/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;

public class DSAParameter
extends ASN1Object {
    ASN1Integer p;
    ASN1Integer q;
    ASN1Integer g;

    public static DSAParameter getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DSAParameter.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DSAParameter getInstance(Object obj) {
        if (obj == null || obj instanceof DSAParameter) {
            return (DSAParameter)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new DSAParameter((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid DSAParameter: " + obj.getClass().getName());
    }

    public DSAParameter(BigInteger p2, BigInteger q2, BigInteger g2) {
        this.p = new ASN1Integer(p2);
        this.q = new ASN1Integer(q2);
        this.g = new ASN1Integer(g2);
    }

    public DSAParameter(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration e2 = seq.getObjects();
        this.p = ASN1Integer.getInstance(e2.nextElement());
        this.q = ASN1Integer.getInstance(e2.nextElement());
        this.g = ASN1Integer.getInstance(e2.nextElement());
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.p);
        v2.add(this.q);
        v2.add(this.g);
        return new DERSequence(v2);
    }
}

