/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.vsnet.VsnetJideTabbedPaneUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class Eclipse3xJideTabbedPaneUI
extends VsnetJideTabbedPaneUI {
    protected int _closeButtonMargin;
    protected int _closeButtonMarginSize;
    protected int _iconMarginHorizon;
    protected int _iconMarginVertical;

    public static ComponentUI createUI(JComponent c2) {
        return new Eclipse3xJideTabbedPaneUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        this._rectSizeExtend = 12;
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this._tabPane, "JideTabbedPane.border");
        this._closeButtonMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMargin");
        this._closeButtonMarginSize = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginSize");
        this._iconMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.iconMarginHorizon");
        this._iconMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.iconMarginVertical");
    }

    public void paintBackground(Graphics g2, Component c2) {
        if (this.getTabShape() == 7) {
            if (this._tabPane.isOpaque()) {
                int width = c2.getWidth();
                int height = c2.getHeight();
                int temp1 = -1;
                int temp2 = -1;
                if (this.isTabLeadingComponentVisible()) {
                    if (height < this._tabLeadingComponent.getSize().height) {
                        height = this._tabLeadingComponent.getSize().height;
                        temp1 = this._tabLeadingComponent.getSize().height;
                    }
                    if (width < this._tabLeadingComponent.getSize().width) {
                        width = this._tabLeadingComponent.getSize().width;
                        temp2 = this._tabLeadingComponent.getSize().width;
                    }
                }
                if (this.isTabTrailingComponentVisible()) {
                    if (height < this._tabTrailingComponent.getSize().height && temp1 < this._tabTrailingComponent.getSize().height) {
                        height = this._tabTrailingComponent.getSize().height;
                    }
                    if (width < this._tabTrailingComponent.getSize().width && temp2 < this._tabTrailingComponent.getSize().width) {
                        width = this._tabTrailingComponent.getSize().width;
                    }
                }
                g2.setColor(this._background);
                g2.fillRect(0, 0, width, height);
            }
        } else {
            super.paintBackground(g2, c2);
        }
    }

    protected void ensureCurrentLayout() {
        if (!this._tabPane.isValid()) {
            BasicJideTabbedPaneUI.TabbedPaneLayout layout = (BasicJideTabbedPaneUI.TabbedPaneLayout)this._tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
        if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
            for (int i2 = 0; i2 < this._closeButtons.length; ++i2) {
                Rectangle bounds;
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (i2 != this._tabPane.getSelectedIndex()) {
                        this._closeButtons[i2].setBounds(0, 0, 0, 0);
                        continue;
                    }
                } else if (i2 >= this._rects.length) {
                    this._closeButtons[i2].setBounds(0, 0, 0, 0);
                    continue;
                }
                if (!this._tabPane.isTabClosableAt(i2)) {
                    this._closeButtons[i2].setBounds(0, 0, 0, 0);
                    continue;
                }
                Dimension size = this._closeButtons[i2].getPreferredSize();
                if (this._closeButtonAlignment == 11) {
                    bounds = this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3 ? (this._tabPane.getComponentOrientation().isLeftToRight() ? new Rectangle(this._rects[i2].x + this._rects[i2].width - size.width - 16, this._rects[i2].y + (this._rects[i2].height - size.height >> 1), size.width, size.height) : new Rectangle(this._rects[i2].x + 4, this._rects[i2].height - size.height >> 1, size.width, size.height)) : (this._tabPane.getTabPlacement() == 2 ? new Rectangle(this._rects[i2].x + (this._rects[i2].width - size.width >> 1), this._rects[i2].y + this._rects[i2].height - size.height - 16, size.width, size.height) : new Rectangle(this._rects[i2].x + (this._rects[i2].width - size.width >> 1), this._rects[i2].y + this._rects[i2].height - size.height - 16, size.width, size.height));
                } else {
                    bounds = new Rectangle(this._rects[i2].x + 4, this._rects[i2].height - size.height >> 1, size.width, size.height);
                    if (!(this._tabPane.getComponentOrientation().isLeftToRight() || this._tabPane.getTabPlacement() != 1 && this._tabPane.getTabPlacement() != 3)) {
                        bounds = new Rectangle(this._rects[i2].x + this._rects[i2].width - size.width - 16, this._rects[i2].y + (this._rects[i2].height - size.height >> 1), size.width, size.height);
                    }
                }
                if (this._closeButtons[i2] instanceof JideTabbedPane.NoFocusButton) {
                    ((JideTabbedPane.NoFocusButton)this._closeButtons[i2]).setIndex(i2);
                }
                if (!bounds.equals(this._closeButtons[i2].getBounds())) {
                    this._closeButtons[i2].setBounds(bounds);
                }
                if (this._tabPane.getSelectedIndex() == i2) {
                    this._closeButtons[i2].setBackground(this._selectedColor == null ? this._tabPane.getBackgroundAt(i2) : this._selectedColor);
                    continue;
                }
                this._closeButtons[i2].setBackground(this._tabPane.getBackgroundAt(i2));
            }
        }
    }

    protected void paintTabArea(Graphics g2, int tabPlacement, int selectedIndex, Component c2) {
        if (this.getTabShape() == 7) {
            int tabCount = this._tabPane.getTabCount();
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            Rectangle clipRect = g2.getClipBounds();
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            if (this._tabPane.isOpaque()) {
                g2.setColor(this._tabBackground);
                g2.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            }
            for (int i2 = this._runCount - 1; i2 >= 0; --i2) {
                int start = this._tabRuns[i2];
                int next = this._tabRuns[i2 == this._runCount - 1 ? 0 : i2 + 1];
                int end = next != 0 ? next - 1 : tabCount - 1;
                for (int j2 = start; j2 <= end; ++j2) {
                    if (!this._rects[j2].intersects(clipRect)) continue;
                    this.paintTab(g2, tabPlacement, this._rects, j2, iconRect, textRect);
                }
            }
            if (selectedIndex >= 0 && this.getRunForTab(tabCount, selectedIndex) == 0 && this._rects[selectedIndex].intersects(clipRect)) {
                this.paintTab(g2, tabPlacement, this._rects, selectedIndex, iconRect, textRect);
            }
            if (this._tabPane.isOpaque()) {
                g2.setColor(this._shadow);
                switch (tabPlacement) {
                    case 2: {
                        if (!this.isTabLeadingComponentVisible()) {
                            g2.fillRect(viewRect.x, viewRect.y + 3, 1, 2);
                            g2.fillRect(viewRect.x + 1, viewRect.y + 2, 1, 1);
                            g2.fillRect(viewRect.x + 2, viewRect.y + 1, 1, 1);
                            g2.fillRect(viewRect.x + 3, viewRect.y, 2, 1);
                        }
                        if (this.isNoneTabTrailingComponentVisible()) {
                            g2.fillRect(viewRect.x + 3, viewRect.y + viewRect.height - 1, 2, 1);
                            g2.fillRect(viewRect.x + 2, viewRect.y + viewRect.height - 2, 1, 1);
                            g2.fillRect(viewRect.x + 1, viewRect.y + viewRect.height - 3, 1, 1);
                            g2.fillRect(viewRect.x, viewRect.y + viewRect.height - 5, 1, 2);
                        }
                        g2.setColor(this._tabBackground);
                        g2.fillRect(viewRect.x, viewRect.y, 3, 1);
                        g2.fillRect(viewRect.x, viewRect.y + 1, 2, 1);
                        g2.fillRect(viewRect.x, viewRect.y + 2, 1, 1);
                        break;
                    }
                    case 4: {
                        if (!this.isTabLeadingComponentVisible()) {
                            g2.fillRect(viewRect.x + viewRect.width - 5, viewRect.y, 2, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 3, viewRect.y + 1, 1, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + 2, 1, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + 3, 1, 2);
                        }
                        if (this.isNoneTabTrailingComponentVisible()) {
                            g2.fillRect(viewRect.x + viewRect.width - 5, viewRect.y + viewRect.height - 1, 2, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 3, viewRect.y + viewRect.height - 2, 1, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + viewRect.height - 3, 1, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + viewRect.height - 5, 1, 2);
                        }
                        g2.setColor(this._tabBackground);
                        g2.fillRect(viewRect.x + viewRect.width - 3, viewRect.y, 3, 1);
                        g2.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + 1, 2, 1);
                        g2.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + 2, 1, 1);
                        break;
                    }
                    case 3: {
                        if (!this.isTabLeadingComponentVisible()) {
                            g2.fillRect(viewRect.x + 3, viewRect.y + viewRect.height - 1, 2, 1);
                            g2.fillRect(viewRect.x + 2, viewRect.y + viewRect.height - 2, 1, 1);
                            g2.fillRect(viewRect.x + 1, viewRect.y + viewRect.height - 3, 1, 1);
                            g2.fillRect(viewRect.x, viewRect.y + viewRect.height - 5, 1, 2);
                        }
                        if (this.isNoneTabTrailingComponentVisible()) {
                            g2.fillRect(viewRect.x + viewRect.width - 5, viewRect.y + viewRect.height - 1, 2, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 3, viewRect.y + viewRect.height - 2, 1, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + viewRect.height - 3, 1, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + viewRect.height - 5, 1, 2);
                        }
                        g2.setColor(this._tabBackground);
                        g2.fillRect(viewRect.x, viewRect.y + viewRect.height - 1, 3, 1);
                        g2.fillRect(viewRect.x, viewRect.y + viewRect.height - 2, 2, 1);
                        g2.fillRect(viewRect.x, viewRect.y + viewRect.height - 3, 1, 1);
                        break;
                    }
                    default: {
                        if (!this.isTabLeadingComponentVisible()) {
                            g2.fillRect(viewRect.x + 3, viewRect.y, 2, 1);
                            g2.fillRect(viewRect.x + 2, viewRect.y + 1, 1, 1);
                            g2.fillRect(viewRect.x + 1, viewRect.y + 2, 1, 1);
                            g2.fillRect(viewRect.x, viewRect.y + 3, 1, 2);
                        }
                        if (this.isNoneTabTrailingComponentVisible()) {
                            g2.fillRect(viewRect.x + viewRect.width - 5, viewRect.y, 2, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 3, viewRect.y + 1, 1, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + 2, 1, 1);
                            g2.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + 3, 1, 2);
                        }
                        g2.setColor(this._tabBackground);
                        g2.fillRect(viewRect.x, viewRect.y, 3, 1);
                        g2.fillRect(viewRect.x, viewRect.y + 1, 2, 1);
                        g2.fillRect(viewRect.x, viewRect.y + 2, 1, 1);
                    }
                }
            }
        } else {
            super.paintTabArea(g2, tabPlacement, selectedIndex, c2);
        }
    }

    private boolean isNoneTabTrailingComponentVisible() {
        return !this._tabScroller.scrollForwardButton.isVisible() && !this._tabScroller.scrollBackwardButton.isVisible() && !this._tabScroller.closeButton.isVisible() && !this.isTabTrailingComponentVisible();
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v2 = this.getTextViewForTab(tabIndex);
        if (v2 != null) {
            this._tabPane.putClientProperty("html", v2);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this._textIconGap);
        this._tabPane.putClientProperty("html", null);
        if (tabPlacement == 1 || tabPlacement == 3) {
            iconRect.x = tabRect.x + this._iconMarginHorizon;
            textRect.x = icon != null ? iconRect.x + iconRect.width + this._textIconGap : tabRect.x + this._textPadding;
            iconRect.width = Math.min(iconRect.width, tabRect.width - this._tabRectPadding);
            textRect.width = tabRect.width - this._tabRectPadding - iconRect.width - (icon != null ? this._textIconGap : this._noIconMargin);
            if (this.getTabResizeMode() == 2 || this._tabPane.getTabResizeMode() == 3) {
                textRect.width -= 10;
                if (this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
                    if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                        if (isSelected) {
                            textRect.width -= this._closeButtons[tabIndex].getPreferredSize().width;
                        }
                    } else {
                        textRect.width -= this._closeButtons[tabIndex].getPreferredSize().width;
                    }
                }
            } else if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !isSelected) {
                iconRect.width = iconRect.width + this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonMarginSize;
                textRect.width = 0;
            }
        } else {
            iconRect.y = tabRect.y + this._iconMarginVertical;
            textRect.y = icon != null ? iconRect.y + iconRect.height + this._textIconGap : tabRect.y + this._textPadding;
            iconRect.x = tabRect.x + 3;
            textRect.x = tabRect.x + 3;
            textRect.width = tabRect.width - this._textMarginVertical;
            textRect.height = tabRect.height - this._tabRectPadding - iconRect.height - (icon != null ? this._textIconGap : this._noIconMargin);
            if (this.getTabResizeMode() == 2 || this._tabPane.getTabResizeMode() == 3) {
                textRect.height -= 10;
                if (this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
                    if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                        if (isSelected) {
                            textRect.height -= this._closeButtons[tabIndex].getPreferredSize().height;
                        }
                    } else {
                        textRect.height -= this._closeButtons[tabIndex].getPreferredSize().height;
                    }
                }
            } else if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !isSelected) {
                iconRect.height = iconRect.height + this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonMarginSize;
                textRect.height = 0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void paintTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x2, int y, int w2, int h2, boolean isSelected) {
        if (this.getTabShape() == 7) {
            g2.setColor(this._lightHighlight);
            boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
            switch (tabPlacement) {
                case 2: {
                    if (!this.isTabLeadingComponentVisible()) {
                        --y;
                    }
                    if (isSelected) {
                        g2.setColor(this._shadow);
                        g2.drawLine(x2 + 5, y, x2 + w2 - 1, y);
                        g2.drawLine(x2 + 4, y + 1, x2 + 3, y + 1);
                        g2.drawLine(x2 + 2, y + 2, x2 + 2, y + 2);
                        g2.drawLine(x2 + 1, y + 3, x2 + 1, y + 3);
                        g2.drawLine(x2, y + 4, x2, y + 5);
                        if (this.isTabTopVisible(tabPlacement)) {
                            g2.drawLine(x2, y + 5, x2, y + h2 - 21);
                        }
                        g2.drawLine(x2, y + h2 - 21, x2, y + h2 - 19);
                        g2.drawLine(x2 + 1, y + h2 - 18, x2 + 1, y + h2 - 16);
                        g2.drawLine(x2 + 2, y + h2 - 15, x2 + 2, y + h2 - 14);
                        g2.drawLine(x2 + 3, y + h2 - 13, x2 + 3, y + h2 - 13);
                        g2.drawLine(x2 + 4, y + h2 - 12, x2 + 4, y + h2 - 11);
                        for (int i2 = 0; i2 < w2 - 10; ++i2) {
                            g2.drawLine(x2 + 5 + i2, y + h2 - 10 + i2, x2 + 5 + i2, y + h2 - 10 + i2);
                        }
                        g2.drawLine(x2 + w2 - 5, y + h2 + w2 - 20, x2 + w2 - 5, y + h2 + w2 - 19);
                        g2.drawLine(x2 + w2 - 4, y + h2 + w2 - 18, x2 + w2 - 4, y + h2 + w2 - 18);
                        g2.drawLine(x2 + w2 - 3, y + h2 + w2 - 17, x2 + w2 - 3, y + h2 + w2 - 16);
                        g2.drawLine(x2 + w2 - 2, y + h2 + w2 - 15, x2 + w2 - 2, y + h2 + w2 - 13);
                        g2.drawLine(x2 + w2 - 1, y + h2 + w2 - 12, x2 + w2 - 1, y + h2 + w2 - 10);
                        if (this.isTabLeadingComponentVisible()) return;
                        ++y;
                        return;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.setColor(this._shadow);
                        g2.drawLine(x2, y + h2 - 1, x2 + w2 - 1, y + h2 - 1);
                        return;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) return;
                    if (tabIndex == 0) return;
                    g2.setColor(this._shadow);
                    g2.drawLine(x2, y - 1, x2 + w2 - 1, y - 1);
                    return;
                }
                case 4: {
                    if (!this.isTabLeadingComponentVisible()) {
                        --y;
                    }
                    if (isSelected) {
                        g2.setColor(this._shadow);
                        g2.drawLine(x2, y, x2 + w2 - 6, y);
                        g2.drawLine(x2 + w2 - 5, y + 1, x2 + w2 - 4, y + 1);
                        g2.drawLine(x2 + w2 - 3, y + 2, x2 + w2 - 3, y + 2);
                        g2.drawLine(x2 + w2 - 2, y + 3, x2 + w2 - 2, y + 3);
                        g2.drawLine(x2 + w2 - 1, y + 4, x2 + w2 - 1, y + 5);
                        if (this.isTabTopVisible(tabPlacement)) {
                            g2.drawLine(x2 + w2 - 1, y + 5, x2 + w2 - 1, y + h2 - 21);
                        }
                        g2.drawLine(x2 + w2 - 1, y + h2 - 21, x2 + w2 - 1, y + h2 - 19);
                        g2.drawLine(x2 + w2 - 2, y + h2 - 18, x2 + w2 - 2, y + h2 - 16);
                        g2.drawLine(x2 + w2 - 3, y + h2 - 15, x2 + w2 - 3, y + h2 - 14);
                        g2.drawLine(x2 + w2 - 4, y + h2 - 13, x2 + w2 - 4, y + h2 - 13);
                        g2.drawLine(x2 + w2 - 5, y + h2 - 12, x2 + w2 - 5, y + h2 - 11);
                        for (int i3 = 0; i3 < w2 - 10; ++i3) {
                            g2.drawLine(x2 + w2 - 6 - i3, y + h2 - 10 + i3, x2 + w2 - 6 - i3, y + h2 - 10 + i3);
                        }
                        g2.drawLine(x2 + 4, y + h2 + w2 - 20, x2 + 4, y + h2 + w2 - 19);
                        g2.drawLine(x2 + 3, y + h2 + w2 - 18, x2 + 3, y + h2 + w2 - 18);
                        g2.drawLine(x2 + 2, y + h2 + w2 - 17, x2 + 2, y + h2 + w2 - 16);
                        g2.drawLine(x2 + 1, y + h2 + w2 - 15, x2 + 1, y + h2 + w2 - 13);
                        g2.drawLine(x2, y + h2 + w2 - 12, x2, y + h2 + w2 - 10);
                        return;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.setColor(this._shadow);
                        g2.drawLine(x2, y + h2 - 1, x2 + w2 - 1, y + h2 - 1);
                        return;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) return;
                    if (tabIndex == 0) return;
                    g2.setColor(this._shadow);
                    g2.drawLine(x2, y - 1, x2 + w2 - 1, y - 1);
                    return;
                }
                case 3: {
                    if (!this.isTabLeadingComponentVisible()) {
                        --x2;
                    }
                    if (isSelected) {
                        g2.setColor(this._shadow);
                        g2.drawLine(x2, y + h2 - 6, x2, y);
                        g2.drawLine(x2 + 1, y + h2 - 5, x2 + 1, y + h2 - 4);
                        g2.drawLine(x2 + 2, y + h2 - 3, x2 + 2, y + h2 - 3);
                        g2.drawLine(x2 + 3, y + h2 - 2, x2 + 3, y + h2 - 2);
                        g2.drawLine(x2 + 4, y + h2 - 1, x2 + 5, y + h2 - 1);
                        if (this.isTabTopVisible(tabPlacement)) {
                            g2.drawLine(x2 + 5, y + h2 - 1, x2 + w2 - 20, y + h2 - 1);
                        }
                        g2.drawLine(x2 + w2 - 20, y + h2 - 1, x2 + w2 - 18, y + h2 - 1);
                        g2.drawLine(x2 + w2 - 17, y + h2 - 2, x2 + w2 - 15, y + h2 - 2);
                        g2.drawLine(x2 + w2 - 14, y + h2 - 3, x2 + w2 - 13, y + h2 - 3);
                        g2.drawLine(x2 + w2 - 12, y + h2 - 4, x2 + w2 - 12, y + h2 - 4);
                        g2.drawLine(x2 + w2 - 11, y + h2 - 5, x2 + w2 - 10, y + h2 - 5);
                        for (int i4 = 0; i4 < h2 - 10; ++i4) {
                            g2.drawLine(x2 + w2 - 9 + i4, y + h2 - 6 - i4, x2 + w2 - 9 + i4, y + h2 - 6 - i4);
                        }
                        g2.drawLine(x2 + w2 + h2 - 19, y + 4, x2 + w2 + h2 - 18, y + 4);
                        g2.drawLine(x2 + w2 + h2 - 17, y + 3, x2 + w2 + h2 - 17, y + 3);
                        g2.drawLine(x2 + w2 + h2 - 16, y + 2, x2 + w2 + h2 - 15, y + 2);
                        g2.drawLine(x2 + w2 + h2 - 14, y + 1, x2 + w2 + h2 - 12, y + 1);
                        g2.drawLine(x2 + w2 + h2 - 11, y, x2 + w2 + h2 - 9, y);
                        return;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.setColor(this._shadow);
                        if (leftToRight) {
                            g2.drawLine(x2 + w2 - 2, y - 1, x2 + w2 - 2, y + h2);
                            return;
                        }
                        g2.drawLine(x2, y - 1, x2, y + h2);
                        return;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) return;
                    if (tabIndex == 0) return;
                    g2.setColor(this._shadow);
                    if (leftToRight) {
                        g2.drawLine(x2, y - 1, x2, y + h2);
                        return;
                    }
                    g2.drawLine(x2 + w2 - 2, y - 1, x2 + w2 - 2, y + h2);
                    return;
                }
                default: {
                    if (!this.isTabLeadingComponentVisible()) {
                        --x2;
                    }
                    if (isSelected) {
                        g2.setColor(this._shadow);
                        g2.drawLine(x2, y + 5, x2, y + h2);
                        g2.drawLine(x2 + 4, y, x2 + 5, y);
                        g2.drawLine(x2 + 3, y + 1, x2 + 3, y + 1);
                        g2.drawLine(x2 + 2, y + 2, x2 + 2, y + 2);
                        g2.drawLine(x2 + 1, y + 3, x2 + 1, y + 4);
                        if (this.isTabTopVisible(tabPlacement)) {
                            g2.drawLine(x2 + 5, y, x2 + w2 - 20, y);
                        }
                        g2.drawLine(x2 + w2 - 20, y, x2 + w2 - 18, y);
                        g2.drawLine(x2 + w2 - 17, y + 1, x2 + w2 - 15, y + 1);
                        g2.drawLine(x2 + w2 - 14, y + 2, x2 + w2 - 13, y + 2);
                        g2.drawLine(x2 + w2 - 12, y + 3, x2 + w2 - 12, y + 3);
                        g2.drawLine(x2 + w2 - 11, y + 4, x2 + w2 - 10, y + 4);
                        for (int i5 = 0; i5 < h2 - 10; ++i5) {
                            g2.drawLine(x2 + w2 - 9 + i5, y + 5 + i5, x2 + w2 - 9 + i5, y + 5 + i5);
                        }
                        g2.drawLine(x2 + w2 + h2 - 19, y + h2 - 5, x2 + w2 + h2 - 18, y + h2 - 5);
                        g2.drawLine(x2 + w2 + h2 - 17, y + h2 - 4, x2 + w2 + h2 - 17, y + h2 - 4);
                        g2.drawLine(x2 + w2 + h2 - 16, y + h2 - 3, x2 + w2 + h2 - 15, y + h2 - 3);
                        g2.drawLine(x2 + w2 + h2 - 14, y + h2 - 2, x2 + w2 + h2 - 12, y + h2 - 2);
                        g2.drawLine(x2 + w2 + h2 - 11, y + h2 - 1, x2 + w2 + h2 - 9, y + h2 - 1);
                        return;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.setColor(this._shadow);
                        if (leftToRight) {
                            g2.drawLine(x2 + w2 - 2, y, x2 + w2 - 2, y + (h2 - 1));
                            return;
                        }
                        g2.drawLine(x2, y, x2, y + (h2 - 1));
                        return;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) return;
                    if (tabIndex == 0) return;
                    g2.setColor(this._shadow);
                    if (leftToRight) {
                        g2.drawLine(x2, y, x2, y + (h2 - 1));
                        return;
                    }
                    g2.drawLine(x2 + w2 - 2, y, x2 + w2 - 2, y + (h2 - 1));
                }
            }
            return;
        } else {
            super.paintTabBorder(g2, tabPlacement, tabIndex, x2, y, w2, h2, isSelected);
        }
    }

    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x2, int y, int w2, int h2, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        if (this.getTabShape() == 7) {
            Color background2;
            Color background1;
            Graphics2D g2d = (Graphics2D)g2;
            if (this.showFocusIndicator()) {
                background1 = this._activeBackground;
                background2 = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground2");
            } else {
                background1 = this._activeBackground;
                background2 = this._background;
            }
            switch (tabPlacement) {
                case 2: {
                    if (!this.isTabLeadingComponentVisible()) {
                        // empty if block
                    }
                    int[] xp = new int[]{x2 + w2, x2 + 5, x2, x2, x2 + 6, x2 + w2 - 6, x2 + w2};
                    int[] yp = new int[]{--y, y, y + 4, y + h2 - 19, y + h2 - 8, y + h2 + w2 - 21, y + h2 + w2 - 10};
                    int np = yp.length;
                    Polygon p2 = new Polygon(xp, yp, np);
                    JideSwingUtilities.fillGradient(g2d, p2, background1, background2, false);
                    break;
                }
                case 4: {
                    if (!this.isTabLeadingComponentVisible()) {
                        // empty if block
                    }
                    int[] xp = new int[]{x2, x2 + w2 - 6, x2 + w2, x2 + w2, x2 + w2 - 5, x2 + 5, x2};
                    int[] yp = new int[]{--y, y, y + 4, y + h2 - 21, y + h2 - 10, y + h2 + w2 - 21, y + h2 + w2 - 10};
                    int np = yp.length;
                    Polygon p3 = new Polygon(xp, yp, np);
                    JideSwingUtilities.fillGradient(g2d, p3, background2, background1, false);
                    break;
                }
                case 3: {
                    if (!this.isTabLeadingComponentVisible()) {
                        // empty if block
                    }
                    int[] xp = new int[]{--x2, x2, x2 + 6, x2 + w2 - 20, x2 + w2 - 16, x2 + w2 - 14, x2 + w2 - 12, x2 + w2 - 9, x2 + w2 + h2 - 19, x2 + w2 + h2 - 10, x2 + w2 + h2 - 12};
                    int[] yp = new int[]{y, y + h2 - 6, y + h2, y + h2, y + h2 - 2, y + h2 - 3, y + h2 - 4, y + h2 - 6, y + 4, y + 1, y};
                    int np = yp.length;
                    Polygon p4 = new Polygon(xp, yp, np);
                    JideSwingUtilities.fillGradient(g2d, p4, background2, background1, true);
                    break;
                }
                default: {
                    if (!this.isTabLeadingComponentVisible()) {
                        // empty if block
                    }
                    int[] xp = new int[]{--x2, x2, x2 + 2, x2 + 3, x2 + 6, x2 + w2 - 20, x2 + w2 - 14, x2 + w2 - 12, x2 + w2 - 9, x2 + w2 + h2 - 20, x2 + w2 + h2 - 9};
                    int[] yp = new int[]{y + h2, y + 5, y + 2, y + 1, y, y, y + 2, y + 3, y + 5, y + h2 - 6, y + h2};
                    int np = xp.length;
                    Polygon p5 = new Polygon(xp, yp, np);
                    JideSwingUtilities.fillGradient(g2d, p5, background1, background2, true);
                    break;
                }
            }
        } else {
            super.paintTabBackground(g2, tabPlacement, tabIndex, x2, y, w2, h2, isSelected);
        }
    }

    protected void paintContentBorder(Graphics g2, int tabPlacement, int selectedIndex) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            int width = this._tabPane.getWidth();
            int height = this._tabPane.getHeight();
            Insets insets = this._tabPane.getInsets();
            int x2 = insets.left;
            int y = insets.top;
            int w2 = width - insets.right - insets.left;
            int h2 = height - insets.top - insets.bottom;
            int temp = -1;
            switch (tabPlacement) {
                case 2: {
                    x2 += this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                    if (this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getSize().width > this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth)) {
                        x2 = insets.left + this._tabLeadingComponent.getSize().width;
                        temp = this._tabLeadingComponent.getSize().width;
                    }
                    if (this.isTabTrailingComponentVisible() && this._maxTabWidth < this._tabTrailingComponent.getSize().width && temp < this._tabTrailingComponent.getSize().width) {
                        x2 = insets.left + this._tabTrailingComponent.getSize().width;
                    }
                    w2 -= x2 - insets.left;
                    break;
                }
                case 4: {
                    w2 -= this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                    break;
                }
                case 3: {
                    h2 -= this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                    break;
                }
                default: {
                    y += this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                    if (this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getSize().height > this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight)) {
                        y = insets.top + this._tabLeadingComponent.getSize().height;
                        temp = this._tabLeadingComponent.getSize().height;
                    }
                    if (this.isTabTrailingComponentVisible() && this._maxTabHeight < this._tabTrailingComponent.getSize().height && temp < this._tabTrailingComponent.getSize().height) {
                        y = insets.top + this._tabTrailingComponent.getSize().height;
                    }
                    h2 -= y - insets.top;
                }
            }
            this.paintContentBorder(g2, x2, y, w2, h2);
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r2 = this._rects[selectedIndex];
            Rectangle button = this._tabScroller.scrollForwardButton.getBounds();
            Rectangle panel = this._tabScroller.tabPanel.getBounds();
            int lsize = 0;
            if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                if (this.isTabLeadingComponentVisible()) {
                    lsize = this._tabLeadingComponent.getSize().width;
                }
            } else if (this.isTabLeadingComponentVisible()) {
                lsize = this._tabLeadingComponent.getSize().height;
            }
            switch (tabPlacement) {
                case 2: {
                    if (r2.y < viewRect.y + viewRect.height && r2.y + r2.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 > viewRect.y + viewRect.height) {
                        if (selectedIndex != this._tabPane.getTabCount() - 1) {
                            viewRect.y += r2.y + r2.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 - (viewRect.y + viewRect.height);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else if (panel.y + panel.height + lsize > button.y) {
                            viewRect.y += r2.y + r2.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 - (viewRect.y + viewRect.height);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else {
                            this._tabScroller.viewport.setSize(viewRect.width, viewRect.height + this.getLayoutSize());
                        }
                    }
                    this.paintContentBorderLeftEdge(g2, tabPlacement, selectedIndex, x2, y, w2, h2);
                    break;
                }
                case 4: {
                    if (r2.y < viewRect.y + viewRect.height && r2.y + r2.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 > viewRect.y + viewRect.height) {
                        if (selectedIndex != this._tabPane.getTabCount() - 1) {
                            viewRect.y += r2.y + r2.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 - (viewRect.y + viewRect.height);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else if (panel.y + panel.height + lsize > button.y) {
                            viewRect.y += r2.y + r2.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 - (viewRect.y + viewRect.height);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else {
                            this._tabScroller.viewport.setSize(viewRect.width, viewRect.height + this.getLayoutSize());
                        }
                    }
                    this.paintContentBorderRightEdge(g2, tabPlacement, selectedIndex, x2, y, w2, h2);
                    break;
                }
                case 3: {
                    if (r2.x < viewRect.x + viewRect.width && r2.x + r2.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 > viewRect.x + viewRect.width) {
                        if (selectedIndex != this._tabPane.getTabCount() - 1) {
                            viewRect.x += r2.x + r2.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 - (viewRect.x + viewRect.width);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else if (panel.x + panel.width + lsize > button.x) {
                            viewRect.x += r2.x + r2.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 - (viewRect.x + viewRect.width);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else {
                            this._tabScroller.viewport.setSize(viewRect.width + this.getLayoutSize(), viewRect.height);
                        }
                    }
                    this.paintContentBorderBottomEdge(g2, tabPlacement, selectedIndex, x2, y, w2, h2);
                    break;
                }
                default: {
                    if (r2.x < viewRect.x + viewRect.width && r2.x + r2.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 > viewRect.x + viewRect.width) {
                        if (selectedIndex != this._tabPane.getTabCount() - 1) {
                            viewRect.x += r2.x + r2.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 - (viewRect.x + viewRect.width);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else if (panel.x + panel.width + lsize > button.x) {
                            viewRect.x += r2.x + r2.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 - (viewRect.x + viewRect.width);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else {
                            this._tabScroller.viewport.setSize(viewRect.width + this.getLayoutSize(), viewRect.height);
                        }
                    }
                    this.paintContentBorderTopEdge(g2, tabPlacement, selectedIndex, x2, y, w2, h2);
                }
            }
            g2.setColor(this._shadow);
            if (this._tabPane.isTabShown()) {
                switch (tabPlacement) {
                    case 2: {
                        g2.drawLine(width - 1, 0, width - 1, height - 1);
                        g2.drawLine(6, 0, width - 1, 0);
                        g2.drawLine(6, height - 1, width - 1, height - 1);
                        g2.drawLine(0, 6, 0, height - 7);
                        g2.drawLine(1, height - 6, 1, height - 5);
                        g2.drawLine(2, height - 4, 2, height - 4);
                        g2.drawLine(3, height - 3, 3, height - 3);
                        g2.drawLine(4, height - 2, 5, height - 2);
                        g2.drawLine(4, 1, 5, 1);
                        g2.drawLine(3, 2, 3, 2);
                        g2.drawLine(2, 3, 2, 3);
                        g2.drawLine(1, 4, 1, 5);
                        break;
                    }
                    case 4: {
                        g2.drawLine(0, 0, 0, height - 1);
                        g2.drawLine(0, 0, width - 7, 0);
                        g2.drawLine(0, height - 1, width - 7, height - 1);
                        g2.drawLine(width - 1, 6, width - 1, height - 7);
                        g2.drawLine(width - 2, height - 6, width - 2, height - 5);
                        g2.drawLine(width - 3, height - 4, width - 3, height - 4);
                        g2.drawLine(width - 4, height - 3, width - 4, height - 3);
                        g2.drawLine(width - 5, height - 2, width - 6, height - 2);
                        g2.drawLine(width - 6, 1, width - 5, 1);
                        g2.drawLine(width - 4, 2, width - 4, 2);
                        g2.drawLine(width - 3, 3, width - 3, 3);
                        g2.drawLine(width - 2, 4, width - 2, 5);
                        break;
                    }
                    case 3: {
                        g2.drawLine(0, 0, width - 1, 0);
                        g2.drawLine(0, 0, 0, height - 7);
                        g2.drawLine(width - 1, 0, width - 1, height - 7);
                        g2.drawLine(6, height - 1, width - 7, height - 1);
                        g2.drawLine(width - 6, height - 2, width - 5, height - 2);
                        g2.drawLine(width - 4, height - 3, width - 4, height - 3);
                        g2.drawLine(width - 3, height - 4, width - 3, height - 4);
                        g2.drawLine(width - 2, height - 5, width - 2, height - 6);
                        g2.drawLine(1, height - 6, 1, height - 5);
                        g2.drawLine(2, height - 4, 2, height - 4);
                        g2.drawLine(3, height - 3, 3, height - 3);
                        g2.drawLine(4, height - 2, 5, height - 2);
                        break;
                    }
                    default: {
                        g2.drawLine(6, 0, width - 7, 0);
                        g2.drawLine(0, height - 1, width - 1, height - 1);
                        g2.drawLine(width - 1, 6, width - 1, height - 1);
                        g2.drawLine(0, 6, 0, height - 1);
                        g2.drawLine(width - 6, 1, width - 5, 1);
                        g2.drawLine(width - 4, 2, width - 4, 2);
                        g2.drawLine(width - 3, 3, width - 3, 3);
                        g2.drawLine(width - 2, 4, width - 2, 5);
                        g2.drawLine(4, 1, 5, 1);
                        g2.drawLine(3, 2, 3, 2);
                        g2.drawLine(2, 3, 2, 3);
                        g2.drawLine(1, 4, 1, 5);
                        break;
                    }
                }
            } else {
                g2.drawRect(0, 0, width - 1, height - 1);
            }
        } else {
            super.paintContentBorder(g2, tabPlacement, selectedIndex);
        }
    }

    protected void paintContentBorder(Graphics g2, int x2, int y, int w2, int h2) {
        if (this.getTabShape() == 7) {
            if (this.showFocusIndicator()) {
                Insets insets = this.getContentBorderInsets(this._tabPane.getTabPlacement());
                Color selectedTitleColor2 = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground2");
                g2.setColor(selectedTitleColor2);
                g2.fillRect(x2, y, w2, insets.top);
                g2.fillRect(x2, y, insets.left, h2);
                g2.fillRect(x2, y + h2 - insets.bottom, w2, insets.bottom);
                g2.fillRect(x2 + w2 - insets.right, y, insets.right, h2);
            }
        } else {
            super.paintContentBorder(g2, x2, y, w2, h2);
        }
    }

    protected void paintContentBorderTopEdge(Graphics g2, int tabPlacement, int selectedIndex, int x2, int y, int w2, int h2) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r2 = this._rects[selectedIndex];
            g2.setColor(this.getPainter().getControlShadow());
            if (this.isTabLeadingComponentVisible() && selRect.x > 0) {
                g2.drawLine(x2, y, selRect.x, y);
            }
            if (r2.x > viewRect.x) {
                g2.drawLine(x2, y, selRect.x - 1, y);
            }
            if (this._tabPane.isTabShown()) {
                if (r2.x >= viewRect.x + viewRect.width) {
                    g2.drawLine(x2, y, x2 + w2 - 1, y);
                } else {
                    g2.drawLine(selRect.x + selRect.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9, y, x2 + w2 - 1, y);
                }
            }
        } else {
            super.paintContentBorderTopEdge(g2, tabPlacement, selectedIndex, x2, y, w2, h2);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g2, int tabPlacement, int selectedIndex, int x2, int y, int w2, int h2) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
            g2.setColor(this.getPainter().getControlShadow());
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r2 = this._rects[selectedIndex];
            if (this.isTabLeadingComponentVisible() && selRect.x > 0) {
                g2.drawLine(x2, y + h2 - 1, selRect.x, y + h2 - 1);
            }
            if (r2.x > viewRect.x) {
                g2.drawLine(x2, y + h2 - 1, selRect.x - 1, y + h2 - 1);
            }
            if (this._tabPane.isTabShown()) {
                if (r2.x >= viewRect.x + viewRect.width) {
                    g2.drawLine(x2, y + h2 - 1, x2 + w2 - 1, y + h2 - 1);
                } else {
                    g2.drawLine(selRect.x + selRect.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9, y + h2 - 1, x2 + w2 - 1, y + h2 - 1);
                }
            }
        } else {
            super.paintContentBorderBottomEdge(g2, tabPlacement, selectedIndex, x2, y, w2, h2);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g2, int tabPlacement, int selectedIndex, int x2, int y, int w2, int h2) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r2 = this._rects[selectedIndex];
            g2.setColor(this.getPainter().getControlShadow());
            if (this.isTabLeadingComponentVisible() && selRect.y > 0) {
                g2.drawLine(x2, y, x2, selRect.y);
            }
            if (r2.y - 2 > viewRect.y) {
                g2.drawLine(x2, y, x2, selRect.y - 3);
            }
            if (this._tabPane.isTabShown()) {
                if (r2.y >= viewRect.y + viewRect.height) {
                    g2.drawLine(x2, y, x2, y + h2 - 1);
                } else {
                    g2.drawLine(x2, selRect.y + selRect.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9, x2, y + h2 - 1);
                }
            }
        } else {
            super.paintContentBorderLeftEdge(g2, tabPlacement, selectedIndex, x2, y, w2, h2);
        }
    }

    protected void paintContentBorderRightEdge(Graphics g2, int tabPlacement, int selectedIndex, int x2, int y, int w2, int h2) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r2 = this._rects[selectedIndex];
            g2.setColor(this.getPainter().getControlShadow());
            if (this.isTabLeadingComponentVisible() && selRect.y > 0) {
                g2.drawLine(x2 + w2 - 1, y, x2 + w2 - 1, selRect.y);
            }
            if (r2.y - 2 > viewRect.y) {
                g2.drawLine(x2 + w2 - 1, y, x2 + w2 - 1, selRect.y - 3);
            }
            if (this._tabPane.isTabShown()) {
                if (r2.y >= viewRect.y + viewRect.height) {
                    g2.drawLine(x2 + w2 - 1, y, x2 + w2 - 1, y + h2 - 1);
                } else {
                    g2.drawLine(x2 + w2 - 1, selRect.y + selRect.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9, x2 + w2 - 1, y + h2 - 1);
                }
            }
        } else {
            super.paintContentBorderRightEdge(g2, tabPlacement, selectedIndex, x2, y, w2, h2);
        }
    }

    protected Rectangle getTabsTextBoundsAt(int tabIndex) {
        Rectangle tabRect = this._tabPane.getBoundsAt(tabIndex);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        String title = this._tabPane.getDisplayTitleAt(tabIndex);
        Icon icon = this._tabPane.getIconForTab(tabIndex);
        SwingUtilities.layoutCompoundLabel(this._tabPane, this._tabPane.getGraphics().getFontMetrics(this._tabPane.getFont()), title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, icon == null ? 0 : this._textIconGap);
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            iconRect.x = tabRect.x + this._iconMarginHorizon;
            textRect.x = icon != null ? iconRect.x + iconRect.width + this._textIconGap : tabRect.x + this._textPadding;
        } else {
            iconRect.y = tabRect.y + this._iconMarginVertical;
            textRect.y = icon != null ? iconRect.y + iconRect.height + this._textIconGap : tabRect.y + this._textPadding;
            iconRect.x = tabRect.x + 2;
            textRect.x = tabRect.x + 2;
        }
        return textRect;
    }

    protected void paintFocusIndicator(Graphics g2, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this._tabPane.hasFocus() && isSelected) {
            int h2;
            int w2;
            int y;
            int x2;
            g2.setColor(this._focus);
            switch (tabPlacement) {
                case 2: {
                    x2 = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w2 = tabRect.width - 4;
                    h2 = tabRect.height - 19;
                    break;
                }
                case 4: {
                    x2 = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w2 = tabRect.width - 4;
                    h2 = tabRect.height - 19;
                    break;
                }
                case 3: {
                    x2 = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w2 = tabRect.width - 19;
                    h2 = tabRect.height - 3;
                    break;
                }
                default: {
                    x2 = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w2 = tabRect.width - 19;
                    h2 = tabRect.height - 3;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g2, x2, y, w2, h2);
        }
    }

    protected BasicJideTabbedPaneUI.TabCloseButton createNoFocusButton(int type) {
        return new Eclipse3xTabCloseButton(type);
    }

    public class Eclipse3xTabCloseButton
    extends BasicJideTabbedPaneUI.TabCloseButton {
        public Eclipse3xTabCloseButton(int type) {
            super(type);
        }

        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        protected void paintComponent(Graphics g2) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            g2.setColor(UIDefaultsLookup.getColor("controlShadow").darker());
            int centerX = this.getWidth() >> 1;
            int centerY = this.getHeight() >> 1;
            switch (this.getType()) {
                case 0: {
                    g2.drawLine(centerX - 4, centerY - 4, centerX - 2, centerY - 4);
                    g2.drawLine(centerX - 4, centerY - 4, centerX - 4, centerY - 2);
                    g2.drawLine(centerX - 1, centerY - 3, centerX - 0, centerY - 2);
                    g2.drawLine(centerX - 3, centerY - 1, centerX - 2, centerY - 0);
                    g2.drawLine(centerX + 3, centerY - 4, centerX + 5, centerY - 4);
                    g2.drawLine(centerX + 5, centerY - 4, centerX + 5, centerY - 2);
                    g2.drawLine(centerX + 2, centerY - 3, centerX + 1, centerY - 2);
                    g2.drawLine(centerX + 4, centerY - 1, centerX + 3, centerY - 0);
                    g2.drawLine(centerX - 4, centerY + 5, centerX - 2, centerY + 5);
                    g2.drawLine(centerX - 4, centerY + 5, centerX - 4, centerY + 3);
                    g2.drawLine(centerX - 1, centerY + 4, centerX - 0, centerY + 3);
                    g2.drawLine(centerX - 3, centerY + 2, centerX - 2, centerY + 1);
                    g2.drawLine(centerX + 3, centerY + 5, centerX + 5, centerY + 5);
                    g2.drawLine(centerX + 5, centerY + 5, centerX + 5, centerY + 3);
                    g2.drawLine(centerX + 2, centerY + 4, centerX + 1, centerY + 3);
                    g2.drawLine(centerX + 4, centerY + 2, centerX + 3, centerY + 1);
                    if (this.isMouseOver()) {
                        g2.setColor(new Color(252, 160, 160));
                    } else {
                        g2.setColor(Color.WHITE);
                    }
                    g2.drawLine(centerX - 2, centerY - 3, centerX + 4, centerY + 3);
                    g2.drawLine(centerX - 3, centerY - 3, centerX + 4, centerY + 4);
                    g2.drawLine(centerX - 3, centerY - 2, centerX + 3, centerY + 4);
                    g2.drawLine(centerX - 3, centerY + 3, centerX + 3, centerY - 3);
                    g2.drawLine(centerX - 3, centerY + 4, centerX + 4, centerY - 3);
                    g2.drawLine(centerX - 2, centerY + 4, centerX + 4, centerY - 2);
                    break;
                }
                default: {
                    super.paintComponent(g2);
                }
            }
        }
    }
}

