/*
 * Decompiled with CFR 0.152.
 */
package com.iontorrent.utils;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringTools {
    public static ArrayList<Integer> parseInts(String pattern) {
        ArrayList<String> items = StringTools.parseList(pattern, ",");
        ArrayList<Integer> flows = new ArrayList<Integer>();
        for (String it : items) {
            if (it.indexOf("-") > 0) {
                ArrayList<Integer> nrs = StringTools.parseListtoInt(it, "-");
                if (nrs == null || nrs.size() != 2) continue;
                int a2 = nrs.get(0);
                int b2 = nrs.get(1);
                for (int f2 = a2; f2 <= b2; ++f2) {
                    flows.add(f2);
                }
                continue;
            }
            try {
                int f3 = Integer.parseInt(it);
                flows.add(f3);
            }
            catch (Exception e2) {
            }
        }
        return flows;
    }

    public static String addNL(String desc, String nl, int WIDTH) {
        if (desc == null || desc.length() < WIDTH) {
            return desc;
        }
        int oldnewlinepos = 0;
        int len = desc.length();
        StringBuffer newdesc = new StringBuffer(len + len / WIDTH + 1);
        int sp = desc.indexOf(" ");
        int oldsp = -1;
        int pos = 0;
        int newlinepos = 0;
        while (pos < desc.length()) {
            int linelen = sp - oldnewlinepos;
            if (linelen > WIDTH + 5) {
                newlinepos = oldsp;
                if (newlinepos < oldnewlinepos) {
                    newlinepos = sp;
                }
                if ((double)(linelen = newlinepos - oldnewlinepos) > 1.5 * (double)WIDTH) {
                    newlinepos = oldnewlinepos + WIDTH;
                }
                newdesc = newdesc.append(desc.substring(oldnewlinepos, newlinepos));
                newdesc = newdesc.append(nl);
                oldnewlinepos = newlinepos;
                pos = newlinepos + 1;
            } else {
                pos = sp + 1;
            }
            oldsp = sp;
            if (sp + 1 > desc.length()) break;
            sp = desc.indexOf(" ", pos);
            if (sp >= 0) continue;
            sp = desc.length() - 1;
        }
        pos = Math.max(oldnewlinepos, newlinepos);
        while (len - pos > WIDTH) {
            newdesc = newdesc.append(desc.substring(pos, pos + WIDTH));
            newdesc = newdesc.append(nl);
            pos += WIDTH;
        }
        newdesc = newdesc.append(desc.substring(pos, len));
        return newdesc.toString();
    }

    public static String replace(String source, String tag, String with) {
        if (source == null || tag == null || tag.length() == 0 || with == null || tag.equals(with)) {
            return source;
        }
        if (tag.indexOf(with) >= 0) {
            String s2 = source;
            int tagpos = -1;
            while ((tagpos = s2.indexOf(tag)) >= 0) {
                StringBuffer result = new StringBuffer();
                result.append(s2.subSequence(0, tagpos));
                result.append(with);
                result.append(s2.subSequence(tagpos + tag.length(), s2.length()));
                s2 = result.toString();
            }
            return s2;
        }
        StringBuffer result = new StringBuffer();
        int pos = 0;
        while (pos < source.length()) {
            int tagpos = source.indexOf(tag, pos);
            if (tagpos != -1) {
                if (tagpos > pos) {
                    result.append(source.substring(pos, tagpos));
                }
                result.append(with);
                pos = tagpos + tag.length();
                continue;
            }
            result.append(source.substring(pos));
            break;
        }
        return result.toString();
    }

    public static String getEnumeration(String[] list) {
        String result = "";
        if (list != null) {
            for (int i2 = 0; i2 < list.length; ++i2) {
                String element = list[i2];
                result = result + element;
                if (i2 + 1 >= list.length) continue;
                result = result + ", ";
            }
        }
        return result;
    }

    public static ArrayList<String> parseList(String list, String sep) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("[")) {
            list = list.substring(1);
        }
        if (list.endsWith("]")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<String> items = StringTools.splitString(list, sep);
        return items;
    }

    public static ArrayList<Double> parseListToDouble(String list, String sep) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("[")) {
            list = list.substring(1);
        }
        if (list.endsWith("]")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<Double> res = new ArrayList<Double>();
        ArrayList<String> items = StringTools.splitString(list, sep);
        for (String it : items) {
            double d2 = 0.0;
            try {
                d2 = Double.parseDouble(it);
            }
            catch (Exception e2) {
                // empty catch block
            }
            res.add(d2);
        }
        return res;
    }

    public static ArrayList<Long> parseListToLong(String list, String sep) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("[")) {
            list = list.substring(1);
        }
        if (list.endsWith("]")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<Long> res = new ArrayList<Long>();
        ArrayList<String> items = StringTools.splitString(list, sep);
        for (String it : items) {
            long d2 = 0L;
            try {
                d2 = Long.parseLong(it);
            }
            catch (Exception e2) {}
        }
        return res;
    }

    public static ArrayList<Integer> parseListtoInt(String list, String sep) {
        return StringTools.parseListtoInt(list, sep, Integer.MAX_VALUE);
    }

    public static ArrayList<Integer> parseListtoInt(String list, String sep, int max) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("[")) {
            list = list.substring(1);
        }
        if (list.endsWith("]")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        ArrayList<String> items = StringTools.splitString(list, sep);
        for (String it : items) {
            int val = 0;
            try {
                val = Integer.parseInt(it);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (val > max) {
                StringTools.warn("Value too large:" + val + ", should be < " + max);
                val = max;
            }
            res.add(val);
        }
        return res;
    }

    public static double[] parseListTodouble(String list, String sep) {
        ArrayList<Double> res = StringTools.parseListToDouble(list, sep);
        if (res == null) {
            return null;
        }
        double[] dd = new double[res.size()];
        for (int i2 = 0; i2 < res.size(); ++i2) {
            dd[i2] = res.get(i2);
        }
        return dd;
    }

    public static ArrayList<String> splitString(String line, String delim) {
        if (line == null) {
            StringTools.err("splitString: line is null");
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, delim);
        while (tokenizer.hasMoreElements()) {
            String next = tokenizer.nextToken().trim();
            if (next.startsWith("\"")) {
                next = next.substring(1, next.length());
            }
            if (next.endsWith("\"")) {
                next = next.substring(0, next.length() - 1);
            }
            res.add(next);
        }
        return res;
    }

    public static ArrayList<Long> splitStringToLongs(String line, String delim) {
        if (line == null) {
            StringTools.err("splitString: line is null");
            return null;
        }
        ArrayList<Long> res = new ArrayList<Long>();
        StringTokenizer tokenizer = new StringTokenizer(line, delim);
        while (tokenizer.hasMoreElements()) {
            String next = tokenizer.nextToken().trim();
            if (next.startsWith("\"")) {
                next = next.substring(1, next.length());
            }
            if (next.endsWith("\"")) {
                next = next.substring(0, next.length() - 1);
            }
            long d2 = 0L;
            try {
                d2 = Long.parseLong(next);
            }
            catch (Exception e2) {
                // empty catch block
            }
            res.add(d2);
        }
        return res;
    }

    public static String toStringList(ArrayList v2) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; v2 != null && i2 < v2.size(); ++i2) {
            String s2 = v2.get(i2).toString();
            sb = sb.append(s2);
            if (i2 + 1 >= v2.size()) continue;
            sb = sb.append(";");
        }
        return sb.toString();
    }

    public static String toStringList(String[] v2) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; v2 != null && i2 < v2.length; ++i2) {
            String s2 = v2[i2];
            sb = sb.append(s2);
            if (i2 + 1 >= v2.length) continue;
            sb = sb.append(";");
        }
        return sb.toString();
    }

    public static String[] toString(ArrayList v2) {
        if (v2 == null || v2.size() < 1) {
            return null;
        }
        String[] ss = new String[v2.size()];
        for (int i2 = 0; v2 != null && i2 < v2.size(); ++i2) {
            ss[i2] = v2.get(i2).toString();
        }
        return ss;
    }

    public static ArrayList<String> toArrayList(String[] ss) {
        if (ss == null || ss.length < 1) {
            return null;
        }
        ArrayList<String> v2 = new ArrayList<String>(ss.length);
        for (int i2 = 0; ss != null && i2 < ss.length; ++i2) {
            v2.add(ss[i2]);
        }
        return v2;
    }

    public static String getEnglishEnumeration(ArrayList<String> list) {
        String result = "";
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String element = list.get(i2);
                result = result + element;
                if (i2 + 2 < list.size()) {
                    result = result + ", ";
                }
                if (i2 + 2 != list.size()) continue;
                result = result + " and ";
            }
        }
        return result;
    }

    public static ArrayList<String> parseList(String list) {
        list = StringTools.replace(list, " ", ",");
        return StringTools.parseList(list, ",");
    }

    private void err(String msg, Exception ex) {
        Logger.getLogger(StringTools.class.getName()).log(Level.SEVERE, msg, ex);
    }

    private static void err(String msg) {
        Logger.getLogger(StringTools.class.getName()).log(Level.SEVERE, msg);
    }

    private static void warn(String msg) {
        Logger.getLogger(StringTools.class.getName()).log(Level.WARNING, msg);
    }

    private void p(String msg) {
    }
}

