/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;

public final class EdmondsKarpMaximumFlow<V, E> {
    public static final double DEFAULT_EPSILON = 1.0E-9;
    private DirectedGraph<V, E> network;
    private double epsilon;
    private int currentSource;
    private int currentSink;
    private Map<E, Double> maximumFlow;
    private Double maximumFlowValue;
    private int numNodes;
    private Map<V, Integer> indexer;
    private List<Node> nodes;

    public EdmondsKarpMaximumFlow(DirectedGraph<V, E> directedGraph) {
        this(directedGraph, 1.0E-9);
    }

    public EdmondsKarpMaximumFlow(DirectedGraph<V, E> directedGraph, double d2) {
        if (directedGraph == null) {
            throw new NullPointerException("network is null");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("invalid epsilon (must be positive)");
        }
        for (Object e2 : directedGraph.edgeSet()) {
            if (!(directedGraph.getEdgeWeight(e2) < -d2)) continue;
            throw new IllegalArgumentException("invalid capacity (must be non-negative)");
        }
        this.network = directedGraph;
        this.epsilon = d2;
        this.currentSource = -1;
        this.currentSink = -1;
        this.maximumFlow = null;
        this.maximumFlowValue = null;
        this.buildInternalNetwork();
    }

    private void buildInternalNetwork() {
        Object v2;
        int n2;
        this.numNodes = this.network.vertexSet().size();
        this.nodes = new ArrayList<Node>();
        Iterator iterator = this.network.vertexSet().iterator();
        this.indexer = new HashMap<V, Integer>();
        for (n2 = 0; n2 < this.numNodes; ++n2) {
            v2 = iterator.next();
            this.nodes.add(new Node(v2));
            this.indexer.put((Integer)v2, n2);
        }
        for (n2 = 0; n2 < this.numNodes; ++n2) {
            v2 = this.nodes.get((int)n2).prototype;
            for (E e2 : this.network.outgoingEdgesOf(v2)) {
                Arc arc;
                Object v3 = this.network.getEdgeTarget(e2);
                int n3 = this.indexer.get(v3);
                Arc arc2 = new Arc(n2, n3, this.network.getEdgeWeight(e2), e2);
                arc2.reversed = arc = new Arc(n3, n2, 0.0, null);
                arc.reversed = arc2;
                this.nodes.get((int)n2).outgoingArcs.add(arc2);
                this.nodes.get((int)n3).outgoingArcs.add(arc);
            }
        }
    }

    public void calculateMaximumFlow(V v2, V v3) {
        int n2;
        if (!this.network.containsVertex(v2)) {
            throw new IllegalArgumentException("invalid source (null or not from this network)");
        }
        if (!this.network.containsVertex(v3)) {
            throw new IllegalArgumentException("invalid sink (null or not from this network)");
        }
        if (v2.equals(v3)) {
            throw new IllegalArgumentException("source is equal to sink");
        }
        this.currentSource = this.indexer.get(v2);
        this.currentSink = this.indexer.get(v3);
        for (n2 = 0; n2 < this.numNodes; ++n2) {
            for (Arc arc : this.nodes.get((int)n2).outgoingArcs) {
                arc.flow = 0.0;
            }
        }
        this.maximumFlowValue = 0.0;
        while (true) {
            this.breadthFirstSearch();
            if (!this.nodes.get((int)this.currentSink).visited) {
                this.maximumFlow = new HashMap<E, Double>();
                for (n2 = 0; n2 < this.numNodes; ++n2) {
                    for (Arc arc : this.nodes.get((int)n2).outgoingArcs) {
                        if (arc.prototype == null) continue;
                        this.maximumFlow.put(arc.prototype, arc.flow);
                    }
                }
                return;
            }
            this.augmentFlow();
        }
    }

    private void breadthFirstSearch() {
        for (int i2 = 0; i2 < this.numNodes; ++i2) {
            this.nodes.get((int)i2).visited = false;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.offer(this.currentSource);
        this.nodes.get((int)this.currentSource).visited = true;
        this.nodes.get((int)this.currentSource).flowAmount = Double.POSITIVE_INFINITY;
        while (linkedList.size() != 0) {
            int n2 = (Integer)linkedList.poll();
            for (Arc arc : this.nodes.get((int)n2).outgoingArcs) {
                if (!(arc.flow + this.epsilon < arc.capacity) || this.nodes.get((int)arc.head).visited) continue;
                this.nodes.get((int)arc.head).visited = true;
                this.nodes.get((int)arc.head).flowAmount = Math.min(this.nodes.get((int)n2).flowAmount, arc.capacity - arc.flow);
                this.nodes.get((int)arc.head).lastArc = arc;
                linkedList.add(arc.head);
            }
        }
    }

    private void augmentFlow() {
        double d2 = this.nodes.get((int)this.currentSink).flowAmount;
        this.maximumFlowValue = this.maximumFlowValue + d2;
        int n2 = this.currentSink;
        while (n2 != this.currentSource) {
            this.nodes.get((int)n2).lastArc.flow += d2;
            this.nodes.get((int)n2).lastArc.reversed.flow -= d2;
            n2 = this.nodes.get((int)n2).lastArc.tail;
        }
    }

    public Double getMaximumFlowValue() {
        return this.maximumFlowValue;
    }

    public Map<E, Double> getMaximumFlow() {
        if (this.maximumFlow == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.maximumFlow);
    }

    public V getCurrentSource() {
        if (this.currentSource == -1) {
            return null;
        }
        return this.nodes.get((int)this.currentSource).prototype;
    }

    public V getCurrentSink() {
        if (this.currentSink == -1) {
            return null;
        }
        return this.nodes.get((int)this.currentSink).prototype;
    }

    class Arc {
        int tail;
        int head;
        double capacity;
        double flow;
        Arc reversed;
        E prototype;

        Arc(int n2, int n3, double d2, E e2) {
            this.tail = n2;
            this.head = n3;
            this.capacity = d2;
            this.prototype = e2;
        }
    }

    class Node {
        V prototype;
        List<Arc> outgoingArcs = new ArrayList<Arc>();
        boolean visited;
        Arc lastArc;
        double flowAmount;

        Node(V v2) {
            this.prototype = v2;
        }
    }
}

