/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.haplotypeBAMWriter;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTag;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.gatk.engine.io.GATKSAMFileWriter;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.haplotypeBAMWriter.AllHaplotypeBAMWriter;
import org.broadinstitute.gatk.utils.haplotypeBAMWriter.CalledHaplotypeBAMWriter;
import org.broadinstitute.gatk.utils.haplotypeBAMWriter.ReadDestination;
import org.broadinstitute.gatk.utils.sam.AlignmentUtils;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public abstract class HaplotypeBAMWriter {
    private long uniqueNameCounter = 1L;
    protected static final String READ_GROUP_ID = "ArtificialHaplotype";
    private final ReadDestination output;
    private boolean writeHaplotypesAsWell = true;
    private boolean onlyRealignInformativeReads = false;

    public static HaplotypeBAMWriter create(Type type, GATKSAMFileWriter stingSAMWriter, SAMFileHeader header) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        ReadDestination.ToBAM toBam = new ReadDestination.ToBAM(stingSAMWriter, header, READ_GROUP_ID);
        return HaplotypeBAMWriter.create(type, toBam);
    }

    public static HaplotypeBAMWriter create(Type type, ReadDestination destination) {
        if (destination == null) {
            throw new IllegalArgumentException("writer cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        switch (type) {
            case ALL_POSSIBLE_HAPLOTYPES: {
                return new AllHaplotypeBAMWriter(destination);
            }
            case CALLED_HAPLOTYPES: {
                return new CalledHaplotypeBAMWriter(destination);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    protected HaplotypeBAMWriter(ReadDestination output) {
        this.output = output;
    }

    public abstract void writeReadsAlignedToHaplotypes(Collection<Haplotype> var1, GenomeLoc var2, Collection<Haplotype> var3, Set<Haplotype> var4, Map<String, PerReadAlleleLikelihoodMap> var5);

    public void writeReadsAlignedToHaplotypes(Collection<Haplotype> haplotypes, GenomeLoc paddedReferenceLoc, Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap) {
        this.writeReadsAlignedToHaplotypes(haplotypes, paddedReferenceLoc, haplotypes, new HashSet<Haplotype>(haplotypes), stratifiedReadMap);
    }

    protected void writeReadAgainstHaplotype(GATKSAMRecord originalRead) {
        this.output.add(originalRead);
    }

    protected void writeHaplotypesAsReads(Collection<Haplotype> haplotypes, Set<Haplotype> bestHaplotypes, GenomeLoc paddedReferenceLoc) {
        if (this.isWriteHaplotypesAsWell()) {
            for (Haplotype haplotype : haplotypes) {
                this.writeHaplotype(haplotype, paddedReferenceLoc, bestHaplotypes.contains(haplotype));
            }
        }
    }

    private void writeHaplotype(Haplotype haplotype, GenomeLoc paddedRefLoc, boolean isAmongBestHaplotypes) {
        GATKSAMRecord record = new GATKSAMRecord(this.output.getHeader());
        record.setReadBases(haplotype.getBases());
        record.setAlignmentStart(paddedRefLoc.getStart() + haplotype.getAlignmentStartHapwrtRef());
        record.setBaseQualities(Utils.dupBytes((byte)33, haplotype.getBases().length));
        record.setCigar(AlignmentUtils.consolidateCigar(haplotype.getCigar()));
        record.setMappingQuality(isAmongBestHaplotypes ? 60 : 0);
        record.setReadName("HC" + this.uniqueNameCounter++);
        record.setAttribute("HC", (Object)haplotype.hashCode());
        record.setReadUnmappedFlag(false);
        record.setReferenceIndex(paddedRefLoc.getContigIndex());
        record.setAttribute(SAMTag.RG.toString(), (Object)READ_GROUP_ID);
        record.setFlags(16);
        this.output.add(record);
    }

    public boolean isWriteHaplotypesAsWell() {
        return this.writeHaplotypesAsWell;
    }

    public void setWriteHaplotypesAsWell(boolean writeHaplotypesAsWell) {
        this.writeHaplotypesAsWell = writeHaplotypesAsWell;
    }

    public boolean getOnlyRealignInformativeReads() {
        return this.onlyRealignInformativeReads;
    }

    public void setOnlyRealignInformativeReads(boolean onlyRealignInformativeReads) {
        this.onlyRealignInformativeReads = onlyRealignInformativeReads;
    }

    public static enum Type {
        ALL_POSSIBLE_HAPLOTYPES,
        CALLED_HAPLOTYPES;

    }
}

