/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.GOST3410KeyParameters;
import org.bouncycastle.crypto.params.GOST3410Parameters;
import org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import org.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class GOST3410Signer
implements DSA {
    GOST3410KeyParameters key;
    SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (GOST3410PrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (GOST3410PrivateKeyParameters)param;
            }
        } else {
            this.key = (GOST3410PublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger k2;
        byte[] mRev = new byte[message.length];
        for (int i2 = 0; i2 != mRev.length; ++i2) {
            mRev[i2] = message[mRev.length - 1 - i2];
        }
        BigInteger m2 = new BigInteger(1, mRev);
        GOST3410Parameters params = this.key.getParameters();
        while ((k2 = new BigInteger(params.getQ().bitLength(), this.random)).compareTo(params.getQ()) >= 0) {
        }
        BigInteger r2 = params.getA().modPow(k2, params.getP()).mod(params.getQ());
        BigInteger s2 = k2.multiply(m2).add(((GOST3410PrivateKeyParameters)this.key).getX().multiply(r2)).mod(params.getQ());
        BigInteger[] res = new BigInteger[]{r2, s2};
        return res;
    }

    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        byte[] mRev = new byte[message.length];
        for (int i2 = 0; i2 != mRev.length; ++i2) {
            mRev[i2] = message[mRev.length - 1 - i2];
        }
        BigInteger m2 = new BigInteger(1, mRev);
        GOST3410Parameters params = this.key.getParameters();
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r2) >= 0 || params.getQ().compareTo(r2) <= 0) {
            return false;
        }
        if (zero.compareTo(s2) >= 0 || params.getQ().compareTo(s2) <= 0) {
            return false;
        }
        BigInteger v2 = m2.modPow(params.getQ().subtract(new BigInteger("2")), params.getQ());
        BigInteger z1 = s2.multiply(v2).mod(params.getQ());
        BigInteger z2 = params.getQ().subtract(r2).multiply(v2).mod(params.getQ());
        z1 = params.getA().modPow(z1, params.getP());
        z2 = ((GOST3410PublicKeyParameters)this.key).getY().modPow(z2, params.getP());
        BigInteger u2 = z1.multiply(z2).mod(params.getP()).mod(params.getQ());
        return u2.equals(r2);
    }
}

