/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class ISAACEngine
implements StreamCipher {
    private final int sizeL = 8;
    private final int stateArraySize = 256;
    private int[] engineState = null;
    private int[] results = null;
    private int a = 0;
    private int b = 0;
    private int c = 0;
    private int index = 0;
    private byte[] keyStream = new byte[1024];
    private byte[] workingKey = null;
    private boolean initialised = false;

    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to ISAAC init - " + params.getClass().getName());
        }
        KeyParameter p2 = (KeyParameter)params;
        this.setKey(p2.getKey());
    }

    public byte returnByte(byte in) {
        if (this.index == 0) {
            this.isaac();
            this.keyStream = this.intToByteLittle(this.results);
        }
        byte out = (byte)(this.keyStream[this.index] ^ in);
        this.index = this.index + 1 & 0x3FF;
        return out;
    }

    public void processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.index == 0) {
                this.isaac();
                this.keyStream = this.intToByteLittle(this.results);
            }
            out[i2 + outOff] = (byte)(this.keyStream[this.index] ^ in[i2 + inOff]);
            this.index = this.index + 1 & 0x3FF;
        }
    }

    public String getAlgorithmName() {
        return "ISAAC";
    }

    public void reset() {
        this.setKey(this.workingKey);
    }

    private void setKey(byte[] keyBytes) {
        int i2;
        this.workingKey = keyBytes;
        if (this.engineState == null) {
            this.engineState = new int[256];
        }
        if (this.results == null) {
            this.results = new int[256];
        }
        for (i2 = 0; i2 < 256; ++i2) {
            this.results[i2] = 0;
            this.engineState[i2] = 0;
        }
        this.c = 0;
        this.b = 0;
        this.a = 0;
        this.index = 0;
        byte[] t2 = new byte[keyBytes.length + (keyBytes.length & 3)];
        System.arraycopy(keyBytes, 0, t2, 0, keyBytes.length);
        for (i2 = 0; i2 < t2.length; i2 += 4) {
            this.results[i2 >> 2] = this.byteToIntLittle(t2, i2);
        }
        int[] abcdefgh = new int[8];
        for (i2 = 0; i2 < 8; ++i2) {
            abcdefgh[i2] = -1640531527;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            this.mix(abcdefgh);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            for (int j2 = 0; j2 < 256; j2 += 8) {
                int k2;
                for (k2 = 0; k2 < 8; ++k2) {
                    int n2 = k2;
                    abcdefgh[n2] = abcdefgh[n2] + (i2 < 1 ? this.results[j2 + k2] : this.engineState[j2 + k2]);
                }
                this.mix(abcdefgh);
                for (k2 = 0; k2 < 8; ++k2) {
                    this.engineState[j2 + k2] = abcdefgh[k2];
                }
            }
        }
        this.isaac();
        this.initialised = true;
    }

    private void isaac() {
        this.b += ++this.c;
        for (int i2 = 0; i2 < 256; ++i2) {
            int y;
            int x2 = this.engineState[i2];
            switch (i2 & 3) {
                case 0: {
                    this.a ^= this.a << 13;
                    break;
                }
                case 1: {
                    this.a ^= this.a >>> 6;
                    break;
                }
                case 2: {
                    this.a ^= this.a << 2;
                    break;
                }
                case 3: {
                    this.a ^= this.a >>> 16;
                }
            }
            this.a += this.engineState[i2 + 128 & 0xFF];
            this.engineState[i2] = y = this.engineState[x2 >>> 2 & 0xFF] + this.a + this.b;
            this.results[i2] = this.b = this.engineState[y >>> 10 & 0xFF] + x2;
        }
    }

    private void mix(int[] x2) {
        x2[0] = x2[0] ^ x2[1] << 11;
        x2[3] = x2[3] + x2[0];
        x2[1] = x2[1] + x2[2];
        x2[1] = x2[1] ^ x2[2] >>> 2;
        x2[4] = x2[4] + x2[1];
        x2[2] = x2[2] + x2[3];
        x2[2] = x2[2] ^ x2[3] << 8;
        x2[5] = x2[5] + x2[2];
        x2[3] = x2[3] + x2[4];
        x2[3] = x2[3] ^ x2[4] >>> 16;
        x2[6] = x2[6] + x2[3];
        x2[4] = x2[4] + x2[5];
        x2[4] = x2[4] ^ x2[5] << 10;
        x2[7] = x2[7] + x2[4];
        x2[5] = x2[5] + x2[6];
        x2[5] = x2[5] ^ x2[6] >>> 4;
        x2[0] = x2[0] + x2[5];
        x2[6] = x2[6] + x2[7];
        x2[6] = x2[6] ^ x2[7] << 8;
        x2[1] = x2[1] + x2[6];
        x2[7] = x2[7] + x2[0];
        x2[7] = x2[7] ^ x2[0] >>> 9;
        x2[2] = x2[2] + x2[7];
        x2[0] = x2[0] + x2[1];
    }

    private int byteToIntLittle(byte[] x2, int offset) {
        return x2[offset++] & 0xFF | (x2[offset++] & 0xFF) << 8 | (x2[offset++] & 0xFF) << 16 | x2[offset++] << 24;
    }

    private byte[] intToByteLittle(int x2) {
        byte[] out = new byte[4];
        out[3] = (byte)x2;
        out[2] = (byte)(x2 >>> 8);
        out[1] = (byte)(x2 >>> 16);
        out[0] = (byte)(x2 >>> 24);
        return out;
    }

    private byte[] intToByteLittle(int[] x2) {
        byte[] out = new byte[4 * x2.length];
        int i2 = 0;
        int j2 = 0;
        while (i2 < x2.length) {
            System.arraycopy(this.intToByteLittle(x2[i2]), 0, out, j2, 4);
            ++i2;
            j2 += 4;
        }
        return out;
    }
}

