/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.OtherRecipientInfo;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;

public class RecipientInfo
extends ASN1Object
implements ASN1Choice {
    ASN1Encodable info;

    public RecipientInfo(KeyTransRecipientInfo info) {
        this.info = info;
    }

    public RecipientInfo(KeyAgreeRecipientInfo info) {
        this.info = new DERTaggedObject(false, 1, info);
    }

    public RecipientInfo(KEKRecipientInfo info) {
        this.info = new DERTaggedObject(false, 2, info);
    }

    public RecipientInfo(PasswordRecipientInfo info) {
        this.info = new DERTaggedObject(false, 3, info);
    }

    public RecipientInfo(OtherRecipientInfo info) {
        this.info = new DERTaggedObject(false, 4, info);
    }

    public RecipientInfo(ASN1Primitive info) {
        this.info = info;
    }

    public static RecipientInfo getInstance(Object o2) {
        if (o2 == null || o2 instanceof RecipientInfo) {
            return (RecipientInfo)o2;
        }
        if (o2 instanceof ASN1Sequence) {
            return new RecipientInfo((ASN1Sequence)o2);
        }
        if (o2 instanceof ASN1TaggedObject) {
            return new RecipientInfo((ASN1TaggedObject)o2);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o2.getClass().getName());
    }

    public ASN1Integer getVersion() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject o2 = (ASN1TaggedObject)this.info;
            switch (o2.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(o2, false).getVersion();
                }
                case 2: {
                    return this.getKEKInfo(o2).getVersion();
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(o2, false).getVersion();
                }
                case 4: {
                    return new ASN1Integer(0);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info).getVersion();
    }

    public boolean isTagged() {
        return this.info instanceof ASN1TaggedObject;
    }

    public ASN1Encodable getInfo() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject o2 = (ASN1TaggedObject)this.info;
            switch (o2.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(o2, false);
                }
                case 2: {
                    return this.getKEKInfo(o2);
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(o2, false);
                }
                case 4: {
                    return OtherRecipientInfo.getInstance(o2, false);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info);
    }

    private KEKRecipientInfo getKEKInfo(ASN1TaggedObject o2) {
        if (o2.isExplicit()) {
            return KEKRecipientInfo.getInstance(o2, true);
        }
        return KEKRecipientInfo.getInstance(o2, false);
    }

    public ASN1Primitive toASN1Primitive() {
        return this.info.toASN1Primitive();
    }
}

