/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.apache.commons.math.distribution.PoissonDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.FastMath;

public class PoissonDistributionImpl
extends AbstractIntegerDistribution
implements PoissonDistribution,
Serializable {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private NormalDistribution normal;
    private double mean;
    private int maxIterations = 10000000;
    private double epsilon = 1.0E-12;

    public PoissonDistributionImpl(double p2) {
        this(p2, new NormalDistributionImpl());
    }

    public PoissonDistributionImpl(double p2, double epsilon, int maxIterations) {
        this.setMean(p2);
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
    }

    public PoissonDistributionImpl(double p2, double epsilon) {
        this.setMean(p2);
        this.epsilon = epsilon;
    }

    public PoissonDistributionImpl(double p2, int maxIterations) {
        this.setMean(p2);
        this.maxIterations = maxIterations;
    }

    @Deprecated
    public PoissonDistributionImpl(double p2, NormalDistribution z) {
        this.setNormalAndMeanInternal(z, p2);
    }

    public double getMean() {
        return this.mean;
    }

    @Deprecated
    public void setMean(double p2) {
        this.setNormalAndMeanInternal(this.normal, p2);
    }

    private void setNormalAndMeanInternal(NormalDistribution z, double p2) {
        if (p2 <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_POISSON_MEAN, p2);
        }
        this.mean = p2;
        this.normal = z;
        this.normal.setMean(p2);
        this.normal.setStandardDeviation(FastMath.sqrt(p2));
    }

    public double probability(int x2) {
        double ret = x2 < 0 || x2 == Integer.MAX_VALUE ? 0.0 : (x2 == 0 ? FastMath.exp(-this.mean) : FastMath.exp(-SaddlePointExpansion.getStirlingError(x2) - SaddlePointExpansion.getDeviancePart(x2, this.mean)) / FastMath.sqrt(Math.PI * 2 * (double)x2));
        return ret;
    }

    public double cumulativeProbability(int x2) throws MathException {
        if (x2 < 0) {
            return 0.0;
        }
        if (x2 == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)x2 + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int x2) throws MathException {
        return this.normal.cumulativeProbability((double)x2 + 0.5);
    }

    public int sample() throws MathException {
        return (int)FastMath.min(this.randomData.nextPoisson(this.mean), Integer.MAX_VALUE);
    }

    protected int getDomainLowerBound(double p2) {
        return 0;
    }

    protected int getDomainUpperBound(double p2) {
        return Integer.MAX_VALUE;
    }

    @Deprecated
    public void setNormal(NormalDistribution value) {
        this.setNormalAndMeanInternal(value, this.mean);
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public double getNumericalVariance() {
        return this.getMean();
    }
}

