/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class BlockGunzipper {
    private final Inflater inflater = new Inflater(true);
    private final CRC32 crc32 = new CRC32();
    private boolean checkCrcs = false;

    public void setCheckCrcs(boolean check) {
        this.checkCrcs = check;
    }

    void unzipBlock(byte[] uncompressedBlock, byte[] compressedBlock, int compressedLength) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(compressedBlock, 0, compressedLength);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (byteBuffer.get() != 31 || byteBuffer.get() != -117 || byteBuffer.get() != 8 || byteBuffer.get() != 4) {
                throw new SAMFormatException("Invalid GZIP header");
            }
            byteBuffer.position(byteBuffer.position() + 6);
            if (byteBuffer.getShort() != 6) {
                throw new SAMFormatException("Invalid GZIP header");
            }
            byteBuffer.position(byteBuffer.position() + 4);
            int totalBlockSize = (byteBuffer.getShort() & 0xFFFF) + 1;
            if (totalBlockSize != compressedLength) {
                throw new SAMFormatException("GZIP blocksize disagreement");
            }
            int deflatedSize = compressedLength - 18 - 8;
            byteBuffer.position(byteBuffer.position() + deflatedSize);
            int expectedCrc = byteBuffer.getInt();
            int uncompressedSize = byteBuffer.getInt();
            this.inflater.reset();
            this.inflater.setInput(compressedBlock, 18, deflatedSize);
            int inflatedBytes = this.inflater.inflate(uncompressedBlock, 0, uncompressedSize);
            if (inflatedBytes != uncompressedSize) {
                throw new SAMFormatException("Did not inflate expected amount");
            }
            if (this.checkCrcs) {
                this.crc32.reset();
                this.crc32.update(uncompressedBlock, 0, uncompressedSize);
                long crc = this.crc32.getValue();
                if ((int)crc != expectedCrc) {
                    throw new SAMFormatException("CRC mismatch");
                }
            }
        }
        catch (DataFormatException e2) {
            throw new RuntimeException(e2);
        }
    }
}

