/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

public enum TruthStatus {
    FALSE_POSITIVE("False positive"),
    TRUE_POSITIVE("True positive"),
    UNKNOWN("Unknown"),
    SUSPECT("Suspect site"),
    DISCORDANT("Discordant");

    final String statusText;
    static final TruthStatus[][] CONSENSUS_MATRIX;

    private TruthStatus(String statusText) {
        this.statusText = statusText;
    }

    public boolean isFalsePositive() {
        return this == FALSE_POSITIVE;
    }

    public boolean isTruePositive() {
        return this == TRUE_POSITIVE;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isSuspect() {
        return this == SUSPECT;
    }

    public boolean isDiscordance() {
        return this == DISCORDANT;
    }

    private static void addToConsensusMatrix(TruthStatus t1, TruthStatus t2, TruthStatus result) {
        TruthStatus.CONSENSUS_MATRIX[t1.ordinal()][t2.ordinal()] = result;
        TruthStatus.CONSENSUS_MATRIX[t2.ordinal()][t1.ordinal()] = result;
    }

    @Deprecated
    final TruthStatus makeConsensus(TruthStatus otherStatus) {
        return CONSENSUS_MATRIX[this.ordinal()][otherStatus.ordinal()];
    }

    static {
        CONSENSUS_MATRIX = new TruthStatus[TruthStatus.values().length][TruthStatus.values().length];
        for (TruthStatus t1 : TruthStatus.values()) {
            for (TruthStatus t2 : TruthStatus.values()) {
                TruthStatus.addToConsensusMatrix(t1, t2, DISCORDANT);
            }
        }
        for (TruthStatus t2 : TruthStatus.values()) {
            TruthStatus.addToConsensusMatrix(t2, t2, t2);
            TruthStatus.addToConsensusMatrix(t2, UNKNOWN, t2);
            TruthStatus.addToConsensusMatrix(t2, SUSPECT, SUSPECT);
        }
        TruthStatus.addToConsensusMatrix(SUSPECT, FALSE_POSITIVE, FALSE_POSITIVE);
        TruthStatus.addToConsensusMatrix(TRUE_POSITIVE, FALSE_POSITIVE, DISCORDANT);
    }
}

