/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools;

import htsjdk.samtools.util.PeekableIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.SimpleTimer;
import org.broadinstitute.gatk.utils.collections.LoggingNestedIntegerArray;
import org.broadinstitute.gatk.utils.collections.NestedIntegerArray;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.CommandLineProgram;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.recalibration.RecalDatum;
import org.broadinstitute.gatk.utils.text.XReadLines;

public class ProfileNestedIntegerArray
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(ProfileNestedIntegerArray.class);
    @Argument(fullName="operationLog", shortName="operationLog", doc="File containing output from a LoggingNestedIntegerArray containing the update operations to perform during testing", required=true)
    private File operationLog = null;
    @Argument(fullName="threadPoolSize", shortName="threadPoolSize", doc="Size of the thread pool to use for this test", required=false)
    private int threadPoolSize = 1;
    @Argument(fullName="maxEnqueuedTasks", shortName="maxEnqueuedTasks", doc="Maximum number of tasks that can be submitted to the thread pool at once", required=false)
    private int maxEnqueuedTasks = 10000;
    @Argument(fullName="operationsPerThread", shortName="operationsPerThread", doc="Number of array operations to execute within each thread", required=false)
    private int operationsPerThread = 100000;
    @Argument(fullName="operationBufferSize", shortName="operationBufferSize", doc="Number of operations to load at a time from the log file before dispatching them for execution", required=false)
    private int operationBufferSize = 20000000;
    @Argument(fullName="debug", shortName="debug", doc="Output debugging information", required=false)
    private boolean debug = false;
    private PeekableIterator<String> operationLogIterator;
    private Iterator<ArrayOperation> operationIterator;
    private List<BulkArrayOperationRunner> bulkArrayOperationBuffer;
    private Map<String, NestedIntegerArray<RecalDatum>> arrays;
    private ExecutorService threadPool;
    private Semaphore threadPoolSlot;

    @Override
    protected int execute() throws Exception {
        this.operationLogIterator = new PeekableIterator<String>(new XReadLines(this.operationLog, false));
        this.arrays = new HashMap<String, NestedIntegerArray<RecalDatum>>();
        this.initializeArrays();
        this.operationIterator = new ArrayOperationIterator();
        this.bulkArrayOperationBuffer = new ArrayList<BulkArrayOperationRunner>(this.operationBufferSize / this.operationsPerThread + 1);
        this.threadPool = Executors.newFixedThreadPool(this.threadPoolSize);
        this.threadPoolSlot = new Semaphore(this.maxEnqueuedTasks);
        logger.info("Running test with settings:");
        logger.info(String.format("operationLog=%s threadPoolSize=%d maxEnqueuedTasks=%d operationsPerThread=%d operationBufferSize=%d", this.operationLog, this.threadPoolSize, this.maxEnqueuedTasks, this.operationsPerThread, this.operationBufferSize));
        SimpleTimer wallClockTimer = new SimpleTimer("wallClock");
        wallClockTimer.start();
        this.runTest();
        wallClockTimer.stop();
        logger.info(String.format("Total wall clock time: %.2f seconds (%.2f minutes)", wallClockTimer.getElapsedTime(), wallClockTimer.getElapsedTime() / 60.0));
        return 0;
    }

    private void initializeArrays() {
        while (this.operationLogIterator.hasNext() && this.operationLogIterator.peek().startsWith("# ")) {
            String headerLine = this.operationLogIterator.next().substring("# ".length());
            String[] tokens = headerLine.split("\t", -1);
            if (tokens.length < 2) {
                throw new UserException.MalformedFile(this.operationLog, "Found a header line with too few tokens (no dimensions specified)");
            }
            String arrayLabel = tokens[0];
            int[] dimensions = new int[tokens.length - 1];
            for (int i2 = 1; i2 < tokens.length; ++i2) {
                try {
                    dimensions[i2 - 1] = Integer.parseInt(tokens[i2]);
                    continue;
                }
                catch (NumberFormatException e2) {
                    throw new UserException.MalformedFile(this.operationLog, "Error parsing a numerical header field", (Exception)e2);
                }
            }
            this.arrays.put(arrayLabel, new NestedIntegerArray(dimensions));
            if (!this.debug) continue;
            logger.info(String.format("Created NestedIntegerArray %s with dimensions %s", arrayLabel, Arrays.toString(dimensions)));
        }
        if (this.arrays.size() == 0) {
            throw new UserException.MalformedFile(this.operationLog, "No array metadata was found in the header");
        }
    }

    private void runTest() {
        try {
            int maxObservedEnqueuedOperations = 0;
            long enqueuedOperationsRunningTotal = 0L;
            int numObservations = 0;
            do {
                this.bufferUpcomingOperations();
                for (BulkArrayOperationRunner bulkOperation : this.bulkArrayOperationBuffer) {
                    int currentlyEnqueuedOperations = this.maxEnqueuedTasks - this.threadPoolSlot.availablePermits();
                    maxObservedEnqueuedOperations = Math.max(maxObservedEnqueuedOperations, currentlyEnqueuedOperations);
                    enqueuedOperationsRunningTotal += (long)currentlyEnqueuedOperations;
                    ++numObservations;
                    this.threadPoolSlot.acquire();
                    this.threadPool.execute(bulkOperation);
                }
            } while (this.bulkArrayOperationBuffer.size() > 0);
            this.threadPool.shutdown();
            if (!this.threadPool.awaitTermination(300L, TimeUnit.SECONDS)) {
                throw new ReviewedGATKException("Final tasks in thread pool did not complete within a reasonable amount of time");
            }
            logger.info(String.format("Max observed enqueued operations: %d\tAverage # of enqueued operations: %.2f", maxObservedEnqueuedOperations, (double)enqueuedOperationsRunningTotal / (double)numObservations));
        }
        catch (InterruptedException e2) {
            this.threadPool.shutdownNow();
            throw new ReviewedGATKException("Thread interrupted during execution");
        }
    }

    private void bufferUpcomingOperations() {
        this.bulkArrayOperationBuffer.clear();
        int totalOperationsLoaded = 0;
        while (this.operationIterator.hasNext() && totalOperationsLoaded < this.operationBufferSize) {
            ArrayList<ArrayOperation> operations = new ArrayList<ArrayOperation>(this.operationsPerThread);
            while (this.operationIterator.hasNext() && operations.size() < this.operationsPerThread && totalOperationsLoaded < this.operationBufferSize) {
                operations.add(this.operationIterator.next());
                ++totalOperationsLoaded;
            }
            this.bulkArrayOperationBuffer.add(new BulkArrayOperationRunner(operations));
        }
    }

    public static void main(String[] args) {
        try {
            ProfileNestedIntegerArray instance = new ProfileNestedIntegerArray();
            ProfileNestedIntegerArray.start(instance, args);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e2) {
            ProfileNestedIntegerArray.exitSystemWithUserError(e2);
        }
        catch (Exception e3) {
            ProfileNestedIntegerArray.exitSystemWithError(e3);
        }
    }

    private class ArrayOperationIterator
    implements Iterator<ArrayOperation>,
    Iterable<ArrayOperation> {
        private ArrayOperation nextOperation = null;

        public ArrayOperationIterator() {
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextOperation != null;
        }

        @Override
        public ArrayOperation next() {
            if (this.nextOperation == null) {
                throw new NoSuchElementException("next() called when there are no more items");
            }
            ArrayOperation toReturn = this.nextOperation;
            this.advance();
            return toReturn;
        }

        private void advance() {
            LoggingNestedIntegerArray.NestedIntegerArrayOperation operationType;
            if (!ProfileNestedIntegerArray.this.operationLogIterator.hasNext()) {
                this.nextOperation = null;
                return;
            }
            String nextOperationLogEntry = (String)ProfileNestedIntegerArray.this.operationLogIterator.next();
            String[] tokens = nextOperationLogEntry.split("\t", -1);
            if (tokens.length < 4) {
                throw new UserException.MalformedFile(ProfileNestedIntegerArray.this.operationLog, String.format("Found an array operation log entry with less than 4 fields: %s", nextOperationLogEntry));
            }
            String arrayLabel = tokens[0];
            try {
                operationType = LoggingNestedIntegerArray.NestedIntegerArrayOperation.valueOf(tokens[1]);
            }
            catch (IllegalArgumentException e2) {
                throw new UserException.MalformedFile(ProfileNestedIntegerArray.this.operationLog, String.format("Illegal operation type %s in log entry %s", tokens[1], nextOperationLogEntry));
            }
            RecalDatum datum = tokens[2].length() > 0 ? this.parseRecalDatumString(tokens[2]) : null;
            int[] keys = new int[tokens.length - 3];
            for (int i2 = 3; i2 < tokens.length; ++i2) {
                try {
                    keys[i2 - 3] = Integer.parseInt(tokens[i2]);
                    continue;
                }
                catch (NumberFormatException e3) {
                    throw new UserException.MalformedFile(ProfileNestedIntegerArray.this.operationLog, String.format("Found an array operation log entry with non-integer key: %s", nextOperationLogEntry), (Exception)e3);
                }
            }
            this.nextOperation = new ArrayOperation(operationType, arrayLabel, datum, keys);
        }

        private RecalDatum parseRecalDatumString(String recalDatumString) {
            byte quality;
            double numMismatches;
            long numObservations;
            String[] tokens = recalDatumString.split(",", -1);
            try {
                numObservations = (long)Double.parseDouble(tokens[0]);
                numMismatches = Double.parseDouble(tokens[1]);
                quality = (byte)Math.round(Double.parseDouble(tokens[2]));
            }
            catch (NumberFormatException e2) {
                throw new UserException.MalformedFile(ProfileNestedIntegerArray.this.operationLog, String.format("Failed to parse RecalDatum string %s", recalDatumString), (Exception)e2);
            }
            return new RecalDatum(numObservations, numMismatches, quality);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<ArrayOperation> iterator() {
            return this;
        }
    }

    private class ArrayOperation
    implements Runnable {
        private LoggingNestedIntegerArray.NestedIntegerArrayOperation operationType;
        private String arrayLabel;
        private RecalDatum datum;
        private int[] keys;

        public ArrayOperation(LoggingNestedIntegerArray.NestedIntegerArrayOperation operationType, String arrayLabel, RecalDatum datum, int[] keys) {
            this.operationType = operationType;
            this.arrayLabel = arrayLabel;
            this.datum = datum;
            this.keys = (int[])keys.clone();
        }

        @Override
        public void run() {
            NestedIntegerArray array;
            if (ProfileNestedIntegerArray.this.debug) {
                logger.info(String.format("Running task %s", this.toString()));
            }
            if ((array = (NestedIntegerArray)ProfileNestedIntegerArray.this.arrays.get(this.arrayLabel)) == null) {
                throw new ReviewedGATKException(String.format("Attempted to access non-existent array %s", this.arrayLabel));
            }
            switch (this.operationType) {
                case GET: {
                    RecalDatum existingDatum = (RecalDatum)array.get(this.keys);
                    if (existingDatum == null) break;
                    existingDatum.increment(true);
                    break;
                }
                case PUT: {
                    array.put(this.datum, this.keys);
                }
            }
        }

        public String toString() {
            return String.format("[%s in table %s, datum: %s keys: %s]", new Object[]{this.operationType, this.arrayLabel, this.datum != null ? this.datum : "(none)", Arrays.toString(this.keys)});
        }
    }

    private class BulkArrayOperationRunner
    implements Runnable {
        private List<ArrayOperation> operations;

        public BulkArrayOperationRunner(List<ArrayOperation> operations) {
            this.operations = operations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (ArrayOperation operation : this.operations) {
                    operation.run();
                }
            }
            finally {
                ProfileNestedIntegerArray.this.threadPoolSlot.release();
            }
        }
    }
}

