/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;

class SimpleBigDecimal {
    private static final long serialVersionUID = 1L;
    private final BigInteger bigInt;
    private final int scale;

    public static SimpleBigDecimal getInstance(BigInteger value, int scale) {
        return new SimpleBigDecimal(value.shiftLeft(scale), scale);
    }

    public SimpleBigDecimal(BigInteger bigInt, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale may not be negative");
        }
        this.bigInt = bigInt;
        this.scale = scale;
    }

    private SimpleBigDecimal(SimpleBigDecimal limBigDec) {
        this.bigInt = limBigDec.bigInt;
        this.scale = limBigDec.scale;
    }

    private void checkScale(SimpleBigDecimal b2) {
        if (this.scale != b2.scale) {
            throw new IllegalArgumentException("Only SimpleBigDecimal of same scale allowed in arithmetic operations");
        }
    }

    public SimpleBigDecimal adjustScale(int newScale) {
        if (newScale < 0) {
            throw new IllegalArgumentException("scale may not be negative");
        }
        if (newScale == this.scale) {
            return new SimpleBigDecimal(this);
        }
        return new SimpleBigDecimal(this.bigInt.shiftLeft(newScale - this.scale), newScale);
    }

    public SimpleBigDecimal add(SimpleBigDecimal b2) {
        this.checkScale(b2);
        return new SimpleBigDecimal(this.bigInt.add(b2.bigInt), this.scale);
    }

    public SimpleBigDecimal add(BigInteger b2) {
        return new SimpleBigDecimal(this.bigInt.add(b2.shiftLeft(this.scale)), this.scale);
    }

    public SimpleBigDecimal negate() {
        return new SimpleBigDecimal(this.bigInt.negate(), this.scale);
    }

    public SimpleBigDecimal subtract(SimpleBigDecimal b2) {
        return this.add(b2.negate());
    }

    public SimpleBigDecimal subtract(BigInteger b2) {
        return new SimpleBigDecimal(this.bigInt.subtract(b2.shiftLeft(this.scale)), this.scale);
    }

    public SimpleBigDecimal multiply(SimpleBigDecimal b2) {
        this.checkScale(b2);
        return new SimpleBigDecimal(this.bigInt.multiply(b2.bigInt), this.scale + this.scale);
    }

    public SimpleBigDecimal multiply(BigInteger b2) {
        return new SimpleBigDecimal(this.bigInt.multiply(b2), this.scale);
    }

    public SimpleBigDecimal divide(SimpleBigDecimal b2) {
        this.checkScale(b2);
        BigInteger dividend = this.bigInt.shiftLeft(this.scale);
        return new SimpleBigDecimal(dividend.divide(b2.bigInt), this.scale);
    }

    public SimpleBigDecimal divide(BigInteger b2) {
        return new SimpleBigDecimal(this.bigInt.divide(b2), this.scale);
    }

    public SimpleBigDecimal shiftLeft(int n2) {
        return new SimpleBigDecimal(this.bigInt.shiftLeft(n2), this.scale);
    }

    public int compareTo(SimpleBigDecimal val) {
        this.checkScale(val);
        return this.bigInt.compareTo(val.bigInt);
    }

    public int compareTo(BigInteger val) {
        return this.bigInt.compareTo(val.shiftLeft(this.scale));
    }

    public BigInteger floor() {
        return this.bigInt.shiftRight(this.scale);
    }

    public BigInteger round() {
        SimpleBigDecimal oneHalf = new SimpleBigDecimal(ECConstants.ONE, 1);
        return this.add(oneHalf.adjustScale(this.scale)).floor();
    }

    public int intValue() {
        return this.floor().intValue();
    }

    public long longValue() {
        return this.floor().longValue();
    }

    public int getScale() {
        return this.scale;
    }

    public String toString() {
        if (this.scale == 0) {
            return this.bigInt.toString();
        }
        BigInteger floorBigInt = this.floor();
        BigInteger fract = this.bigInt.subtract(floorBigInt.shiftLeft(this.scale));
        if (this.bigInt.signum() == -1) {
            fract = ECConstants.ONE.shiftLeft(this.scale).subtract(fract);
        }
        if (floorBigInt.signum() == -1 && !fract.equals(ECConstants.ZERO)) {
            floorBigInt = floorBigInt.add(ECConstants.ONE);
        }
        String leftOfPoint = floorBigInt.toString();
        char[] fractCharArr = new char[this.scale];
        String fractStr = fract.toString(2);
        int fractLen = fractStr.length();
        int zeroes = this.scale - fractLen;
        for (int i2 = 0; i2 < zeroes; ++i2) {
            fractCharArr[i2] = 48;
        }
        for (int j2 = 0; j2 < fractLen; ++j2) {
            fractCharArr[zeroes + j2] = fractStr.charAt(j2);
        }
        String rightOfPoint = new String(fractCharArr);
        StringBuffer sb = new StringBuffer(leftOfPoint);
        sb.append(".");
        sb.append(rightOfPoint);
        return sb.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof SimpleBigDecimal)) {
            return false;
        }
        SimpleBigDecimal other = (SimpleBigDecimal)o2;
        return this.bigInt.equals(other.bigInt) && this.scale == other.scale;
    }

    public int hashCode() {
        return this.bigInt.hashCode() ^ this.scale;
    }
}

