/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.Mac;

public class MacInputStream
extends FilterInputStream {
    protected Mac mac;

    public MacInputStream(InputStream stream, Mac mac) {
        super(stream);
        this.mac = mac;
    }

    public int read() throws IOException {
        int b2 = this.in.read();
        if (b2 >= 0) {
            this.mac.update((byte)b2);
        }
        return b2;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int n2 = this.in.read(b2, off, len);
        if (n2 >= 0) {
            this.mac.update(b2, off, n2);
        }
        return n2;
    }

    public Mac getMac() {
        return this.mac;
    }
}

