/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import org.bouncycastle.crypto.params.GOST3410Parameters;
import org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import org.bouncycastle.crypto.params.GOST3410PublicKeyParameters;

public class GOST3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private GOST3410KeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (GOST3410KeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x2;
        GOST3410Parameters GOST3410Params2 = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q2 = GOST3410Params2.getQ();
        BigInteger p2 = GOST3410Params2.getP();
        BigInteger a2 = GOST3410Params2.getA();
        while ((x2 = new BigInteger(256, random)).equals(ZERO) || x2.compareTo(q2) >= 0) {
        }
        BigInteger y = a2.modPow(x2, p2);
        return new AsymmetricCipherKeyPair(new GOST3410PublicKeyParameters(y, GOST3410Params2), new GOST3410PrivateKeyParameters(x2, GOST3410Params2));
    }
}

