/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.BinaryFunction;
import org.apache.commons.math.analysis.ComposableFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.MathUnsupportedOperationException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.AbstractRealMatrix;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.OpenMapRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SparseRealVector;
import org.apache.commons.math.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRealVector
implements RealVector {
    protected void checkVectorDimensions(RealVector v2) {
        this.checkVectorDimensions(v2.getDimension());
    }

    protected void checkVectorDimensions(int n2) throws DimensionMismatchException {
        int d2 = this.getDimension();
        if (d2 != n2) {
            throw new DimensionMismatchException(d2, n2);
        }
    }

    protected void checkIndex(int index) throws MatrixIndexException {
        if (index < 0 || index >= this.getDimension()) {
            throw new MatrixIndexException(LocalizedFormats.INDEX_OUT_OF_RANGE, index, 0, this.getDimension() - 1);
        }
    }

    @Override
    public void setSubVector(int index, RealVector v2) throws MatrixIndexException {
        this.checkIndex(index);
        this.checkIndex(index + v2.getDimension() - 1);
        this.setSubVector(index, v2.getData());
    }

    @Override
    public void setSubVector(int index, double[] v2) throws MatrixIndexException {
        this.checkIndex(index);
        this.checkIndex(index + v2.length - 1);
        for (int i2 = 0; i2 < v2.length; ++i2) {
            this.setEntry(i2 + index, v2[i2]);
        }
    }

    @Override
    public RealVector add(double[] v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        double[] result = (double[])v2.clone();
        Iterator<RealVector.Entry> it = this.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            int n2 = e2.getIndex();
            result[n2] = result[n2] + e2.getValue();
        }
        return new ArrayRealVector(result, false);
    }

    @Override
    public RealVector add(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        if (v2 instanceof ArrayRealVector) {
            double[] values = ((ArrayRealVector)v2).getDataRef();
            return this.add(values);
        }
        RealVector result = v2.copy();
        Iterator<RealVector.Entry> it = this.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            int index = e2.getIndex();
            result.setEntry(index, e2.getValue() + result.getEntry(index));
        }
        return result;
    }

    @Override
    public RealVector subtract(double[] v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        double[] result = (double[])v2.clone();
        Iterator<RealVector.Entry> it = this.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            int index = e2.getIndex();
            result[index] = e2.getValue() - result[index];
        }
        return new ArrayRealVector(result, false);
    }

    @Override
    public RealVector subtract(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        if (v2 instanceof ArrayRealVector) {
            double[] values = ((ArrayRealVector)v2).getDataRef();
            return this.add(values);
        }
        RealVector result = v2.copy();
        Iterator<RealVector.Entry> it = this.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            int index = e2.getIndex();
            v2.setEntry(index, e2.getValue() - result.getEntry(index));
        }
        return result;
    }

    @Override
    public RealVector mapAdd(double d2) {
        return this.copy().mapAddToSelf(d2);
    }

    @Override
    public RealVector mapAddToSelf(double d2) {
        if (d2 != 0.0) {
            try {
                return this.mapToSelf(BinaryFunction.ADD.fix1stArgument(d2));
            }
            catch (FunctionEvaluationException e2) {
                throw new IllegalArgumentException(e2);
            }
        }
        return this;
    }

    @Override
    public abstract AbstractRealVector copy();

    @Override
    public double dotProduct(double[] v2) throws IllegalArgumentException {
        return this.dotProduct(new ArrayRealVector(v2, false));
    }

    @Override
    public double dotProduct(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        this.checkVectorDimensions(v2);
        double d2 = 0.0;
        Iterator<RealVector.Entry> it = this.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            d2 += e2.getValue() * v2.getEntry(e2.getIndex());
        }
        return d2;
    }

    @Override
    public RealVector ebeDivide(double[] v2) throws IllegalArgumentException {
        return this.ebeDivide(new ArrayRealVector(v2, false));
    }

    @Override
    public RealVector ebeMultiply(double[] v2) throws IllegalArgumentException {
        return this.ebeMultiply(new ArrayRealVector(v2, false));
    }

    @Override
    public double getDistance(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        this.checkVectorDimensions(v2);
        double d2 = 0.0;
        Iterator<RealVector.Entry> it = this.iterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            double diff = e2.getValue() - v2.getEntry(e2.getIndex());
            d2 += diff * diff;
        }
        return FastMath.sqrt(d2);
    }

    @Override
    public double getNorm() {
        RealVector.Entry e2;
        double sum = 0.0;
        Iterator<RealVector.Entry> it = this.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            double value = e2.getValue();
            sum += value * value;
        }
        return FastMath.sqrt(sum);
    }

    @Override
    public double getL1Norm() {
        RealVector.Entry e2;
        double norm = 0.0;
        Iterator<RealVector.Entry> it = this.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            norm += FastMath.abs(e2.getValue());
        }
        return norm;
    }

    @Override
    public double getLInfNorm() {
        RealVector.Entry e2;
        double norm = 0.0;
        Iterator<RealVector.Entry> it = this.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            norm = FastMath.max(norm, FastMath.abs(e2.getValue()));
        }
        return norm;
    }

    @Override
    public double getDistance(double[] v2) throws IllegalArgumentException {
        return this.getDistance(new ArrayRealVector(v2, false));
    }

    @Override
    public double getL1Distance(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        this.checkVectorDimensions(v2);
        double d2 = 0.0;
        Iterator<RealVector.Entry> it = this.iterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            d2 += FastMath.abs(e2.getValue() - v2.getEntry(e2.getIndex()));
        }
        return d2;
    }

    @Override
    public double getL1Distance(double[] v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        this.checkVectorDimensions(v2.length);
        double d2 = 0.0;
        Iterator<RealVector.Entry> it = this.iterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            d2 += FastMath.abs(e2.getValue() - v2[e2.getIndex()]);
        }
        return d2;
    }

    @Override
    public double getLInfDistance(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        this.checkVectorDimensions(v2);
        double d2 = 0.0;
        Iterator<RealVector.Entry> it = this.iterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            d2 = FastMath.max(FastMath.abs(e2.getValue() - v2.getEntry(e2.getIndex())), d2);
        }
        return d2;
    }

    @Override
    public double getLInfDistance(double[] v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        this.checkVectorDimensions(v2.length);
        double d2 = 0.0;
        Iterator<RealVector.Entry> it = this.iterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            d2 = FastMath.max(FastMath.abs(e2.getValue() - v2[e2.getIndex()]), d2);
        }
        return d2;
    }

    public int getMinIndex() {
        int minIndex = -1;
        double minValue = Double.POSITIVE_INFINITY;
        Iterator<RealVector.Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector.Entry entry = iterator.next();
            if (!(entry.getValue() <= minValue)) continue;
            minIndex = entry.getIndex();
            minValue = entry.getValue();
        }
        return minIndex;
    }

    public double getMinValue() {
        int minIndex = this.getMinIndex();
        return minIndex < 0 ? Double.NaN : this.getEntry(minIndex);
    }

    public int getMaxIndex() {
        int maxIndex = -1;
        double maxValue = Double.NEGATIVE_INFINITY;
        Iterator<RealVector.Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector.Entry entry = iterator.next();
            if (!(entry.getValue() >= maxValue)) continue;
            maxIndex = entry.getIndex();
            maxValue = entry.getValue();
        }
        return maxIndex;
    }

    public double getMaxValue() {
        int maxIndex = this.getMaxIndex();
        return maxIndex < 0 ? Double.NaN : this.getEntry(maxIndex);
    }

    @Override
    public RealVector mapAbs() {
        return this.copy().mapAbsToSelf();
    }

    @Override
    public RealVector mapAbsToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.ABS);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapAcos() {
        return this.copy().mapAcosToSelf();
    }

    @Override
    public RealVector mapAcosToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.ACOS);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapAsin() {
        return this.copy().mapAsinToSelf();
    }

    @Override
    public RealVector mapAsinToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.ASIN);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapAtan() {
        return this.copy().mapAtanToSelf();
    }

    @Override
    public RealVector mapAtanToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.ATAN);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapCbrt() {
        return this.copy().mapCbrtToSelf();
    }

    @Override
    public RealVector mapCbrtToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.CBRT);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapCeil() {
        return this.copy().mapCeilToSelf();
    }

    @Override
    public RealVector mapCeilToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.CEIL);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapCos() {
        return this.copy().mapCosToSelf();
    }

    @Override
    public RealVector mapCosToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.COS);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapCosh() {
        return this.copy().mapCoshToSelf();
    }

    @Override
    public RealVector mapCoshToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.COSH);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapDivide(double d2) {
        return this.copy().mapDivideToSelf(d2);
    }

    @Override
    public RealVector mapDivideToSelf(double d2) {
        try {
            return this.mapToSelf(BinaryFunction.DIVIDE.fix2ndArgument(d2));
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapExp() {
        return this.copy().mapExpToSelf();
    }

    @Override
    public RealVector mapExpToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.EXP);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapExpm1() {
        return this.copy().mapExpm1ToSelf();
    }

    @Override
    public RealVector mapExpm1ToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.EXPM1);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapFloor() {
        return this.copy().mapFloorToSelf();
    }

    @Override
    public RealVector mapFloorToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.FLOOR);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapInv() {
        return this.copy().mapInvToSelf();
    }

    @Override
    public RealVector mapInvToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.INVERT);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapLog() {
        return this.copy().mapLogToSelf();
    }

    @Override
    public RealVector mapLogToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.LOG);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapLog10() {
        return this.copy().mapLog10ToSelf();
    }

    @Override
    public RealVector mapLog10ToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.LOG10);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapLog1p() {
        return this.copy().mapLog1pToSelf();
    }

    @Override
    public RealVector mapLog1pToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.LOG1P);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapMultiply(double d2) {
        return this.copy().mapMultiplyToSelf(d2);
    }

    @Override
    public RealVector mapMultiplyToSelf(double d2) {
        try {
            return this.mapToSelf(BinaryFunction.MULTIPLY.fix1stArgument(d2));
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapPow(double d2) {
        return this.copy().mapPowToSelf(d2);
    }

    @Override
    public RealVector mapPowToSelf(double d2) {
        try {
            return this.mapToSelf(BinaryFunction.POW.fix2ndArgument(d2));
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapRint() {
        return this.copy().mapRintToSelf();
    }

    @Override
    public RealVector mapRintToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.RINT);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapSignum() {
        return this.copy().mapSignumToSelf();
    }

    @Override
    public RealVector mapSignumToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.SIGNUM);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapSin() {
        return this.copy().mapSinToSelf();
    }

    @Override
    public RealVector mapSinToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.SIN);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapSinh() {
        return this.copy().mapSinhToSelf();
    }

    @Override
    public RealVector mapSinhToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.SINH);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapSqrt() {
        return this.copy().mapSqrtToSelf();
    }

    @Override
    public RealVector mapSqrtToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.SQRT);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapSubtract(double d2) {
        return this.copy().mapSubtractToSelf(d2);
    }

    @Override
    public RealVector mapSubtractToSelf(double d2) {
        return this.mapAddToSelf(-d2);
    }

    @Override
    public RealVector mapTan() {
        return this.copy().mapTanToSelf();
    }

    @Override
    public RealVector mapTanToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.TAN);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapTanh() {
        return this.copy().mapTanhToSelf();
    }

    @Override
    public RealVector mapTanhToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.TANH);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealVector mapUlp() {
        return this.copy().mapUlpToSelf();
    }

    @Override
    public RealVector mapUlpToSelf() {
        try {
            return this.mapToSelf(ComposableFunction.ULP);
        }
        catch (FunctionEvaluationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public RealMatrix outerProduct(RealVector v2) throws IllegalArgumentException {
        AbstractRealMatrix product = v2 instanceof SparseRealVector || this instanceof SparseRealVector ? new OpenMapRealMatrix(this.getDimension(), v2.getDimension()) : new Array2DRowRealMatrix(this.getDimension(), v2.getDimension());
        Iterator<RealVector.Entry> thisIt = this.sparseIterator();
        RealVector.Entry thisE = null;
        while (thisIt.hasNext() && (thisE = thisIt.next()) != null) {
            Iterator<RealVector.Entry> otherIt = v2.sparseIterator();
            RealVector.Entry otherE = null;
            while (otherIt.hasNext() && (otherE = otherIt.next()) != null) {
                product.setEntry(thisE.getIndex(), otherE.getIndex(), thisE.getValue() * otherE.getValue());
            }
        }
        return product;
    }

    @Override
    public RealMatrix outerProduct(double[] v2) throws IllegalArgumentException {
        return this.outerProduct(new ArrayRealVector(v2, false));
    }

    @Override
    public RealVector projection(double[] v2) throws IllegalArgumentException {
        return this.projection(new ArrayRealVector(v2, false));
    }

    @Override
    public void set(double value) {
        Iterator<RealVector.Entry> it = this.iterator();
        RealVector.Entry e2 = null;
        while (it.hasNext() && (e2 = it.next()) != null) {
            e2.setValue(value);
        }
    }

    @Override
    public double[] toArray() {
        int dim = this.getDimension();
        double[] values = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            values[i2] = this.getEntry(i2);
        }
        return values;
    }

    @Override
    public double[] getData() {
        return this.toArray();
    }

    @Override
    public RealVector unitVector() {
        AbstractRealVector copy = this.copy();
        copy.unitize();
        return copy;
    }

    @Override
    public void unitize() {
        this.mapDivideToSelf(this.getNorm());
    }

    @Override
    public Iterator<RealVector.Entry> sparseIterator() {
        return new SparseEntryIterator();
    }

    @Override
    public Iterator<RealVector.Entry> iterator() {
        final int dim = this.getDimension();
        return new Iterator<RealVector.Entry>(){
            private int i = 0;
            private EntryImpl e = new EntryImpl();

            @Override
            public boolean hasNext() {
                return this.i < dim;
            }

            @Override
            public RealVector.Entry next() {
                this.e.setIndex(this.i++);
                return this.e;
            }

            @Override
            public void remove() {
                throw new MathUnsupportedOperationException(new Object[0]);
            }
        };
    }

    @Override
    public RealVector map(UnivariateRealFunction function) throws FunctionEvaluationException {
        return this.copy().mapToSelf(function);
    }

    @Override
    public RealVector mapToSelf(UnivariateRealFunction function) throws FunctionEvaluationException {
        RealVector.Entry e2;
        Iterator<RealVector.Entry> it;
        Iterator<RealVector.Entry> iterator = it = function.value(0.0) == 0.0 ? this.sparseIterator() : this.iterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            e2.setValue(function.value(e2.getValue()));
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SparseEntryIterator
    implements Iterator<RealVector.Entry> {
        private final int dim;
        private EntryImpl current;
        private EntryImpl next;

        protected SparseEntryIterator() {
            this.dim = AbstractRealVector.this.getDimension();
            this.current = new EntryImpl();
            this.next = new EntryImpl();
            if (this.next.getValue() == 0.0) {
                this.advance(this.next);
            }
        }

        protected void advance(EntryImpl e2) {
            if (e2 == null) {
                return;
            }
            do {
                e2.setIndex(e2.getIndex() + 1);
            } while (e2.getIndex() < this.dim && e2.getValue() == 0.0);
            if (e2.getIndex() >= this.dim) {
                e2.setIndex(-1);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next.getIndex() >= 0;
        }

        @Override
        public RealVector.Entry next() {
            int index = this.next.getIndex();
            if (index < 0) {
                throw new NoSuchElementException();
            }
            this.current.setIndex(index);
            this.advance(this.next);
            return this.current;
        }

        @Override
        public void remove() {
            throw new MathUnsupportedOperationException(new Object[0]);
        }
    }

    protected class EntryImpl
    extends RealVector.Entry {
        public EntryImpl() {
            this.setIndex(0);
        }

        public double getValue() {
            return AbstractRealVector.this.getEntry(this.getIndex());
        }

        public void setValue(double newValue) {
            AbstractRealVector.this.setEntry(this.getIndex(), newValue);
        }
    }
}

